/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeBeforeTooltipCollectCallback;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.platform.CustomEnchantPower;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ProgressView;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.CallbackContainer;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.entry.BooleanConfigEntry;
import snownee.jade.impl.config.entry.EnumConfigEntry;
import snownee.jade.impl.config.entry.FloatConfigEntry;
import snownee.jade.impl.config.entry.IntConfigEntry;
import snownee.jade.impl.config.entry.StringConfigEntry;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.ModIdentification;

public class WailaClientRegistration
implements IWailaClientRegistration {
    private static final WailaClientRegistration INSTANCE = new WailaClientRegistration();
    public final HierarchyLookup<IBlockComponentProvider> blockIconProviders;
    public final HierarchyLookup<IBlockComponentProvider> blockComponentProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityIconProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityComponentProviders;
    public final Set<class_2248> hideBlocks = Sets.newHashSet();
    public final Set<class_1299<?>> hideEntities = Sets.newHashSet();
    public final Set<class_2248> pickBlocks = Sets.newHashSet();
    public final Set<class_1299<?>> pickEntities = Sets.newHashSet();
    public final CallbackContainer<JadeAfterRenderCallback> afterRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeBeforeRenderCallback> beforeRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeRayTraceCallback> rayTraceCallback = new CallbackContainer();
    public final CallbackContainer<JadeTooltipCollectedCallback> tooltipCollectedCallback = new CallbackContainer();
    public final CallbackContainer<JadeItemModNameCallback> itemModNameCallback = new CallbackContainer();
    public final CallbackContainer<JadeBeforeTooltipCollectCallback> beforeTooltipCollectCallback = new CallbackContainer();
    public final Map<class_2248, CustomEnchantPower> customEnchantPowers = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_1799, ItemView>> itemStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, FluidView>> fluidStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, EnergyView>> energyStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, ProgressView>> progressProviders = Maps.newHashMap();
    public final Set<class_2960> clientFeatures = Sets.newHashSet();
    public final Map<Class<Accessor<?>>, AccessorClientHandler<Accessor<?>>> accessorHandlers = Maps.newIdentityHashMap();

    WailaClientRegistration() {
        this.blockIconProviders = new HierarchyLookup(class_2248.class);
        this.blockComponentProviders = new HierarchyLookup(class_2248.class);
        this.entityIconProviders = new HierarchyLookup(class_1297.class);
        this.entityComponentProviders = new HierarchyLookup(class_1297.class);
    }

    public static WailaClientRegistration instance() {
        return INSTANCE;
    }

    @Override
    public void registerBlockIcon(IBlockComponentProvider provider, Class<? extends class_2248> block) {
        this.blockIconProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerBlockComponent(IBlockComponentProvider provider, Class<? extends class_2248> block) {
        this.blockComponentProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityIcon(IEntityComponentProvider provider, Class<? extends class_1297> entity) {
        this.entityIconProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityComponent(IEntityComponentProvider provider, Class<? extends class_1297> entity) {
        this.entityComponentProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    public List<IBlockComponentProvider> getBlockProviders(class_2248 block, Predicate<IBlockComponentProvider> filter) {
        return this.blockComponentProviders.get(block).stream().filter(filter).toList();
    }

    public List<IBlockComponentProvider> getBlockIconProviders(class_2248 block, Predicate<IBlockComponentProvider> filter) {
        return this.blockIconProviders.get(block).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityProviders(class_1297 entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityComponentProviders.get(entity).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityIconProviders(class_1297 entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityIconProviders.get(entity).stream().filter(filter).toList();
    }

    @Override
    public void hideTarget(class_2248 block) {
        Objects.requireNonNull(block);
        this.hideBlocks.add(block);
    }

    @Override
    public void hideTarget(class_1299<?> entityType) {
        Objects.requireNonNull(entityType);
        this.hideEntities.add(entityType);
    }

    @Override
    public void usePickedResult(class_2248 block) {
        Objects.requireNonNull(block);
        this.pickBlocks.add(block);
    }

    @Override
    public void usePickedResult(class_1299<?> entityType) {
        Objects.requireNonNull(entityType);
        this.pickEntities.add(entityType);
    }

    @Override
    public boolean shouldHide(class_2680 state) {
        return this.hideBlocks.contains(state.method_26204());
    }

    @Override
    public boolean shouldPick(class_2680 state) {
        return this.pickBlocks.contains(state.method_26204());
    }

    @Override
    public boolean shouldHide(class_1297 entity) {
        return this.hideEntities.contains(entity.method_5864());
    }

    @Override
    public boolean shouldPick(class_1297 entity) {
        return this.pickEntities.contains(entity.method_5864());
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        PluginConfig.INSTANCE.addConfig(new BooleanConfigEntry(key, defaultValue));
    }

    @Override
    public void addConfig(class_2960 key, Enum<?> defaultValue) {
        Objects.requireNonNull(defaultValue);
        PluginConfig.INSTANCE.addConfig(new EnumConfigEntry(key, defaultValue));
    }

    @Override
    public void addConfig(class_2960 key, String defaultValue, Predicate<String> validator) {
        Objects.requireNonNull(defaultValue);
        Objects.requireNonNull(validator);
        PluginConfig.INSTANCE.addConfig(new StringConfigEntry(key, defaultValue, validator));
    }

    @Override
    public void addConfig(class_2960 key, int defaultValue, int min, int max, boolean slider) {
        PluginConfig.INSTANCE.addConfig(new IntConfigEntry(key, defaultValue, min, max, slider));
    }

    @Override
    public void addConfig(class_2960 key, float defaultValue, float min, float max, boolean slider) {
        PluginConfig.INSTANCE.addConfig(new FloatConfigEntry(key, defaultValue, min, max, slider));
    }

    @Override
    public void addConfigListener(class_2960 key, Consumer<class_2960> listener) {
        PluginConfig.INSTANCE.addConfigListener(key, listener);
    }

    @Override
    public void setConfigCategoryOverride(class_2960 key, class_2561 override) {
        PluginConfig.INSTANCE.setCategoryOverride(key, override);
    }

    @Override
    public void setConfigCategoryOverride(class_2960 key, List<class_2561> override) {
        PluginConfig.INSTANCE.setCategoryOverride(key, override);
    }

    private void tryAddConfig(IToggleableProvider provider) {
        if (!provider.isRequired() && !PluginConfig.INSTANCE.containsKey(provider.getUid())) {
            this.addConfig(provider.getUid(), provider.enabledByDefault());
        }
    }

    public void loadComplete() {
        PriorityStore<class_2960, IJadeProvider> priorities = WailaCommonRegistration.instance().priorities;
        this.blockComponentProviders.loadComplete(priorities);
        this.blockIconProviders.loadComplete(priorities);
        this.entityComponentProviders.loadComplete(priorities);
        this.entityIconProviders.loadComplete(priorities);
        Stream.of(this.afterRenderCallback, this.beforeRenderCallback, this.rayTraceCallback, this.tooltipCollectedCallback, this.itemModNameCallback, this.beforeTooltipCollectCallback).forEach(CallbackContainer::sort);
    }

    @Override
    public void addAfterRenderCallback(int priority, JadeAfterRenderCallback callback) {
        this.afterRenderCallback.add(priority, callback);
    }

    @Override
    public void addBeforeRenderCallback(int priority, JadeBeforeRenderCallback callback) {
        this.beforeRenderCallback.add(priority, callback);
    }

    @Override
    public void addRayTraceCallback(int priority, JadeRayTraceCallback callback) {
        this.rayTraceCallback.add(priority, callback);
    }

    @Override
    public void addTooltipCollectedCallback(int priority, JadeTooltipCollectedCallback callback) {
        this.tooltipCollectedCallback.add(priority, callback);
    }

    @Override
    public void addItemModNameCallback(int priority, JadeItemModNameCallback callback) {
        this.itemModNameCallback.add(priority, callback);
    }

    @Override
    public void addBeforeTooltipCollectCallback(int priority, JadeBeforeTooltipCollectCallback callback) {
        this.beforeTooltipCollectCallback.add(priority, callback);
    }

    @Override
    public BlockAccessor.Builder blockAccessor() {
        class_310 mc = class_310.method_1551();
        return new BlockAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public EntityAccessor.Builder entityAccessor() {
        class_310 mc = class_310.method_1551();
        return new EntityAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public void registerCustomEnchantPower(class_2248 block, CustomEnchantPower customEnchantPower) {
        this.customEnchantPowers.put(block, customEnchantPower);
    }

    @Override
    @Deprecated
    public class_437 createPluginConfigScreen(@Nullable class_437 parent, @Nullable String namespace) {
        return this.createPluginConfigScreen(parent, (class_2561)ModIdentification.getModName(namespace).map(class_2561::method_43470).orElse(null));
    }

    @Override
    public class_437 createPluginConfigScreen(@Nullable class_437 parent, @Nullable class_2561 jumpToCategory) {
        Function<OptionsList, OptionsList.Entry> jumpTo = null;
        if (jumpToCategory != null) {
            String title = jumpToCategory.getString();
            jumpTo = options -> {
                for (OptionsList.Entry entry : options.method_25396()) {
                    OptionsList.Title e;
                    if (!(entry instanceof OptionsList.Title) || !(e = (OptionsList.Title)entry).getTitle().getString().equals(title)) continue;
                    return entry;
                }
                return null;
            };
        }
        return PluginsConfigScreen.createPluginConfigScreen(parent, jumpTo, false);
    }

    @Override
    public void registerItemStorageClient(IClientExtensionProvider<class_1799, ItemView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.itemStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerFluidStorageClient(IClientExtensionProvider<class_2487, FluidView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.fluidStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerEnergyStorageClient(IClientExtensionProvider<class_2487, EnergyView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.energyStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerProgressClient(IClientExtensionProvider<class_2487, ProgressView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.progressProviders.put(provider.getUid(), provider);
    }

    @Override
    public boolean isServerConnected() {
        return ObjectDataCenter.serverConnected;
    }

    @Override
    public boolean isShowDetailsPressed() {
        return ClientProxy.isShowDetailsPressed();
    }

    @Override
    public class_2487 getServerData() {
        return ObjectDataCenter.getServerData();
    }

    @Override
    public void setServerData(class_2487 tag) {
        ObjectDataCenter.setServerData(tag);
    }

    @Override
    public class_1799 getBlockCamouflage(class_1936 level, class_2338 pos) {
        return DatapackBlockManager.getFakeBlock(level, pos);
    }

    @Override
    public void markAsClientFeature(class_2960 uid) {
        this.clientFeatures.add(uid);
    }

    @Override
    public void markAsServerFeature(class_2960 uid) {
        this.clientFeatures.remove(uid);
    }

    @Override
    public boolean isClientFeature(class_2960 uid) {
        return this.clientFeatures.contains(uid);
    }

    @Override
    public <T extends Accessor<?>> void registerAccessorHandler(Class<T> clazz, AccessorClientHandler<T> handler) {
        this.accessorHandlers.put(clazz, handler);
    }

    @Override
    public AccessorClientHandler<Accessor<?>> getAccessorHandler(Class<? extends Accessor<?>> clazz) {
        return Objects.requireNonNull(this.accessorHandlers.get(clazz), () -> "No accessor handler for " + clazz);
    }

    @Override
    public boolean maybeLowVisionUser() {
        return ClientProxy.maybeLowVisionUser || IWailaConfig.get().getGeneral().shouldEnableTextToSpeech();
    }
}

