/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_5151;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItemClient;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.UUIDDeduplicator;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.mixin.common.accessor.ItemEntityAccessor;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingBackpackItemEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryInteractionHelper;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.MenuProviderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class BackpackItem
extends ItemBase
implements IStashStorageItem,
class_5151 {
    private final IntSupplier numberOfSlots;
    private final IntSupplier numberOfUpgradeSlots;
    private final Supplier<BackpackBlock> blockSupplier;

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier) {
        this(numberOfSlots, numberOfUpgradeSlots, blockSupplier, p -> p);
    }

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier, UnaryOperator<class_1792.class_1793> updateProperties) {
        super((class_1792.class_1793)updateProperties.apply(new class_1792.class_1793().method_7889(1)));
        this.numberOfSlots = numberOfSlots;
        this.numberOfUpgradeSlots = numberOfUpgradeSlots;
        this.blockSupplier = blockSupplier;
    }

    public void addCreativeTabItems(Consumer<class_1799> itemConsumer) {
        super.addCreativeTabItems(itemConsumer);
        if (this != ModItems.BACKPACK || !net.p3pp3rf1y.sophisticatedcore.Config.COMMON.enabledItems.isItemEnabled((class_1792)this)) {
            return;
        }
        for (class_1767 color : class_1767.values()) {
            class_1799 stack = new class_1799((class_1935)this);
            new BackpackWrapper().setBackpackStack(stack).setColors(ColorHelper.getColor((float[])color.method_7787()), ColorHelper.getColor((float[])color.method_7787()));
            itemConsumer.accept(stack);
        }
        int clothColor = ColorHelper.calculateColor((int)13394234, (int)13394234, List.of(class_1767.field_7966, class_1767.field_7947, class_1767.field_7961));
        int trimColor = ColorHelper.calculateColor((int)6434330, (int)6434330, List.of(class_1767.field_7966, class_1767.field_7963));
        class_1799 stack = new class_1799((class_1935)this);
        new BackpackWrapper().setBackpackStack(stack).setColors(clothColor, trimColor);
        itemConsumer.accept(stack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        if (flagIn == class_1836.field_41071) {
            BackpackWrapper.fromData(stack).getContentsUuid().ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + String.valueOf(uuid))).method_27692(class_124.field_1063)));
        }
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43469((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return Optional.ofNullable(BackpackItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    private boolean hasEverlastingUpgrade(class_1799 stack) {
        return !BackpackWrapper.fromData(stack).getUpgradeHandler().getTypeWrappers(EverlastingUpgradeItem.TYPE).isEmpty();
    }

    @Nullable
    public class_1297 createEntity(class_1937 level, class_1297 entity, class_1799 itemstack) {
        if (!(entity instanceof class_1542)) {
            return null;
        }
        class_1542 itemEntity = (class_1542)entity;
        UUIDDeduplicator.dedupeBackpackItemEntityInArea(itemEntity);
        return this.hasEverlastingUpgrade(itemstack) ? this.createEverlastingBackpack(level, (class_1542)entity, itemstack) : null;
    }

    @Nullable
    private EverlastingBackpackItemEntity createEverlastingBackpack(class_1937 level, class_1542 itemEntity, class_1799 itemstack) {
        EverlastingBackpackItemEntity backpackItemEntity = (EverlastingBackpackItemEntity)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.method_5883(level);
        if (backpackItemEntity != null) {
            backpackItemEntity.method_5814(itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321());
            backpackItemEntity.method_6979(itemstack);
            backpackItemEntity.method_6982(((ItemEntityAccessor)itemEntity).getPickupDelay());
            if (itemEntity.method_24921() != null) {
                backpackItemEntity.method_6981(itemEntity.method_24921());
            }
            backpackItemEntity.method_18799(itemEntity.method_18798());
        }
        return backpackItemEntity;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1750 blockItemUseContext;
        class_1657 player = context.method_8036();
        if (player == null || !player.method_5715()) {
            return class_1269.field_5811;
        }
        if (InventoryInteractionHelper.tryInventoryInteraction(context)) {
            return class_1269.field_5812;
        }
        class_2350 direction = player.method_5735().method_10153();
        class_1269 result = this.tryPlace(player, direction, blockItemUseContext = new class_1750(context));
        return result == class_1269.field_5811 ? super.method_7884(context) : result;
    }

    public class_1269 tryPlace(@Nullable class_1657 player, class_2350 direction, class_1750 blockItemUseContext) {
        if (!blockItemUseContext.method_7716()) {
            return class_1269.field_5814;
        }
        class_1937 level = blockItemUseContext.method_8045();
        class_2338 pos = blockItemUseContext.method_8037();
        class_3610 fluidstate = blockItemUseContext.method_8045().method_8316(pos);
        class_2680 placementState = (class_2680)((class_2680)this.blockSupplier.get().method_9564().method_11657((class_2769)BackpackBlock.FACING, (Comparable)direction)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(fluidstate.method_15772() == class_3612.field_15910));
        if (!this.canPlace(blockItemUseContext, placementState)) {
            return class_1269.field_5814;
        }
        if (level.method_8501(pos, placementState)) {
            class_1799 backpack = blockItemUseContext.method_8041();
            WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, BackpackBlockEntity.class).ifPresent(be -> {
                be.setBackpack(this.getBackpackCopy(player, backpack));
                be.refreshRenderState();
                be.tryToAddToController();
            });
            if (!level.field_9236) {
                BackpackItem.stopBackpackSounds(backpack, level, pos);
            }
            class_2498 soundtype = placementState.method_26231();
            level.method_8396(player, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
            if (player == null || !player.method_7337()) {
                backpack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static void stopBackpackSounds(class_1799 backpack, class_1937 level, class_2338 pos) {
        BackpackWrapper.fromData(backpack).getContentsUuid().ifPresent(uuid -> ServerStorageSoundHandler.stopPlayingDisc((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)pos), (UUID)uuid));
    }

    private class_1799 getBackpackCopy(@Nullable class_1657 player, class_1799 backpack) {
        if (player == null || !player.method_7337()) {
            return backpack.method_7972();
        }
        return BackpackWrapper.fromData(backpack).cloneBackpack();
    }

    protected boolean canPlace(class_1750 context, class_2680 state) {
        class_1657 playerentity = context.method_8036();
        class_3726 iselectioncontext = playerentity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)playerentity);
        return state.method_26184((class_4538)context.method_8045(), context.method_8037()) && context.method_8045().method_8628(state, context.method_8037(), iselectioncontext);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!level.field_9236) {
            String handlerName = hand == class_1268.field_5808 ? "main" : "offhand";
            int slot = hand == class_1268.field_5808 ? player.method_31548().field_7545 : 0;
            BackpackContext.Item context = new BackpackContext.Item(handlerName, slot);
            player.method_17355((class_3908)MenuProviderHelper.createMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, context), context::toBuffer, (class_2561)stack.method_7964()));
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int itemSlot, boolean isSelected) {
        class_1657 player;
        if (level.field_9236 || !(entity instanceof class_1657) || (player = (class_1657)entity).method_7325() || player.method_29504() || ((Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get()).booleanValue() && itemSlot > -1) {
            return;
        }
        BackpackWrapper.fromData(stack).getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick((class_1309)player, player.method_37908(), player.method_24515()));
        super.method_7888(stack, level, entity, itemSlot, isSelected);
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots.getAsInt();
    }

    public int getNumberOfUpgradeSlots() {
        return this.numberOfUpgradeSlots.getAsInt();
    }

    public boolean onDroppedByPlayer(class_1799 item, class_1657 player) {
        BackpackContainer backpackContainer;
        class_1703 class_17032 = player.field_7512;
        return !(class_17032 instanceof BackpackContainer && (backpackContainer = (BackpackContainer)class_17032).getVisibleStorageItem().map(visibleStorageItem -> visibleStorageItem == item).orElse(false) != false);
    }

    @Nullable
    public class_1304 method_7685() {
        return class_1304.field_6174;
    }

    public Optional<class_5632> getInventoryTooltip(class_1799 stack) {
        return Optional.of(new BackpackContentsTooltip(stack));
    }

    public class_1799 stash(class_1799 storageStack, class_1799 stack) {
        try (Transaction inner = Transaction.openOuter();){
            class_1799 stashResult = stack.method_46651(stack.method_7947() - (int)BackpackWrapper.fromData(storageStack).getInventoryForUpgradeProcessing().insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)inner));
            inner.commit();
            class_1799 class_17992 = stashResult;
            return class_17992;
        }
    }

    public IStashStorageItem.StashResult getItemStashable(class_1799 storageStack, class_1799 stack) {
        IBackpackWrapper wrapper = BackpackWrapper.fromData(storageStack);
        if (StorageUtil.simulateInsert((Storage)wrapper.getInventoryForUpgradeProcessing(), (Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), null) == 0L) {
            return IStashStorageItem.StashResult.NO_SPACE;
        }
        if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.method_7909()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
            return IStashStorageItem.StashResult.MATCH_AND_SPACE;
        }
        return IStashStorageItem.StashResult.SPACE;
    }

    public boolean method_31565(class_1799 storageStack, class_1735 slot, class_5536 action, class_1657 player) {
        if (storageStack.method_7947() > 1 || !slot.method_7674(player) || action != class_5536.field_27014) {
            return super.method_31565(storageStack, slot, action, player);
        }
        class_1799 stackToStash = slot.method_7677();
        class_1799 stashResult = this.stash(storageStack, stackToStash);
        if (stashResult.method_7947() != stackToStash.method_7947()) {
            slot.method_7673(stashResult);
            slot.method_7667(player, stashResult);
            return true;
        }
        return super.method_31565(storageStack, slot, action, player);
    }

    public boolean method_31566(class_1799 storageStack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 carriedAccess) {
        if (storageStack.method_7947() > 1 || !slot.method_7680(storageStack) || action != class_5536.field_27014) {
            return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        class_1799 result = this.stash(storageStack, otherStack);
        if (result.method_7947() != otherStack.method_7947()) {
            carriedAccess.method_32332(result);
            slot.method_7673(storageStack);
            return true;
        }
        return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
    }

    public boolean method_31568() {
        return (Boolean)Config.SERVER.canBePlacedInContainerItems.get();
    }

    public record BackpackContentsTooltip(class_1799 backpack) implements class_5632
    {
        public class_1799 getBackpack() {
            return this.backpack;
        }
    }
}

