/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.trinkets.TrinketsCompat;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenPacket;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BlockToolSwapPacket;
import net.p3pp3rf1y.sophisticatedbackpacks.network.EntityToolSwapPacket;
import net.p3pp3rf1y.sophisticatedbackpacks.network.InventoryInteractionPacket;
import net.p3pp3rf1y.sophisticatedbackpacks.network.UpgradeTogglePacket;
import net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor.AbstractContainerScreenAccessor;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;

public class KeybindHandler {
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_Z = 90;
    private static final int KEY_X = 88;
    private static final int KEY_UNKNOWN = -1;
    private static final int MIDDLE_BUTTON = 2;
    private static final int CHEST_SLOT_INDEX = 38;
    private static final int OFFHAND_SLOT_INDEX = 40;
    private static final String KEYBIND_SOPHISTICATEDBACKPACKS_CATEGORY = "keybind.sophisticatedbackpacks.category";
    public static final class_304 BACKPACK_TOGGLE_UPGRADE_5 = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_5"), class_3675.class_307.field_1668.method_1447(-1).method_1444(), "keybind.sophisticatedbackpacks.category");
    public static final class_304 BACKPACK_TOGGLE_UPGRADE_4 = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_4"), class_3675.class_307.field_1668.method_1447(-1).method_1444(), "keybind.sophisticatedbackpacks.category");
    public static final class_304 BACKPACK_TOGGLE_UPGRADE_3 = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_3"), class_3675.class_307.field_1668.method_1447(-1).method_1444(), "keybind.sophisticatedbackpacks.category");
    public static final class_304 BACKPACK_TOGGLE_UPGRADE_2 = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_2"), class_3675.class_307.field_1668.method_1447(88).method_1444(), "keybind.sophisticatedbackpacks.category");
    public static final class_304 BACKPACK_TOGGLE_UPGRADE_1 = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_1"), class_3675.class_307.field_1668.method_1447(90).method_1444(), "keybind.sophisticatedbackpacks.category");
    public static final Map<Integer, class_304> UPGRADE_SLOT_TOGGLE_KEYBINDS = Map.of(0, BACKPACK_TOGGLE_UPGRADE_1, 1, BACKPACK_TOGGLE_UPGRADE_2, 2, BACKPACK_TOGGLE_UPGRADE_3, 3, BACKPACK_TOGGLE_UPGRADE_4, 4, BACKPACK_TOGGLE_UPGRADE_5);
    public static final class_304 SORT_KEYBIND = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("sort"), class_3675.class_307.field_1672, 2, "keybind.sophisticatedbackpacks.category");
    public static final class_304 TOOL_SWAP_KEYBIND = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("tool_swap"), class_3675.class_307.field_1668.method_1447(-1).method_1444(), "keybind.sophisticatedbackpacks.category");
    public static final class_304 INVENTORY_INTERACTION_KEYBIND = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("inventory_interaction"), class_3675.class_307.field_1668.method_1447(67).method_1444(), "keybind.sophisticatedbackpacks.category");
    public static final class_304 BACKPACK_OPEN_KEYBIND = new class_304(SBPTranslationHelper.INSTANCE.translKeybind("open_backpack"), class_3675.class_307.field_1668.method_1447(66).method_1444(), "keybind.sophisticatedbackpacks.category");

    private KeybindHandler() {
    }

    public static void register() {
        if (!FabricLoader.getInstance().isModLoaded("mkb")) {
            ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                ScreenKeyboardEvents.allowKeyPress((class_437)screen).register(KeybindHandler::handleGuiKeyPress);
                ScreenMouseEvents.allowMouseClick((class_437)screen).register(KeybindHandler::handleGuiMouseKeyPress);
            });
        }
        ClientTickEvents.END_CLIENT_TICK.register(KeybindHandler::handleKeyInputEvent);
    }

    public static void registerKeyMappings() {
        KeyBindingHelper.registerKeyBinding((class_304)BACKPACK_OPEN_KEYBIND);
        KeyBindingHelper.registerKeyBinding((class_304)INVENTORY_INTERACTION_KEYBIND);
        KeyBindingHelper.registerKeyBinding((class_304)TOOL_SWAP_KEYBIND);
        KeyBindingHelper.registerKeyBinding((class_304)SORT_KEYBIND);
        UPGRADE_SLOT_TOGGLE_KEYBINDS.forEach((slot, keybind) -> KeyBindingHelper.registerKeyBinding((class_304)keybind));
    }

    public static boolean handleGuiKeyPress(class_437 screen, int key, int scancode, int modifiers) {
        if (SORT_KEYBIND.method_1417(key, scancode) && KeybindHandler.tryCallSort(screen)) {
            return false;
        }
        return !BACKPACK_OPEN_KEYBIND.method_1417(key, scancode) || !KeybindHandler.sendBackpackOpenOrCloseMessage();
    }

    public static boolean handleGuiMouseKeyPress(class_437 screen, double mouseX, double mouseY, int button) {
        if (SORT_KEYBIND.method_1433(button) && KeybindHandler.tryCallSort(screen)) {
            return false;
        }
        return !BACKPACK_OPEN_KEYBIND.method_1433(button) || !KeybindHandler.sendBackpackOpenOrCloseMessage();
    }

    private static void handleKeyInputEvent(class_310 minecraft) {
        if (BACKPACK_OPEN_KEYBIND.method_1436()) {
            KeybindHandler.sendBackpackOpenOrCloseMessage();
        } else if (INVENTORY_INTERACTION_KEYBIND.method_1436()) {
            KeybindHandler.sendInteractWithInventoryMessage();
        } else if (TOOL_SWAP_KEYBIND.method_1436()) {
            KeybindHandler.sendToolSwapMessage();
        } else {
            for (Map.Entry<Integer, class_304> slotKeybind : UPGRADE_SLOT_TOGGLE_KEYBINDS.entrySet()) {
                if (!slotKeybind.getValue().method_1436()) continue;
                PacketHelper.sendToServer((FabricPacket)new UpgradeTogglePacket(slotKeybind.getKey()));
            }
        }
    }

    public static boolean tryCallSort(class_437 gui) {
        class_1703 class_17032;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && (class_17032 = mc.field_1724.field_7512) instanceof BackpackContainer) {
            double mouseY;
            class_312 mh;
            double mouseX;
            BackpackScreen screen;
            class_1735 selectedSlot;
            BackpackContainer container = (BackpackContainer)class_17032;
            if (gui instanceof BackpackScreen && (selectedSlot = (screen = (BackpackScreen)gui).method_2386(mouseX = (mh = mc.field_1729).method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480(), mouseY = mh.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507())) != null && container.isNotPlayersInventorySlot(selectedSlot.field_7874)) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static void sendToolSwapMessage() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || mc.field_1765 == null) {
            return;
        }
        if (player.method_6047().method_7909() instanceof BackpackItem) {
            player.method_7353((class_2561)class_2561.method_43471((String)"gui.sophisticatedbackpacks.status.unable_to_swap_tool_for_backpack"), true);
            return;
        }
        class_239 rayTrace = mc.field_1765;
        if (rayTrace.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockRayTraceResult = (class_3965)rayTrace;
            class_2338 pos = blockRayTraceResult.method_17777();
            PacketHelper.sendToServer((FabricPacket)new BlockToolSwapPacket(pos));
        } else if (rayTrace.method_17783() == class_239.class_240.field_1331) {
            class_3966 entityRayTraceResult = (class_3966)rayTrace;
            PacketHelper.sendToServer((FabricPacket)new EntityToolSwapPacket(entityRayTraceResult.method_17782().method_5628()));
        }
    }

    private static void sendInteractWithInventoryMessage() {
        class_310 mc = class_310.method_1551();
        class_239 rayTrace = mc.field_1765;
        if (rayTrace == null || rayTrace.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_3965 blockraytraceresult = (class_3965)rayTrace;
        class_2338 pos = blockraytraceresult.method_17777();
        if (Boolean.FALSE.equals(CapabilityHelper.getFromItemHandler((class_1937)mc.field_1687, (class_2338)pos, itemHandler -> true, (Object)false))) {
            return;
        }
        PacketHelper.sendToServer((FabricPacket)new InventoryInteractionPacket(pos, blockraytraceresult.method_17780()));
    }

    public static boolean sendBackpackOpenOrCloseMessage() {
        if (class_310.method_1551().field_1755 == null) {
            PacketHelper.sendToServer((FabricPacket)new BackpackOpenPacket());
            return false;
        }
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof class_465) {
            Optional<PlayerInventoryReturn> handler;
            class_465 containerScreen = (class_465)screen;
            class_1735 slot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
            if (slot != null && (slot.field_7871 instanceof class_1661 || KeybindHandler.isTrinket(slot.field_7871)) && (handler = KeybindHandler.getPlayerInventory(slot)).isPresent() && slot.method_7677().method_7909() instanceof BackpackItem) {
                PacketHelper.sendToServer((FabricPacket)new BackpackOpenPacket(slot.method_34266(), handler.get().identifier(), handler.get().handlerName()));
                return true;
            }
            if (screen instanceof BackpackScreen && slot != null && slot.method_7677().method_7909() instanceof BackpackItem && slot.method_7677().method_7947() == 1) {
                PacketHelper.sendToServer((FabricPacket)new BackpackOpenPacket(slot.method_34266()));
                return true;
            }
        }
        return false;
    }

    private static boolean isTrinket(class_1263 container) {
        return FabricLoader.getInstance().isModLoaded("trinkets") && TrinketsCompat.isTrinketContainer(container);
    }

    private static Optional<PlayerInventoryReturn> getPlayerInventory(class_1735 slot) {
        int slotIndex = slot.method_34266();
        if (slotIndex == 38) {
            return Optional.of(new PlayerInventoryReturn("", "armor"));
        }
        if (slotIndex == 40) {
            return Optional.of(new PlayerInventoryReturn("", "offhand"));
        }
        if (KeybindHandler.isTrinket(slot.field_7871)) {
            return Optional.of(new PlayerInventoryReturn(TrinketsCompat.getIdentifierForSlot(slot.field_7871), "trinkets"));
        }
        if (slotIndex >= 0 && slotIndex < 36) {
            return Optional.of(new PlayerInventoryReturn("", "main"));
        }
        return Optional.empty();
    }

    record PlayerInventoryReturn(String identifier, String handlerName) {
    }
}

