/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.google.common.collect.ImmutableMap;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;

public class BackpackModel
extends class_4592<class_1309>
implements IBackpackModel {
    private static final Map<class_1299<?>, class_243> entityTranslations = new HashMap();
    private static final class_2960 BACKPACK_ENTITY_TEXTURE;
    private static final class_2960 TANK_GLASS_TEXTURE;
    public static final float CHILD_Y_OFFSET = 0.3f;
    public static final float CHILD_Z_OFFSET = 0.1f;
    public static final float CHILD_SCALE = 0.55f;
    private static final String CLOTH_PART = "cloth";
    private static final String RIGHT_POUCHES_BORDER_PART = "rightPouchesBorder";
    private static final String LEFT_POUCHES_BORDER_PART = "leftPouchesBorder";
    private static final String FRONT_POUCH_BORDER_PART = "frontPouchBorder";
    private static final String FRONT_POUCH_PART = "frontPouch";
    private static final String RIGHT_POUCHES_PART = "rightPouches";
    private static final String LEFT_POUCHES_PART = "leftPouches";
    private static final String BORDER_PART = "border";
    private static final String FABRIC_FRONT_PART = "fabricFront";
    private static final String FABRIC_RIGHT_PART = "fabricRight";
    private static final String FABRIC_LEFT_PART = "fabricLeft";
    private static final String FABRIC_PART = "fabric";
    private static final String BATTERY_BORDER_PART = "batteryBorder";
    private static final String BATTERY_PART = "battery";
    private static final String LEFT_TANK_BORDER_PART = "leftTankBorder";
    private static final String LEFT_TANK_PART = "leftTank";
    private static final String RIGHT_TANK_BORDER_PART = "rightTankBorder";
    private static final String RIGHT_TANK_PART = "rightTank";
    private static final String BODY_CLIPS_PART = "bodyClips_";
    private static final String LEFT_POUCHES_CLIPS_PART = "leftPouchesClips_";
    private static final String RIGHT_POUCHES_CLIPS_PART = "rightPouchesClips_";
    private static final String FRONT_POUCH_CLIPS_PART = "frontPouchClips_";
    private static final String BATTERY_CLIPS_PART = "batteryClips_";
    private static final String LEFT_TANK_GLASS_PART = "leftTankGlass";
    private static final String RIGHT_TANK_GLASS_PART = "rightTankGlass";
    private static final String BATTERY_CHARGE_PART = "battery_charge_";
    private final Map<class_1792, class_630> clipsBody;
    private final Map<class_1792, class_630> clipsLeftPouches;
    private final Map<class_1792, class_630> clipsRightPouches;
    private final Map<class_1792, class_630> clipsFrontPouch;
    private final Map<class_1792, class_630> clipsBattery;
    private final Map<FluidBarCacheKey, class_630> fluidLevelsLeft = new HashMap<FluidBarCacheKey, class_630>();
    private final Map<FluidBarCacheKey, class_630> fluidLevelsRight = new HashMap<FluidBarCacheKey, class_630>();
    private final Map<Integer, class_630> batteryCharges;
    public final class_630 cloth;
    private final class_630 rightPouchesBorder;
    private final class_630 leftPouchesBorder;
    private final class_630 frontPouchBorder;
    private final class_630 frontPouch;
    private final class_630 rightPouches;
    private final class_630 leftPouches;
    public final class_630 border;
    private final class_630 fabricFront;
    private final class_630 fabricRight;
    private final class_630 fabricLeft;
    public final class_630 fabric;
    private final class_630 battery;
    private final class_630 batteryBorder;
    private final class_630 leftTank;
    private final class_630 leftTankBorder;
    private final class_630 rightTank;
    private final class_630 rightTankBorder;
    public final class_630 leftTankGlass;
    public final class_630 rightTankGlass;

    public BackpackModel(class_630 part) {
        this.cloth = part.method_32086(CLOTH_PART);
        this.rightPouchesBorder = part.method_32086(RIGHT_POUCHES_BORDER_PART);
        this.leftPouchesBorder = part.method_32086(LEFT_POUCHES_BORDER_PART);
        this.frontPouchBorder = part.method_32086(FRONT_POUCH_BORDER_PART);
        this.frontPouch = part.method_32086(FRONT_POUCH_PART);
        this.rightPouches = part.method_32086(RIGHT_POUCHES_PART);
        this.leftPouches = part.method_32086(LEFT_POUCHES_PART);
        this.border = part.method_32086(BORDER_PART);
        this.fabricFront = part.method_32086(FABRIC_FRONT_PART);
        this.fabricRight = part.method_32086(FABRIC_RIGHT_PART);
        this.fabricLeft = part.method_32086(FABRIC_LEFT_PART);
        this.fabric = part.method_32086(FABRIC_PART);
        this.battery = part.method_32086(BATTERY_PART);
        this.batteryBorder = part.method_32086(BATTERY_BORDER_PART);
        this.leftTank = part.method_32086(LEFT_TANK_PART);
        this.leftTankBorder = part.method_32086(LEFT_TANK_BORDER_PART);
        this.rightTank = part.method_32086(RIGHT_TANK_PART);
        this.rightTankBorder = part.method_32086(RIGHT_TANK_BORDER_PART);
        ImmutableMap.Builder clipsBodyBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsLeftPouchesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsRightPouchesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsFrontPouchBuilder = ImmutableMap.builder();
        ImmutableMap.Builder clipsBatteryBuilder = ImmutableMap.builder();
        BackpackModel.getBackpackItems().values().forEach(backpackItem -> {
            clipsBodyBuilder.put(backpackItem, (Object)part.method_32086(BackpackModel.getTierPartName(backpackItem, BODY_CLIPS_PART)));
            clipsLeftPouchesBuilder.put(backpackItem, (Object)part.method_32086(BackpackModel.getTierPartName(backpackItem, LEFT_POUCHES_CLIPS_PART)));
            clipsRightPouchesBuilder.put(backpackItem, (Object)part.method_32086(BackpackModel.getTierPartName(backpackItem, RIGHT_POUCHES_CLIPS_PART)));
            clipsFrontPouchBuilder.put(backpackItem, (Object)part.method_32086(BackpackModel.getTierPartName(backpackItem, FRONT_POUCH_CLIPS_PART)));
            clipsBatteryBuilder.put(backpackItem, (Object)part.method_32086(BackpackModel.getTierPartName(backpackItem, BATTERY_CLIPS_PART)));
        });
        ImmutableMap.Builder batteryChargeBuilder = ImmutableMap.builder();
        for (int pixels = 1; pixels < 5; ++pixels) {
            batteryChargeBuilder.put((Object)pixels, (Object)part.method_32086(BATTERY_CHARGE_PART + pixels));
        }
        this.batteryCharges = batteryChargeBuilder.build();
        this.clipsBody = clipsBodyBuilder.build();
        this.clipsLeftPouches = clipsLeftPouchesBuilder.build();
        this.clipsRightPouches = clipsRightPouchesBuilder.build();
        this.clipsFrontPouch = clipsFrontPouchBuilder.build();
        this.clipsBattery = clipsBatteryBuilder.build();
        class_630 modelPart = this.getGlassModelPart();
        this.leftTankGlass = modelPart.method_32086(LEFT_TANK_GLASS_PART);
        this.rightTankGlass = modelPart.method_32086(RIGHT_TANK_GLASS_PART);
    }

    @Nonnull
    private class_630 getGlassModelPart() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partDefinition = meshdefinition.method_32111();
        partDefinition.method_32117(LEFT_TANK_GLASS_PART, class_5606.method_32108().method_32101(18, 5).method_32097(-15.0f, 3.5f, -2.5f, 4.0f, 10.0f, 0.0f).method_32101(0, 0).method_32097(-15.0f, 3.5f, -2.5f, 0.0f, 10.0f, 5.0f).method_32101(10, 5).method_32097(-15.0f, 3.5f, 2.5f, 4.0f, 10.0f, 0.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(RIGHT_TANK_GLASS_PART, class_5606.method_32108().method_32101(18, 5).method_32100(11.0f, 3.5f, -2.5f, 4.0f, 10.0f, 0.0f, true).method_32101(0, 0).method_32100(15.0f, 3.5f, -2.5f, 0.0f, 10.0f, 5.0f, true).method_32101(10, 5).method_32100(11.0f, 3.5f, 2.5f, 4.0f, 10.0f, 0.0f, true), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        return partDefinition.method_32112(32, 32);
    }

    public static class_5607 createBodyLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partDefinition = meshdefinition.method_32111();
        partDefinition.method_32117(CLOTH_PART, class_5606.method_32108().method_32101(0, 0).method_32097(-3.5f, -13.25f, -3.25f, 7.0f, 4.0f, 6.0f).method_32101(0, 10).method_32097(-5.0f, -13.0f, -3.0f, 10.0f, 13.0f, 6.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(RIGHT_POUCHES_BORDER_PART, class_5606.method_32108().method_32101(44, 0).method_32100(5.0f, -2.0f, -2.5f, 2.0f, 1.0f, 5.0f, true), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(LEFT_POUCHES_BORDER_PART, class_5606.method_32108().method_32101(44, 0).method_32097(-7.0f, -2.0f, -2.5f, 2.0f, 1.0f, 5.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(FRONT_POUCH_BORDER_PART, class_5606.method_32108().method_32101(44, 0).method_32097(-4.0f, -2.0f, -5.0f, 8.0f, 1.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(FRONT_POUCH_PART, class_5606.method_32108().method_32101(25, 0).method_32097(-4.0f, -1.0f, -5.0f, 8.0f, 1.0f, 2.0f).method_32101(13, 2).method_32097(-4.0f, -4.0f, -5.0f, 8.0f, 2.0f, 2.0f).method_32101(13, 0).method_32097(-4.0f, -6.0f, -5.0f, 8.0f, 1.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(RIGHT_POUCHES_PART, class_5606.method_32108().method_32101(32, 5).method_32097(5.0f, -1.0f, -2.5f, 2.0f, 1.0f, 5.0f).method_32101(32, 13).method_32097(5.0f, -4.0f, -2.5f, 2.0f, 2.0f, 5.0f).method_32101(32, 11).method_32097(5.0f, -6.0f, -2.5f, 2.0f, 1.0f, 5.0f).method_32101(32, 22).method_32097(5.0f, -9.0f, -2.5f, 1.0f, 2.0f, 5.0f).method_32101(32, 20).method_32097(5.0f, -11.0f, -2.5f, 1.0f, 1.0f, 5.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(LEFT_POUCHES_PART, class_5606.method_32108().method_32101(32, 5).method_32100(-7.0f, -1.0f, -2.5f, 2.0f, 1.0f, 5.0f, true).method_32101(32, 13).method_32100(-7.0f, -4.0f, -2.5f, 2.0f, 2.0f, 5.0f, true).method_32101(32, 11).method_32100(-7.0f, -6.0f, -2.5f, 2.0f, 1.0f, 5.0f, true).method_32101(32, 22).method_32100(-6.0f, -9.0f, -2.5f, 1.0f, 2.0f, 5.0f, true).method_32101(32, 20).method_32100(-6.0f, -11.0f, -2.5f, 1.0f, 1.0f, 5.0f, true), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(BORDER_PART, class_5606.method_32108().method_32101(44, 7).method_32097(-3.5f, -9.25f, -3.25f, 7.0f, 1.0f, 1.0f).method_32101(50, 20).method_32097(3.5f, -13.25f, -3.25f, 1.0f, 5.0f, 6.0f).method_32101(50, 9).method_32097(-4.5f, -13.25f, -3.25f, 1.0f, 5.0f, 6.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(FABRIC_FRONT_PART, class_5606.method_32108().method_32101(12, 58).method_32100(-0.75f, 3.0f, 1.0f, 8.0f, 1.0f, 2.0f, true), class_5603.method_32090((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.method_32117(FABRIC_RIGHT_PART, class_5606.method_32108().method_32101(32, 49).method_32100(8.25f, -2.0f, 3.5f, 1.0f, 1.0f, 5.0f, true).method_32101(8, 48).method_32100(8.25f, 3.0f, 3.5f, 2.0f, 1.0f, 5.0f, true), class_5603.method_32090((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.method_32117(FABRIC_LEFT_PART, class_5606.method_32108().method_32101(32, 49).method_32097(-2.75f, -2.0f, 3.5f, 1.0f, 1.0f, 5.0f).method_32101(8, 48).method_32097(-3.75f, 3.0f, 3.5f, 2.0f, 1.0f, 5.0f), class_5603.method_32090((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.method_32117(FABRIC_PART, class_5606.method_32108().method_32101(54, 0).method_32097(1.25f, -4.75f, 5.75f, 1.0f, 1.0f, 1.0f).method_32101(58, 0).method_32097(4.25f, -4.75f, 5.75f, 1.0f, 1.0f, 1.0f).method_32101(44, 0).method_32100(1.25f, -5.75f, 5.75f, 4.0f, 1.0f, 1.0f, true).method_32101(16, 47).method_32097(0.0f, -5.5f, 2.5f, 1.0f, 4.0f, 7.0f).method_32101(0, 47).method_32097(5.5f, -5.5f, 2.5f, 1.0f, 4.0f, 7.0f), class_5603.method_32090((float)-3.25f, (float)16.0f, (float)-6.0f));
        partDefinition.method_32117(BATTERY_BORDER_PART, class_5606.method_32108().method_32101(28, 38).method_32097(-4.25f, -5.25f, -6.25f, 1.0f, 1.0f, 4.0f).method_32101(28, 43).method_32097(-3.5f, -5.25f, -6.25f, 7.0f, 1.0f, 1.0f).method_32101(33, 38).method_32097(-4.25f, -1.25f, -6.25f, 1.0f, 1.0f, 4.0f).method_32101(33, 38).method_32097(3.25f, -5.25f, -6.25f, 1.0f, 1.0f, 4.0f).method_32101(27, 45).method_32097(-3.5f, -1.25f, -6.25f, 7.0f, 1.0f, 1.0f).method_32101(39, 37).method_32097(3.25f, -1.25f, -6.25f, 1.0f, 1.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(BATTERY_PART, class_5606.method_32108().method_32101(28, 29).method_32097(-4.0f, -6.0f, -6.0f, 8.0f, 6.0f, 3.0f).method_32101(28, 53).method_32097(-2.0f, -6.25f, -4.5f, 1.0f, 1.0f, 1.0f).method_32101(28, 53).method_32097(-0.75f, -6.25f, -4.5f, 1.0f, 1.0f, 1.0f).method_32101(28, 53).method_32097(-2.0f, -8.0f, -3.25f, 1.0f, 1.0f, 1.0f).method_32101(28, 53).method_32097(-0.75f, -8.0f, -3.25f, 1.0f, 1.0f, 1.0f).method_32101(0, 58).method_32098(-2.0f, -7.4f, -4.5f, 1.0f, 2.0f, 1.0f, new class_5605(-0.2f)).method_32101(6, 58).method_32098(-0.75f, -7.4f, -4.5f, 1.0f, 2.0f, 1.0f, new class_5605(-0.2f)).method_32101(0, 61).method_32098(-2.0f, -8.0f, -4.5f, 1.0f, 1.0f, 2.0f, new class_5605(-0.2f)).method_32101(6, 61).method_32098(-0.75f, -8.0f, -4.5f, 1.0f, 1.0f, 2.0f, new class_5605(-0.2f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(LEFT_TANK_BORDER_PART, class_5606.method_32108().method_32101(50, 43).method_32097(-8.0f, -9.5f, -2.0f, 3.0f, 1.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(LEFT_TANK_PART, class_5606.method_32108().method_32101(54, 27).method_32097(-5.5f, -7.5f, -2.0f, 1.0f, 6.0f, 4.0f).method_32101(50, 37).method_32097(-8.0f, -1.5f, -2.0f, 3.0f, 1.0f, 4.0f).method_32101(50, 42).method_32097(-8.0f, -8.5f, -2.0f, 3.0f, 1.0f, 4.0f).method_32101(50, 37).method_32097(-8.0f, -10.5f, -2.0f, 3.0f, 1.0f, 4.0f).method_32101(52, 48).method_32097(-7.5f, -11.5f, -1.5f, 3.0f, 1.0f, 3.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(RIGHT_TANK_BORDER_PART, class_5606.method_32108().method_32101(50, 43).method_32100(5.0f, -9.5f, -2.0f, 3.0f, 1.0f, 4.0f, true), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        partDefinition.method_32117(RIGHT_TANK_PART, class_5606.method_32108().method_32101(54, 27).method_32100(4.5f, -7.5f, -2.0f, 1.0f, 6.0f, 4.0f, true).method_32101(50, 37).method_32100(5.0f, -1.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).method_32101(50, 42).method_32100(5.0f, -8.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).method_32101(50, 37).method_32100(5.0f, -10.5f, -2.0f, 3.0f, 1.0f, 4.0f, true).method_32101(52, 48).method_32100(4.5f, -11.5f, -1.5f, 3.0f, 1.0f, 3.0f, true), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        for (int pixels = 1; pixels < 5; ++pixels) {
            partDefinition.method_32117(BATTERY_CHARGE_PART + pixels, class_5606.method_32108().method_32101(30, 58).method_32097(-2.0f, 21.0f, -6.01f, (float)pixels, 1.0f, 1.0f), class_5603.field_27701);
        }
        BackpackModel.getBackpackItems().forEach((idx, item) -> {
            BackpackModel.addBodyClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addLeftPouchesClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addRightPouchesClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addFrontPouchClips(partDefinition, item, 29 + idx * 3);
            BackpackModel.addBatteryClips(partDefinition, item, 30 + idx * 3);
        });
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)64);
    }

    private static Map<Integer, class_1792> getBackpackItems() {
        return new LinkedHashMap<Integer, BackpackItem>(Map.of(0, ModItems.BACKPACK, 1, ModItems.COPPER_BACKPACK, 2, ModItems.IRON_BACKPACK, 3, ModItems.GOLD_BACKPACK, 4, ModItems.DIAMOND_BACKPACK, 5, ModItems.NETHERITE_BACKPACK));
    }

    @Override
    public <L extends class_1309, M extends class_583<L>> void render(M parentModel, class_1309 livingEntity, class_4587 poseStack, class_4597 buffer, int packedLight, int clothColor, int borderColor, class_1792 backpackItem, RenderInfo renderInfo) {
        IRenderedTankUpgrade.TankRenderInfo tankRenderInfo;
        class_4588 vertexBuilder = buffer.getBuffer(class_1921.method_23578((class_2960)BACKPACK_ENTITY_TEXTURE));
        Set tankPositions = renderInfo.getTankRenderInfos().keySet();
        boolean showLeftTank = tankPositions.contains(TankPosition.LEFT);
        boolean showRightTank = tankPositions.contains(TankPosition.RIGHT);
        Optional batteryRenderInfo = renderInfo.getBatteryRenderInfo();
        float borderRed = (float)(borderColor >> 16 & 0xFF) / 255.0f;
        float borderGreen = (float)(borderColor >> 8 & 0xFF) / 255.0f;
        float borderBlue = (float)(borderColor & 0xFF) / 255.0f;
        float clothRed = (float)(clothColor >> 16 & 0xFF) / 255.0f;
        float clothGreen = (float)(clothColor >> 8 & 0xFF) / 255.0f;
        float clothBlue = (float)(clothColor & 0xFF) / 255.0f;
        if (showLeftTank) {
            this.leftTank.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.leftTankBorder.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, borderRed, borderGreen, borderBlue, 1.0f);
        } else {
            this.fabricLeft.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.clipsLeftPouches.get(backpackItem).method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.leftPouches.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, clothRed, clothGreen, clothBlue, 1.0f);
            this.leftPouchesBorder.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, borderRed, borderGreen, borderBlue, 1.0f);
        }
        if (showRightTank) {
            this.rightTank.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.rightTankBorder.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, borderRed, borderGreen, borderBlue, 1.0f);
        } else {
            this.fabricRight.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.clipsRightPouches.get(backpackItem).method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.rightPouches.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, clothRed, clothGreen, clothBlue, 1.0f);
            this.rightPouchesBorder.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, borderRed, borderGreen, borderBlue, 1.0f);
        }
        if (batteryRenderInfo.isPresent()) {
            this.battery.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.batteryBorder.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, borderRed, borderGreen, borderBlue, 1.0f);
            this.clipsBattery.get(backpackItem).method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            batteryRenderInfo.ifPresent(info -> this.renderBatteryCharge(poseStack, buffer, packedLight, info.getChargeRatio()));
        } else {
            this.fabricFront.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.clipsFrontPouch.get(backpackItem).method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            this.frontPouch.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, clothRed, clothGreen, clothBlue, 1.0f);
            this.frontPouchBorder.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, borderRed, borderGreen, borderBlue, 1.0f);
        }
        this.fabric.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
        this.clipsBody.get(backpackItem).method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
        this.cloth.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, clothRed, clothGreen, clothBlue, 1.0f);
        this.border.method_22699(poseStack, vertexBuilder, packedLight, class_4608.field_21444, borderRed, borderGreen, borderBlue, 1.0f);
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.6f, 0.5f);
        if (showLeftTank) {
            vertexBuilder = buffer.getBuffer(class_1921.method_23578((class_2960)TANK_GLASS_TEXTURE));
            this.leftTankGlass.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.LEFT);
            tankRenderInfo.getFluid().ifPresent(f -> this.renderFluid(poseStack, buffer, packedLight, (FluidStack)f, tankRenderInfo.getFillRatio(), true));
        }
        if (showRightTank) {
            vertexBuilder = buffer.getBuffer(class_1921.method_23578((class_2960)TANK_GLASS_TEXTURE));
            this.rightTankGlass.method_22698(poseStack, vertexBuilder, packedLight, class_4608.field_21444);
            tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.RIGHT);
            tankRenderInfo.getFluid().ifPresent(f -> this.renderFluid(poseStack, buffer, packedLight, (FluidStack)f, tankRenderInfo.getFillRatio(), false));
        }
        poseStack.method_22909();
    }

    @Override
    public void renderBatteryCharge(class_4587 matrixStack, class_4597 buffer, int packedLight, float chargeRatio) {
        class_630 charge = this.batteryCharges.get((int)(chargeRatio * 4.0f));
        if (charge == null) {
            return;
        }
        class_4588 vertexBuilder = buffer.getBuffer(class_1921.method_23580((class_2960)BACKPACK_ENTITY_TEXTURE));
        charge.method_22698(matrixStack, vertexBuilder, packedLight, class_4608.field_21444);
    }

    @Override
    public void renderFluid(class_4587 matrixStack, class_4597 buffer, int packedLight, FluidStack fluidStack, float fill, boolean left) {
        if (class_3532.method_15347((float)fill, (float)0.0f)) {
            return;
        }
        FluidVariant fluidVariant = FluidVariant.of((class_3611)fluidStack.getFluid());
        class_1058 still = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        if (still == null) {
            return;
        }
        class_4588 vertexBuilder = buffer.getBuffer(class_1921.method_23580((class_2960)class_1723.field_21668));
        class_630 fluidBox = this.getFluidBar(still, (int)(fill * 10.0f), left);
        int color = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        fluidBox.method_22699(matrixStack, vertexBuilder, packedLight, class_4608.field_21444, red, green, blue, 1.0f);
    }

    private class_630 getFluidBar(class_1058 still, int fill, boolean left) {
        int atlasWidth = (int)((float)still.method_45851().method_45807() / (still.method_4577() - still.method_4594()));
        int atlasHeight = (int)((float)still.method_45851().method_45815() / (still.method_4575() - still.method_4593()));
        int u = (int)(still.method_4594() * (float)atlasWidth);
        int v = (int)(still.method_4593() * (float)atlasHeight);
        FluidBarCacheKey key = new FluidBarCacheKey(u, v, fill);
        Map<FluidBarCacheKey, class_630> fluidLevels = left ? this.fluidLevelsLeft : this.fluidLevelsRight;
        return fluidLevels.computeIfAbsent(key, k -> {
            class_5609 meshdefinition = new class_5609();
            class_5610 partDefinition = meshdefinition.method_32111();
            partDefinition.method_32117("fluid_fill", class_5606.method_32108().method_32101(u, v).method_32100(left ? -14.5f : 11.0f, 13.5f - (float)fill, -2.0f, 3.5f, (float)fill, 4.0f, !left), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
            class_630 root = partDefinition.method_32112(atlasWidth, atlasHeight);
            return root.method_32086("fluid_fill");
        });
    }

    @Override
    public class_1304 getRenderEquipmentSlot() {
        return class_1304.field_6174;
    }

    @Override
    public <L extends class_1309, M extends class_583<L>> void translateRotateAndScale(M parentModel, class_1309 livingEntity, class_4587 matrixStack, boolean wearsArmor) {
        if (livingEntity.method_18276()) {
            matrixStack.method_22904(0.0, 0.2, 0.0);
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(28.647888f));
        }
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        float zOffset = wearsArmor ? -0.35f : -0.3f;
        float yOffset = -0.75f;
        if (livingEntity.method_6109()) {
            zOffset += 0.1f;
            yOffset = 0.3f;
        }
        matrixStack.method_46416(0.0f, yOffset, zOffset);
        if (livingEntity instanceof class_1657) {
            return;
        }
        if (livingEntity.method_6109()) {
            matrixStack.method_22905(0.55f, 0.55f, 0.55f);
        }
        if (entityTranslations.containsKey(livingEntity.method_5864())) {
            class_243 translVector = entityTranslations.get(livingEntity.method_5864());
            matrixStack.method_22904(translVector.method_10216(), translVector.method_10214(), translVector.method_10215());
        }
    }

    private static void addBodyClips(class_5610 partDefinition, class_1792 backpackItem, int yTextureOffset) {
        BackpackModel.addBodyClips(partDefinition, backpackItem, 0, yTextureOffset);
    }

    private static void addBodyClips(class_5610 partDefinition, class_1792 backpackItem, int xTextureOffset, int yTextureOffset) {
        partDefinition.method_32117(BackpackModel.getTierPartName(backpackItem, BODY_CLIPS_PART), class_5606.method_32108().method_32101(22 + xTextureOffset, yTextureOffset).method_32097(-3.25f, -9.5f, -3.5f, 1.0f, 2.0f, 1.0f).method_32101(25 + xTextureOffset, yTextureOffset).method_32097(2.25f, -9.5f, -3.5f, 1.0f, 2.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static String getTierPartName(class_1792 backpackItem, String partNamePrefix) {
        return partNamePrefix + class_7923.field_41178.method_10221((Object)backpackItem).method_12832();
    }

    private static void addLeftPouchesClips(class_5610 partDefinition, class_1792 backpackItem, int yTextureOffset) {
        partDefinition.method_32117(BackpackModel.getTierPartName(backpackItem, LEFT_POUCHES_CLIPS_PART), class_5606.method_32108().method_32101(18, yTextureOffset).method_32097(-6.25f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f).method_32101(6, yTextureOffset).method_32097(-7.25f, -5.0f, -0.5f, 1.0f, 2.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addRightPouchesClips(class_5610 partDefinition, class_1792 backpackItem, int yTextureOffset) {
        partDefinition.method_32117(BackpackModel.getTierPartName(backpackItem, RIGHT_POUCHES_CLIPS_PART), class_5606.method_32108().method_32101(6, yTextureOffset).method_32100(6.25f, -5.0f, -0.5f, 1.0f, 2.0f, 1.0f, true).method_32101(18, yTextureOffset).method_32100(5.25f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addFrontPouchClips(class_5610 partDefinition, class_1792 backpackItem, int yTextureOffset) {
        partDefinition.method_32117(BackpackModel.getTierPartName(backpackItem, FRONT_POUCH_CLIPS_PART), class_5606.method_32108().method_32101(0, yTextureOffset).method_32097(2.0f, -5.0f, -5.25f, 1.0f, 2.0f, 1.0f).method_32101(3, yTextureOffset).method_32097(-3.0f, -5.0f, -5.25f, 1.0f, 2.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
    }

    private static void addBatteryClips(class_5610 partDefinition, class_1792 backpackItem, int yTextureOffset) {
        partDefinition.method_32117(BackpackModel.getTierPartName(backpackItem, BATTERY_CLIPS_PART), class_5606.method_32108().method_32101(24, yTextureOffset).method_32098(1.0f, -5.25f, -6.15f, 1.0f, 1.0f, 1.0f, new class_5605(0.2f)).method_32101(21, yTextureOffset).method_32098(1.0f, -1.25f, -6.15f, 1.0f, 1.0f, 1.0f, new class_5605(0.2f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
    }

    public void method_2828(class_4587 matrixStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    protected Iterable<class_630> method_22946() {
        return Collections.emptyList();
    }

    protected Iterable<class_630> method_22948() {
        return Collections.emptyList();
    }

    public void setupAnim(class_1309 entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    static {
        entityTranslations.put(class_1299.field_6091, new class_243(0.0, -0.8, 0.0));
        BACKPACK_ENTITY_TEXTURE = new class_2960("sophisticatedbackpacks", "textures/entity/backpack.png");
        TANK_GLASS_TEXTURE = new class_2960("sophisticatedbackpacks", "textures/entity/tank_glass.png");
    }

    private record FluidBarCacheKey(int u, int v, int fill) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidBarCacheKey that = (FluidBarCacheKey)o;
            return this.u == that.u && this.v == that.v && this.fill == that.fill;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.u, this.v, this.fill);
        }
    }
}

