/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.util.MenuProviderHelper;

public class BackpackOpenPacket
implements FabricPacket {
    public static final PacketType<BackpackOpenPacket> TYPE = PacketType.create((class_2960)new class_2960("sophisticatedbackpacks", "backpack_open"), BackpackOpenPacket::new);
    private static final int CHEST_SLOT = 38;
    private static final int OFFHAND_SLOT = 40;
    private final int slotIndex;
    private final String identifier;
    private final String handlerName;

    public BackpackOpenPacket() {
        this(-1);
    }

    public BackpackOpenPacket(int backpackSlot) {
        this(backpackSlot, "");
    }

    public BackpackOpenPacket(int backpackSlot, String identifier, String handlerName) {
        this.slotIndex = backpackSlot;
        this.identifier = identifier;
        this.handlerName = handlerName;
    }

    public BackpackOpenPacket(int backpackSlot, String identifier) {
        this(backpackSlot, identifier, "");
    }

    public BackpackOpenPacket(class_2540 buffer) {
        this(buffer.readInt(), buffer.method_19772(), buffer.method_19772());
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        if (!this.handlerName.isEmpty()) {
            BackpackContainer backpackContainer;
            class_1703 class_17032;
            int adjustedSlotIndex = this.slotIndex;
            if (adjustedSlotIndex == 38) {
                adjustedSlotIndex -= 36;
            } else if (adjustedSlotIndex == 40) {
                adjustedSlotIndex = 0;
            }
            BackpackContext.Item backpackContext = new BackpackContext.Item(this.handlerName, this.identifier, adjustedSlotIndex, player.field_7512 instanceof class_1723 || (class_17032 = player.field_7512) instanceof BackpackContainer && (backpackContainer = (BackpackContainer)class_17032).getBackpackContext().wasOpenFromInventory());
            this.openBackpack((class_1657)player, backpackContext);
        } else {
            class_1703 adjustedSlotIndex = player.field_7512;
            if (adjustedSlotIndex instanceof BackpackContainer) {
                BackpackContainer backpackContainer = (BackpackContainer)adjustedSlotIndex;
                backpackContext = backpackContainer.getBackpackContext();
                if (this.slotIndex == -1) {
                    this.openBackpack((class_1657)player, ((BackpackContext)backpackContext).getParentBackpackContext());
                } else if (backpackContainer.isStorageInventorySlot(this.slotIndex)) {
                    this.openBackpack((class_1657)player, ((BackpackContext)backpackContext).getSubBackpackContext(this.slotIndex));
                }
            } else {
                backpackContext = player.field_7512;
                if (backpackContext instanceof IContextAwareContainer) {
                    IContextAwareContainer contextAwareContainer = (IContextAwareContainer)backpackContext;
                    backpackContext = contextAwareContainer.getBackpackContext();
                    this.openBackpack((class_1657)player, (BackpackContext)backpackContext);
                } else {
                    this.findAndOpenFirstBackpack((class_1657)player);
                }
            }
        }
    }

    private void findAndOpenFirstBackpack(class_1657 player) {
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, identifier, slot);
            player.method_17355((class_3908)MenuProviderHelper.createMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext::toBuffer, (class_2561)backpack.method_7964()));
            return true;
        });
    }

    private void openBackpack(class_1657 player, BackpackContext backpackContext) {
        player.method_17355((class_3908)MenuProviderHelper.createMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext::toBuffer, (class_2561)backpackContext.getDisplayName(player)));
    }

    public void write(class_2540 buffer) {
        buffer.method_53002(this.slotIndex);
        buffer.method_10814(this.identifier);
        buffer.method_10814(this.handlerName);
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}

