/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockPickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class RefillUpgradeWrapper
extends UpgradeWrapperBase<RefillUpgradeWrapper, RefillUpgradeItem>
implements IFilteredUpgrade,
ITickableUpgrade,
IBlockPickResponseUpgrade {
    private static final int COOLDOWN = 5;
    private final Map<Integer, TargetSlot> targetSlots;
    private final FilterLogic filterLogic;

    public RefillUpgradeWrapper(IStorageWrapper backpackWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((RefillUpgradeItem)this.upgradeItem).getFilterSlotCount());
        this.targetSlots = NBTHelper.getMap((class_2487)upgrade.method_7948(), (String)"targetSlots", Integer::valueOf, (k, tag) -> Optional.of(TargetSlot.fromName(tag.method_10714()))).orElseGet(HashMap::new);
        if (((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection()) {
            FilterLogic.ObservableFilterItemStackHandler filterHandler = this.filterLogic.getFilterHandler();
            filterHandler.setOnSlotChange(s -> this.onFilterChange(filterHandler, s));
        }
        this.filterLogic.setAllowByDefault(true);
    }

    private void onFilterChange(FilterLogic.ObservableFilterItemStackHandler filterHandler, int slot) {
        if (filterHandler.getStackInSlot(slot).method_7960()) {
            this.targetSlots.remove(slot);
            this.saveTargetSlots();
        } else if (!this.targetSlots.containsKey(slot)) {
            this.setTargetSlot(slot, TargetSlot.ANY);
        }
    }

    public Map<Integer, TargetSlot> getTargetSlots() {
        return this.targetSlots;
    }

    public void setTargetSlot(int slot, TargetSlot targetSlot) {
        this.targetSlots.put(slot, targetSlot);
        this.saveTargetSlots();
    }

    private void saveTargetSlots() {
        NBTHelper.putMap((class_2487)this.upgrade.method_7948(), (String)"targetSlots", this.targetSlots, String::valueOf, t -> class_2519.method_23256((String)t.method_15434()));
        this.save();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void tick(@Nullable class_1309 entity, class_1937 level, class_2338 pos) {
        if (entity == null || this.isInCooldown(level)) {
            return;
        }
        CapabilityHelper.runOnItemHandler((class_1297)entity, playerInvHandler -> InventoryHelper.iterate((SlottedStorage)this.filterLogic.getFilterHandler(), (slot, filter) -> {
            if (filter.method_7960()) {
                return;
            }
            this.tryRefillFilter(entity, (PlayerInventoryStorage)playerInvHandler, (class_1799)filter, this.getTargetSlots().getOrDefault(slot, TargetSlot.ANY));
        }));
        this.setCooldown(level, 5);
    }

    private void tryRefillFilter(@Nonnull class_1309 entity, PlayerInventoryStorage playerInvHandler, class_1799 filter, TargetSlot targetSlot) {
        ItemVariant resource;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        int missingCount = targetSlot.missingCountGetter.getMissingCount(player, playerInvHandler, filter);
        if (class_1799.method_31577((class_1799)player.field_7512.method_34255(), (class_1799)filter)) {
            missingCount -= Math.min(missingCount, player.field_7512.method_34255().method_7947());
        }
        if (missingCount == 0) {
            return;
        }
        ITrackedContentsItemHandler extractFromHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        long extracted = StorageUtil.simulateExtract((Storage)extractFromHandler, (Object)(resource = ItemVariant.of((class_1799)filter)), (long)missingCount, null);
        if (extracted <= 0L) {
            return;
        }
        class_1799 remaining = targetSlot.filler.fill(player, playerInvHandler, resource.toStack((int)extracted));
        if ((long)remaining.method_7947() != extracted) {
            try (Transaction ctx = Transaction.openOuter();){
                extractFromHandler.extract((Object)resource, extracted - (long)remaining.method_7947(), (TransactionContext)ctx);
                ctx.commit();
            }
        }
    }

    public boolean allowsTargetSlotSelection() {
        return ((RefillUpgradeItem)this.upgradeItem).allowsTargetSlotSelection();
    }

    @Override
    public boolean pickBlock(class_1657 player, class_1799 filter) {
        if (!((RefillUpgradeItem)this.upgradeItem).supportsBlockPick()) {
            return false;
        }
        AtomicInteger stashSlot = new AtomicInteger(-1);
        AtomicBoolean hasItemInBackpack = new AtomicBoolean(false);
        ITrackedContentsItemHandler inventoryHandler = this.storageWrapper.getInventoryForUpgradeProcessing();
        InventoryHelper.iterate((SlottedStorage)inventoryHandler, (slot, stack) -> {
            if (class_1799.method_31577((class_1799)stack, (class_1799)filter)) {
                hasItemInBackpack.set(true);
                stashSlot.set((int)slot);
            }
        }, () -> stashSlot.get() > -1);
        class_1799 mainHandItem = player.method_6047();
        ItemVariant mainHandResource = ItemVariant.of((class_1799)mainHandItem);
        ItemVariant filterResource = ItemVariant.of((class_1799)filter);
        if (hasItemInBackpack.get() && StorageUtil.simulateExtract((Storage)inventoryHandler, (Object)filterResource, (long)filter.method_7914(), null) > 0L) {
            if (!(inventoryHandler.getStackInSlot(stashSlot.get()).method_7947() <= filter.method_7914() && inventoryHandler.isItemValid(stashSlot.get(), mainHandResource, mainHandItem.method_7947()) || mainHandItem.method_7960() || StorageUtil.simulateInsert((Storage)inventoryHandler, (Object)mainHandResource, (long)mainHandItem.method_7947(), null) != 0L)) {
                if (this.canMoveMainHandToInventory(player)) {
                    try (Transaction ctx = Transaction.openOuter();){
                        long extracted = inventoryHandler.extract((Object)filterResource, (long)filter.method_7914(), (TransactionContext)ctx);
                        if (extracted > 0L) {
                            player.method_6122(class_1268.field_5808, filterResource.toStack((int)extracted));
                            player.method_31548().method_7394(mainHandItem);
                            ctx.commit();
                            boolean bl = true;
                            return bl;
                        }
                    }
                    return true;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"gui.sophisticatedbackpacks.status.no_space_for_mainhand_item"), true);
                return false;
            }
            try (Transaction ctx = Transaction.openOuter();){
                long extracted = inventoryHandler.extract((Object)filterResource, (long)filter.method_7914(), (TransactionContext)ctx);
                if (extracted > 0L) {
                    player.method_6122(class_1268.field_5808, filterResource.toStack((int)extracted));
                    inventoryHandler.insert((Object)mainHandResource, (long)mainHandItem.method_7947(), (TransactionContext)ctx);
                    ctx.commit();
                    boolean bl = true;
                    return bl;
                }
            }
            return true;
        }
        return false;
    }

    private boolean canMoveMainHandToInventory(class_1657 player) {
        int countToAdd = player.method_6047().method_7947();
        for (int slot = 0; slot < player.method_31548().method_5439() - 5; ++slot) {
            if (slot == player.method_31548().field_7545) continue;
            class_1799 slotStack = player.method_31548().method_5438(slot);
            if (slotStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)player.method_6047()) || (countToAdd -= slotStack.method_7914() - slotStack.method_7947()) > 0) continue;
            return true;
        }
        return false;
    }

    public static enum TargetSlot implements class_3542
    {
        ANY("any", (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any", new Object[0]), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.any.tooltip", new Object[0]).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> InventoryHelper.getCountMissingInHandler((SlottedStorage)playerInvHandler, (class_1799)filter, (int)filter.method_7914()), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillAnywhereInInventory(playerInvHandler, stackToAdd)),
        MAIN_HAND("main_hand", (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand", new Object[0]), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.main_hand.tooltip", new Object[0]).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_6047(), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> ((class_1657)player).method_6047(), stackToAdd, stack -> player.method_6122(class_1268.field_5808, stack))),
        OFF_HAND("off_hand", (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand", new Object[0]), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.off_hand.tooltip", new Object[0]).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_6079(), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> ((class_1657)player).method_6079(), stackToAdd, stack -> player.method_6122(class_1268.field_5810, stack))),
        TOOLBAR_1("toolbar_1", (class_2561)class_2561.method_43470((String)"1"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{1}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(0), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(0), stackToAdd, stack -> player.method_31548().method_5447(0, stack))),
        TOOLBAR_2("toolbar_2", (class_2561)class_2561.method_43470((String)"2"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{2}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(1), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(1), stackToAdd, stack -> player.method_31548().method_5447(1, stack))),
        TOOLBAR_3("toolbar_3", (class_2561)class_2561.method_43470((String)"3"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{3}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(2), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(2), stackToAdd, stack -> player.method_31548().method_5447(2, stack))),
        TOOLBAR_4("toolbar_4", (class_2561)class_2561.method_43470((String)"4"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{4}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(3), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(3), stackToAdd, stack -> player.method_31548().method_5447(3, stack))),
        TOOLBAR_5("toolbar_5", (class_2561)class_2561.method_43470((String)"5"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{5}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(4), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(4), stackToAdd, stack -> player.method_31548().method_5447(4, stack))),
        TOOLBAR_6("toolbar_6", (class_2561)class_2561.method_43470((String)"6"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{6}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(5), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(5), stackToAdd, stack -> player.method_31548().method_5447(5, stack))),
        TOOLBAR_7("toolbar_7", (class_2561)class_2561.method_43470((String)"7"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{7}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(6), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(6), stackToAdd, stack -> player.method_31548().method_5447(6, stack))),
        TOOLBAR_8("toolbar_8", (class_2561)class_2561.method_43470((String)"8"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{8}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(7), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(7), stackToAdd, stack -> player.method_31548().method_5447(7, stack))),
        TOOLBAR_9("toolbar_9", (class_2561)class_2561.method_43470((String)"9"), (class_2561)SBPTranslationHelper.INSTANCE.translUpgrade("refill.target_slot.hotbar.tooltip", new Object[]{9}).method_27692(class_124.field_1077), (player, playerInvHandler, filter) -> TargetSlot.getMissingCount(player.method_31548().method_5438(8), filter), (player, playerInvHandler, stackToAdd) -> TargetSlot.refillSlot(() -> player.method_31548().method_5438(8), stackToAdd, stack -> player.method_31548().method_5447(8, stack)));

        private final String name;
        private final class_2561 acronym;
        private final class_2561 description;
        private final MissingCountGetter missingCountGetter;
        private final Filler filler;
        private static final Map<String, TargetSlot> NAME_VALUES;
        private static final TargetSlot[] VALUES;

        private TargetSlot(String name, class_2561 acronym, class_2561 description, MissingCountGetter missingCountGetter, Filler filler) {
            this.name = name;
            this.acronym = acronym;
            this.description = description;
            this.missingCountGetter = missingCountGetter;
            this.filler = filler;
        }

        public String method_15434() {
            return this.name;
        }

        public TargetSlot next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public TargetSlot previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        public static TargetSlot fromName(String name) {
            return NAME_VALUES.getOrDefault(name, ANY);
        }

        public class_2561 getAcronym() {
            return this.acronym;
        }

        public class_2561 getDescription() {
            return this.description;
        }

        private static class_1799 refillAnywhereInInventory(PlayerInventoryStorage playerInvHandler, class_1799 extracted) {
            ItemVariant resource = ItemVariant.of((class_1799)extracted);
            long remaining = extracted.method_7947();
            try (Transaction outer = Transaction.openOuter();){
                remaining -= playerInvHandler.insert(resource, remaining, (TransactionContext)outer);
                outer.commit();
            }
            return resource.toStack((int)remaining);
        }

        private static int getMissingCount(class_1799 stack, class_1799 filter) {
            if (class_1799.method_31577((class_1799)stack, (class_1799)filter)) {
                return filter.method_7914() - stack.method_7947();
            }
            return filter.method_7914();
        }

        private static class_1799 refillSlot(Supplier<class_1799> getSlotContents, class_1799 stackToAdd, Consumer<class_1799> setSlotContents) {
            class_1799 contents = getSlotContents.get();
            if (contents.method_7960()) {
                setSlotContents.accept(stackToAdd);
                return class_1799.field_8037;
            }
            if (class_1799.method_31577((class_1799)contents, (class_1799)stackToAdd)) {
                contents.method_7933(stackToAdd.method_7947());
                return class_1799.field_8037;
            }
            return stackToAdd;
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (TargetSlot value : TargetSlot.values()) {
                builder.put((Object)value.method_15434(), (Object)value);
            }
            NAME_VALUES = builder.build();
            VALUES = TargetSlot.values();
        }

        private static interface MissingCountGetter {
            public int getMissingCount(class_1657 var1, PlayerInventoryStorage var2, class_1799 var3);
        }

        private static interface Filler {
            public class_1799 fill(class_1657 var1, PlayerInventoryStorage var2, class_1799 var3);
        }

        private static class Constants {
            private static final String HOTBAR_TRANSL = "refill.target_slot.hotbar.tooltip";

            private Constants() {
            }
        }
    }
}

