/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.upgrades.UpgradeDataProvider;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.impl.RegistryHelper;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class TurtleUpgradeDataProvider
extends UpgradeDataProvider<ITurtleUpgrade> {
    private static final class_2960 TOOL_ID = new class_2960("computercraft", "tool");

    public TurtleUpgradeDataProvider(class_7784 output) {
        super(output, "Turtle Upgrades", "computercraft/turtle_upgrades", ITurtleUpgrade.serialiserRegistryKey());
    }

    public final ToolBuilder tool(class_2960 id, class_1792 item) {
        return new ToolBuilder(id, this.existingSerialiser(TOOL_ID), item);
    }

    public static class ToolBuilder {
        private final class_2960 id;
        private final UpgradeSerialiser<? extends ITurtleUpgrade> serialiser;
        private final class_1792 toolItem;
        @Nullable
        private String adjective;
        @Nullable
        private class_1792 craftingItem;
        @Nullable
        private Float damageMultiplier = null;
        @Nullable
        private class_6862<class_2248> breakable;
        private boolean allowEnchantments = false;
        private TurtleToolDurability consumeDurability = TurtleToolDurability.NEVER;

        ToolBuilder(class_2960 id, UpgradeSerialiser<? extends ITurtleUpgrade> serialiser, class_1792 toolItem) {
            this.id = id;
            this.serialiser = serialiser;
            this.toolItem = toolItem;
            this.craftingItem = null;
        }

        public ToolBuilder adjective(String adjective) {
            this.adjective = adjective;
            return this;
        }

        public ToolBuilder craftingItem(class_1792 craftingItem) {
            this.craftingItem = craftingItem;
            return this;
        }

        public ToolBuilder damageMultiplier(float damageMultiplier) {
            this.damageMultiplier = Float.valueOf(damageMultiplier);
            return this;
        }

        public ToolBuilder allowEnchantments() {
            this.allowEnchantments = true;
            return this;
        }

        public ToolBuilder consumeDurability(TurtleToolDurability durability) {
            this.consumeDurability = durability;
            return this;
        }

        public ToolBuilder breakable(class_6862<class_2248> breakable) {
            this.breakable = breakable;
            return this;
        }

        public void add(Consumer<UpgradeDataProvider.Upgrade<UpgradeSerialiser<? extends ITurtleUpgrade>>> add) {
            add.accept(new UpgradeDataProvider.Upgrade<UpgradeSerialiser<? extends ITurtleUpgrade>>(this.id, this.serialiser, s -> {
                s.addProperty("item", RegistryHelper.getKeyOrThrow(class_7923.field_41178, this.toolItem).toString());
                if (this.adjective != null) {
                    s.addProperty("adjective", this.adjective);
                }
                if (this.craftingItem != null) {
                    s.addProperty("craftItem", RegistryHelper.getKeyOrThrow(class_7923.field_41178, this.craftingItem).toString());
                }
                if (this.damageMultiplier != null) {
                    s.addProperty("damageMultiplier", (Number)this.damageMultiplier);
                }
                if (this.breakable != null) {
                    s.addProperty("breakable", this.breakable.comp_327().toString());
                }
                if (this.allowEnchantments) {
                    s.addProperty("allowEnchantments", Boolean.valueOf(true));
                }
                if (this.consumeDurability != TurtleToolDurability.NEVER) {
                    s.addProperty("consumeDurability", this.consumeDurability.method_15434());
                }
            }));
        }
    }
}

