/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.common.HeldItemMenu;
import dan200.computercraft.shared.media.items.PrintoutItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class PrintoutScreen
extends class_465<HeldItemMenu> {
    private final boolean book;
    private final int pages;
    private final TextBuffer[] text;
    private final TextBuffer[] colours;
    private int page;

    public PrintoutScreen(HeldItemMenu container, class_1661 player, class_2561 title) {
        super((class_1703)container, player, title);
        this.field_2779 = 209;
        String[] text = PrintoutItem.getText(container.getStack());
        this.text = new TextBuffer[text.length];
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = new TextBuffer(text[i]);
        }
        String[] colours = PrintoutItem.getColours(container.getStack());
        this.colours = new TextBuffer[colours.length];
        for (int i = 0; i < this.colours.length; ++i) {
            this.colours[i] = new TextBuffer(colours[i]);
        }
        this.page = 0;
        this.pages = Math.max(this.text.length / 21, 1);
        this.book = ((PrintoutItem)container.getStack().method_7909()).getType() == PrintoutItem.Type.BOOK;
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 262) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (key == 263) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return super.method_25404(key, scancode, modifiers);
    }

    public boolean method_25401(double x, double y, double deltaX, double deltaY) {
        if (super.method_25401(x, y, deltaX, deltaY)) {
            return true;
        }
        if (deltaY < 0.0) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (deltaY > 0.0) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return false;
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        class_4597.class_4598 renderer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        PrintoutRenderer.drawBorder(graphics.method_51448(), (class_4597)renderer, this.field_2776, this.field_2800, 0.0f, this.page, this.pages, this.book, 0xF000F0);
        PrintoutRenderer.drawText(graphics.method_51448(), (class_4597)renderer, this.field_2776 + 13, this.field_2800 + 11, 21 * this.page, 0xF000F0, this.text, this.colours);
        renderer.method_22993();
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -1.0f);
        super.method_25420(graphics, mouseX, mouseY, partialTicks);
        graphics.method_51448().method_22909();
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
    }
}

