/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.pocket;

import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class PocketComputerData {
    @Nullable
    private NetworkedTerminal terminal;
    private ComputerState state;
    private int lightColour;

    PocketComputerData(ComputerState state, int lightColour, TerminalState terminalData) {
        this.state = state;
        this.lightColour = lightColour;
        if (terminalData.hasTerminal()) {
            this.terminal = terminalData.create();
        }
    }

    public int getLightState() {
        return this.state != ComputerState.OFF ? this.lightColour : -1;
    }

    @Nullable
    public NetworkedTerminal getTerminal() {
        return this.terminal;
    }

    public ComputerState getState() {
        return this.state;
    }

    void setState(ComputerState state, int lightColour, TerminalState terminalData) {
        this.state = state;
        this.lightColour = lightColour;
        if (terminalData.hasTerminal()) {
            if (this.terminal == null) {
                this.terminal = terminalData.create();
            } else {
                terminalData.apply(this.terminal);
            }
        }
    }
}

