/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.SpriteRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class PocketItemRenderer
extends ItemMapLikeRenderer {
    public static final PocketItemRenderer INSTANCE = new PocketItemRenderer();

    private PocketItemRenderer() {
    }

    @Override
    protected void renderItem(class_4587 transform, class_4597 bufferSource, class_1799 stack, int light) {
        int termHeight;
        int termWidth;
        NetworkedTerminal terminal;
        PocketComputerData computer = ClientPocketComputers.get(stack);
        NetworkedTerminal networkedTerminal = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = Config.pocketTermWidth;
            termHeight = Config.pocketTermHeight;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.method_22903();
        transform.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        transform.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        transform.method_22905(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.method_22905(scale, scale, -1.0f);
        transform.method_22904(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        PocketComputerItem item = (PocketComputerItem)stack.method_7909();
        ComputerFamily family = item.getFamily();
        int frameColour = item.getColour(stack);
        Matrix4f matrix = transform.method_23760().method_23761();
        PocketItemRenderer.renderFrame(matrix, bufferSource, family, frameColour, light, width, height);
        int lightColour = computer == null || computer.getLightState() == -1 ? Colour.BLACK.getHex() : computer.getLightState();
        PocketItemRenderer.renderLight(transform, bufferSource, lightColour, width, height);
        FixedWidthFontRenderer.QuadEmitter quadEmitter = FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(RenderTypes.TERMINAL));
        if (terminal == null) {
            FixedWidthFontRenderer.drawEmptyTerminal(quadEmitter, 0.0f, 0.0f, width, height);
        } else {
            FixedWidthFontRenderer.drawTerminal(quadEmitter, 2.0f, 2.0f, terminal, 2.0f, 2.0f, 2.0f, 2.0f);
        }
        transform.method_22909();
    }

    private static void renderFrame(Matrix4f transform, class_4597 render, ComputerFamily family, int colour, int light, int width, int height) {
        GuiSprites.ComputerTextures texture = colour != -1 ? GuiSprites.COMPUTER_COLOUR : GuiSprites.getComputerTextures(family);
        int r = colour >>> 16 & 0xFF;
        int g = colour >>> 8 & 0xFF;
        int b = colour & 0xFF;
        SpriteRenderer spriteRenderer = new SpriteRenderer(transform, render.getBuffer(RenderTypes.GUI_SPRITES), 0, light, r, g, b);
        ComputerBorderRenderer.render(spriteRenderer, texture, 0, 0, width, height, true);
    }

    private static void renderLight(class_4587 transform, class_4597 render, int colour, int width, int height) {
        byte r = (byte)(colour >>> 16 & 0xFF);
        byte g = (byte)(colour >>> 8 & 0xFF);
        byte b = (byte)(colour & 0xFF);
        byte[] c = new byte[]{r, g, b, -1};
        class_4588 buffer = render.getBuffer(RenderTypes.TERMINAL);
        FixedWidthFontRenderer.drawQuad(FixedWidthFontRenderer.toVertexConsumer(transform, buffer), (float)(width - 16), (float)height + 6.0f, 0.001f, 16.0f, 8.0f, c, 0xF000F0);
    }
}

