/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.turtle;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.impl.RegistryHelper;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.impl.UpgradeManager;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4590;

@Environment(value=EnvType.CLIENT)
public final class TurtleUpgradeModellers {
    private static final TurtleUpgradeModeller<ITurtleUpgrade> NULL_TURTLE_MODELLER = (upgrade, turtle, side, data) -> new TransformedModel(class_310.method_1551().method_1554().method_4744(), class_4590.method_22931());
    private static final Map<UpgradeSerialiser<? extends ITurtleUpgrade>, TurtleUpgradeModeller<?>> turtleModels = new ConcurrentHashMap();
    private static volatile boolean fetchedModels;
    private static final WeakHashMap<ITurtleUpgrade, TurtleUpgradeModeller<?>> modelCache;

    private TurtleUpgradeModellers() {
    }

    public static <T extends ITurtleUpgrade> void register(UpgradeSerialiser<T> serialiser, TurtleUpgradeModeller<T> modeller) {
        if (fetchedModels) {
            throw new IllegalStateException(String.format("Turtle upgrade serialiser %s must be registered before models are baked.", RegistryHelper.getKeyOrThrow(RegistryHelper.getRegistry(ITurtleUpgrade.serialiserRegistryKey()), serialiser)));
        }
        if (turtleModels.putIfAbsent(serialiser, modeller) != null) {
            throw new IllegalStateException("Modeller already registered for serialiser");
        }
    }

    public static TransformedModel getModel(ITurtleUpgrade upgrade, ITurtleAccess access, TurtleSide side) {
        TurtleUpgradeModeller modeller = modelCache.computeIfAbsent(upgrade, TurtleUpgradeModellers::getModeller);
        return modeller.getModel(upgrade, access, side, access.getUpgradeNBTData(side));
    }

    public static TransformedModel getModel(ITurtleUpgrade upgrade, class_2487 data, TurtleSide side) {
        TurtleUpgradeModeller modeller = modelCache.computeIfAbsent(upgrade, TurtleUpgradeModellers::getModeller);
        return modeller.getModel(upgrade, null, side, data);
    }

    private static TurtleUpgradeModeller<?> getModeller(ITurtleUpgrade upgradeA) {
        UpgradeManager.UpgradeWrapper<ITurtleUpgrade> wrapper = TurtleUpgrades.instance().getWrapper(upgradeA);
        if (wrapper == null) {
            return NULL_TURTLE_MODELLER;
        }
        TurtleUpgradeModeller<?> modeller = turtleModels.get(wrapper.serialiser());
        return modeller == null ? NULL_TURTLE_MODELLER : modeller;
    }

    public static Stream<class_2960> getDependencies() {
        fetchedModels = true;
        return turtleModels.values().stream().flatMap(x -> x.getDependencies().stream());
    }

    static {
        modelCache = new WeakHashMap();
    }
}

