/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.filesystem.MountConstants;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.handles.ReadHandle;
import dan200.computercraft.core.apis.handles.ReadWriteHandle;
import dan200.computercraft.core.apis.handles.WriteHandle;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.filesystem.FileSystemWrapper;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.core.metrics.OperationTimer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;

public class FSAPI
implements ILuaAPI {
    private static final Set<OpenOption> READ_EXTENDED = Set.of(StandardOpenOption.READ, StandardOpenOption.WRITE);
    private static final Set<OpenOption> WRITE_EXTENDED = FSAPI.union(Set.of(StandardOpenOption.READ), MountConstants.WRITE_OPTIONS);
    private final IAPIEnvironment environment;
    @Nullable
    private FileSystem fileSystem = null;

    public FSAPI(IAPIEnvironment env) {
        this.environment = env;
    }

    @Override
    public String[] getNames() {
        return new String[]{"fs"};
    }

    @Override
    public void startup() {
        this.fileSystem = this.environment.getFileSystem();
    }

    @Override
    public void shutdown() {
        this.fileSystem = null;
    }

    private FileSystem getFileSystem() {
        FileSystem filesystem = this.fileSystem;
        if (filesystem == null) {
            throw new IllegalStateException("File system is not mounted");
        }
        return filesystem;
    }

    @LuaFunction
    public final String[] list(String path) throws LuaException {
        OperationTimer ignored = this.environment.time(Metrics.FS_OPS);
        try {
            String[] stringArray = this.getFileSystem().list(path);
            if (ignored != null) {
                ignored.close();
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (FileSystemException e) {
                throw new LuaException(e.getMessage());
            }
        }
    }

    @LuaFunction
    public final String combine(IArguments arguments) throws LuaException {
        StringBuilder result = new StringBuilder();
        result.append(FileSystem.sanitizePath(arguments.getString(0), true));
        int n = arguments.count();
        for (int i = 1; i < n; ++i) {
            String part = FileSystem.sanitizePath(arguments.getString(i), true);
            if (result.length() != 0 && !part.isEmpty()) {
                result.append('/');
            }
            result.append(part);
        }
        return FileSystem.sanitizePath(result.toString(), true);
    }

    @LuaFunction
    public final String getName(String path) {
        return FileSystem.getName(path);
    }

    @LuaFunction
    public final String getDir(String path) {
        return FileSystem.getDirectory(path);
    }

    @LuaFunction
    public final long getSize(String path) throws LuaException {
        OperationTimer ignored = this.environment.time(Metrics.FS_OPS);
        try {
            long l = this.getFileSystem().getSize(path);
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (FileSystemException e) {
                throw new LuaException(e.getMessage());
            }
        }
    }

    @LuaFunction
    public final boolean exists(String path) {
        OperationTimer ignored = this.environment.time(Metrics.FS_OPS);
        try {
            boolean bl = this.getFileSystem().exists(path);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (FileSystemException e) {
                return false;
            }
        }
    }

    @LuaFunction
    public final boolean isDir(String path) {
        OperationTimer ignored = this.environment.time(Metrics.FS_OPS);
        try {
            boolean bl = this.getFileSystem().isDir(path);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (FileSystemException e) {
                return false;
            }
        }
    }

    @LuaFunction
    public final boolean isReadOnly(String path) {
        OperationTimer ignored = this.environment.time(Metrics.FS_OPS);
        try {
            boolean bl = this.getFileSystem().isReadOnly(path);
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (FileSystemException e) {
                return false;
            }
        }
    }

    @LuaFunction
    public final void makeDir(String path) throws LuaException {
        try (OperationTimer ignored = this.environment.time(Metrics.FS_OPS);){
            this.getFileSystem().makeDir(path);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void move(String path, String dest) throws LuaException {
        try (OperationTimer ignored = this.environment.time(Metrics.FS_OPS);){
            this.getFileSystem().move(path, dest);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void copy(String path, String dest) throws LuaException {
        try (OperationTimer ignored = this.environment.time(Metrics.FS_OPS);){
            this.getFileSystem().copy(path, dest);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final void delete(String path) throws LuaException {
        try (OperationTimer ignored = this.environment.time(Metrics.FS_OPS);){
            this.getFileSystem().delete(path);
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LuaFunction
    public final Object[] open(String path, String mode) throws LuaException {
        if (mode.isEmpty()) {
            throw new LuaException("Unsupported mode");
        }
        boolean binary = mode.indexOf(98) >= 0;
        try (OperationTimer ignored = this.environment.time(Metrics.FS_OPS);){
            switch (mode) {
                case "r": 
                case "rb": {
                    FileSystemWrapper<SeekableByteChannel> reader = this.getFileSystem().openForRead(path);
                    Object[] objectArray = new Object[]{new ReadHandle(reader.get(), reader, binary)};
                    return objectArray;
                }
                case "w": 
                case "wb": {
                    FileSystemWrapper<SeekableByteChannel> writer = this.getFileSystem().openForWrite(path, MountConstants.WRITE_OPTIONS);
                    Object[] objectArray = new Object[]{WriteHandle.of(writer.get(), writer, binary, true)};
                    return objectArray;
                }
                case "a": 
                case "ab": {
                    FileSystemWrapper<SeekableByteChannel> writer = this.getFileSystem().openForWrite(path, MountConstants.APPEND_OPTIONS);
                    Object[] objectArray = new Object[]{WriteHandle.of(writer.get(), writer, binary, false)};
                    return objectArray;
                }
                case "r+": 
                case "r+b": {
                    FileSystemWrapper<SeekableByteChannel> reader = this.getFileSystem().openForWrite(path, READ_EXTENDED);
                    Object[] objectArray = new Object[]{new ReadWriteHandle(reader.get(), reader, binary)};
                    return objectArray;
                }
                case "w+": 
                case "w+b": {
                    FileSystemWrapper<SeekableByteChannel> writer = this.getFileSystem().openForWrite(path, WRITE_EXTENDED);
                    Object[] objectArray = new Object[]{new ReadWriteHandle(writer.get(), writer, binary)};
                    return objectArray;
                }
            }
            throw new LuaException("Unsupported mode");
        }
        catch (FileSystemException e) {
            return new Object[]{null, e.getMessage()};
        }
    }

    @Nullable
    @LuaFunction
    public final Object[] getDrive(String path) throws LuaException {
        try {
            Object[] objectArray;
            if (this.getFileSystem().exists(path)) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getFileSystem().getMountLabel(path);
            } else {
                objectArray = null;
            }
            return objectArray;
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final Object getFreeSpace(String path) throws LuaException {
        try {
            long freeSpace = this.getFileSystem().getFreeSpace(path);
            return freeSpace >= 0L ? Long.valueOf(freeSpace) : "unlimited";
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Nullable
    @LuaFunction
    public final Object getCapacity(String path) throws LuaException {
        try {
            OptionalLong capacity = this.getFileSystem().getCapacity(path);
            return capacity.isPresent() ? Long.valueOf(capacity.getAsLong()) : null;
        }
        catch (FileSystemException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaFunction
    public final Map<String, Object> attributes(String path) throws LuaException {
        OperationTimer ignored = this.environment.time(Metrics.FS_OPS);
        try {
            BasicFileAttributes attributes = this.getFileSystem().getAttributes(path);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("modification", attributes.lastModifiedTime().toMillis());
            result.put("modified", attributes.lastModifiedTime().toMillis());
            result.put("created", attributes.creationTime().toMillis());
            result.put("size", attributes.isDirectory() ? 0L : attributes.size());
            result.put("isDir", attributes.isDirectory());
            result.put("isReadOnly", this.getFileSystem().isReadOnly(path));
            HashMap<String, Object> hashMap = result;
            if (ignored != null) {
                ignored.close();
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (FileSystemException e) {
                throw new LuaException(e.getMessage());
            }
        }
    }

    private static Set<OpenOption> union(Set<OpenOption> a, Set<OpenOption> b) {
        HashSet<OpenOption> union = new HashSet<OpenOption>();
        union.addAll(a);
        union.addAll(b);
        return Set.copyOf(union);
    }
}

