/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data.recipe;

import com.mojang.serialization.DataResult;
import dan200.computercraft.shared.recipe.RecipeProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;

public abstract class AbstractRecipeBuilder<S extends AbstractRecipeBuilder<S, O>, O> {
    private final class_7800 category;
    protected final class_1799 result;
    private String group = "";
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();

    protected AbstractRecipeBuilder(class_7800 category, class_1799 result) {
        this.category = category;
        this.result = result;
    }

    public final S group(String group) {
        this.group = group;
        return this.self();
    }

    public final S unlockedBy(String name, class_175<?> criterion) {
        this.criteria.put(name, criterion);
        return this.self();
    }

    protected abstract O build(RecipeProperties var1);

    public final FinishedRecipe build(Function<O, class_1860<?>> factory) {
        RecipeProperties properties = new RecipeProperties(this.group, class_5797.method_55308((class_7800)this.category), true);
        return new FinishedRecipe(factory.apply(this.build(properties)), this.result.method_7909(), this.category, this.criteria);
    }

    public final FinishedRecipe buildOrThrow(Function<O, DataResult<? extends class_1860<?>>> factory) {
        return this.build((O s) -> (class_1860)class_156.method_47526((DataResult)((DataResult)factory.apply(s)), IllegalStateException::new));
    }

    private S self() {
        return (S)this;
    }

    public static final class FinishedRecipe {
        private final class_1860<?> recipe;
        private final class_1792 result;
        private final class_7800 category;
        private final Map<String, class_175<?>> criteria;

        private FinishedRecipe(class_1860<?> recipe, class_1792 result, class_7800 category, Map<String, class_175<?>> criteria) {
            this.recipe = recipe;
            this.result = result;
            this.category = category;
            this.criteria = criteria;
        }

        public void save(class_8790 output, class_2960 id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + id);
            }
            class_161.class_162 advancement = output.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_8782.class_8797.field_1257);
            for (Map.Entry<String, class_175<?>> entry : this.criteria.entrySet()) {
                advancement.method_705(entry.getKey(), entry.getValue());
            }
            output.method_53819(id, this.recipe, advancement.method_695(id.method_45138("recipes/" + this.category.method_46203() + "/")));
        }

        public void save(class_8790 output) {
            this.save(output, class_5797.method_36442((class_1935)this.result));
        }
    }
}

