/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.redstone.BundledRedstoneProvider;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundledRedstone {
    private static final Logger LOG = LoggerFactory.getLogger(BundledRedstone.class);
    private static final ArrayList<BundledRedstoneProvider> providers = new ArrayList();

    private BundledRedstone() {
    }

    public static synchronized void register(BundledRedstoneProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        if (!providers.contains(provider)) {
            providers.add(provider);
        }
    }

    public static int getDefaultOutput(class_1937 world, class_2338 pos, class_2350 side) {
        return world.method_24794(pos) ? DefaultBundledRedstoneProvider.getDefaultBundledRedstoneOutput(world, pos, side) : -1;
    }

    private static int getUnmaskedOutput(class_1937 world, class_2338 pos, class_2350 side) {
        if (!world.method_24794(pos)) {
            return -1;
        }
        int combinedSignal = -1;
        for (BundledRedstoneProvider bundledRedstoneProvider : providers) {
            try {
                int signal = bundledRedstoneProvider.getBundledRedstoneOutput(world, pos, side);
                if (signal < 0) continue;
                combinedSignal = combinedSignal < 0 ? signal & 0xFFFF : combinedSignal | signal & 0xFFFF;
            }
            catch (Exception e) {
                LOG.error("Bundled redstone provider " + bundledRedstoneProvider + " errored.", (Throwable)e);
            }
        }
        return combinedSignal;
    }

    public static int getOutput(class_1937 world, class_2338 pos, class_2350 side) {
        int signal = BundledRedstone.getUnmaskedOutput(world, pos, side);
        return signal >= 0 ? signal : 0;
    }
}

