/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.apis;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.Logging;
import dan200.computercraft.shared.computer.blocks.CommandComputerBlockEntity;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAPI
implements ILuaAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CommandAPI.class);
    private final CommandComputerBlockEntity computer;

    public CommandAPI(CommandComputerBlockEntity computer) {
        this.computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"commands"};
    }

    private static Object createOutput(String output) {
        return new Object[]{output};
    }

    private Object[] doCommand(String command) {
        MinecraftServer server = this.computer.method_10997().method_8503();
        if (server == null || !server.method_3812()) {
            return new Object[]{false, CommandAPI.createOutput("Command blocks disabled by server")};
        }
        class_2170 commandManager = server.method_3734();
        CommandComputerBlockEntity.CommandReceiver receiver = this.computer.getReceiver();
        try {
            receiver.clearOutput();
            CommandState state = new CommandState();
            class_2168 source = this.computer.getSource().method_9231((success, x) -> {
                if (success) {
                    ++state.successes;
                }
            });
            commandManager.method_44252(source, command);
            return new Object[]{state.successes > 0, receiver.copyOutput(), state.successes};
        }
        catch (Throwable t) {
            LOG.error(Logging.JAVA_ERROR, "Error running command.", t);
            return new Object[]{false, CommandAPI.createOutput("Java Exception Thrown: " + t)};
        }
    }

    private static Map<?, ?> getBlockInfo(class_1937 world, class_2338 pos) {
        BlockReference block = new BlockReference(world, pos);
        Map<String, Object> table = VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails(block);
        class_2586 tile = block.blockEntity();
        if (tile != null) {
            table.put("nbt", NBTUtil.toLua((class_2520)tile.method_38242()));
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public final Object[] exec(String command) {
        return this.doCommand(command);
    }

    @LuaFunction
    public final long execAsync(ILuaContext context, String command) throws LuaException {
        return context.issueMainThreadTask(() -> this.doCommand(command));
    }

    @LuaFunction(mainThread=true)
    public final List<String> list(IArguments args) throws LuaException {
        MinecraftServer server = this.computer.method_10997().method_8503();
        if (server == null) {
            return List.of();
        }
        RootCommandNode node = server.method_3734().method_9235().getRoot();
        for (int j = 0; j < args.count(); ++j) {
            String name = args.getString(j);
            if ((node = node.getChild(name)) instanceof LiteralCommandNode) continue;
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (CommandNode child : node.getChildren()) {
            if (!(child instanceof LiteralCommandNode)) continue;
            result.add(child.getName());
        }
        return Collections.unmodifiableList(result);
    }

    @LuaFunction
    public final Object[] getBlockPosition() {
        class_2338 pos = this.computer.method_11016();
        return new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
    }

    @LuaFunction(mainThread=true)
    public final List<Map<?, ?>> getBlockInfos(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Optional<String> dimension) throws LuaException {
        class_1937 world = this.getLevel(dimension);
        class_2338 min = new class_2338(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        class_2338 max = new class_2338(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
        if (world == null || !world.method_24794(min) || !world.method_24794(max)) {
            throw new LuaException("Co-ordinates out of range");
        }
        int blocks = (max.method_10263() - min.method_10263() + 1) * (max.method_10264() - min.method_10264() + 1) * (max.method_10260() - min.method_10260() + 1);
        if (blocks > 4096) {
            throw new LuaException("Too many blocks");
        }
        ArrayList results = new ArrayList(blocks);
        for (int y = min.method_10264(); y <= max.method_10264(); ++y) {
            for (int z = min.method_10260(); z <= max.method_10260(); ++z) {
                for (int x = min.method_10263(); x <= max.method_10263(); ++x) {
                    class_2338 pos = new class_2338(x, y, z);
                    results.add(CommandAPI.getBlockInfo(world, pos));
                }
            }
        }
        return results;
    }

    @LuaFunction(mainThread=true)
    public final Map<?, ?> getBlockInfo(int x, int y, int z, Optional<String> dimension) throws LuaException {
        class_2338 position;
        class_1937 level = this.getLevel(dimension);
        if (!level.method_24794(position = new class_2338(x, y, z))) {
            throw new LuaException("Co-ordinates out of range");
        }
        return CommandAPI.getBlockInfo(level, position);
    }

    private class_1937 getLevel(Optional<String> id) throws LuaException {
        class_3218 currentLevel = (class_3218)this.computer.method_10997();
        if (currentLevel == null) {
            throw new LuaException("No world exists");
        }
        if (!id.isPresent()) {
            return currentLevel;
        }
        class_2960 dimensionId = class_2960.method_12829((String)id.get());
        if (dimensionId == null) {
            throw new LuaException("Invalid dimension name");
        }
        class_3218 level = currentLevel.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimensionId));
        if (level == null) {
            throw new LuaException("Unknown dimension");
        }
        return level;
    }

    private static final class CommandState {
        int successes;

        private CommandState() {
        }
    }
}

