/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerComputer
implements InputHandler,
ComputerEnvironment {
    private final UUID instanceUUID = UUID.randomUUID();
    private class_3218 level;
    private class_2338 position;
    private final ComputerFamily family;
    private final MetricsObserver metrics;
    private final Computer computer;
    private final NetworkedTerminal terminal;
    private final AtomicBoolean terminalChanged = new AtomicBoolean(false);
    private int ticksSincePing;

    public ServerComputer(class_3218 level, class_2338 position, int computerID, @Nullable String label, ComputerFamily family, int terminalWidth, int terminalHeight) {
        this.level = level;
        this.position = position;
        this.family = family;
        ServerContext context = ServerContext.get(level.method_8503());
        this.terminal = new NetworkedTerminal(terminalWidth, terminalHeight, family != ComputerFamily.NORMAL, this::markTerminalChanged);
        this.metrics = context.metrics().createMetricObserver(this);
        this.computer = new Computer(context.computerContext(), this, this.terminal, computerID);
        this.computer.setLabel(label);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public void setLevel(class_3218 level) {
        this.level = level;
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public void setPosition(class_2338 pos) {
        this.position = new class_2338((class_2382)pos);
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.computer.getAPIEnvironment();
    }

    public Computer getComputer() {
        return this.computer;
    }

    protected void markTerminalChanged() {
        this.terminalChanged.set(true);
    }

    public void tickServer() {
        ++this.ticksSincePing;
        this.computer.tick();
        if (this.terminalChanged.getAndSet(false)) {
            this.onTerminalChanged();
        }
    }

    protected void onTerminalChanged() {
        this.sendToAllInteracting(c -> new ComputerTerminalClientMessage((class_1703)c, this.getTerminalState()));
    }

    public TerminalState getTerminalState() {
        return new TerminalState(this.terminal);
    }

    public void keepAlive() {
        this.ticksSincePing = 0;
    }

    public boolean hasTimedOut() {
        return this.ticksSincePing > 100;
    }

    public int pollAndResetChanges() {
        return this.computer.pollAndResetChanges();
    }

    public UUID register() {
        ServerContext.get(this.level.method_8503()).registry().add(this);
        return this.instanceUUID;
    }

    void unload() {
        this.computer.unload();
    }

    public void close() {
        this.unload();
        ServerContext.get(this.level.method_8503()).registry().remove(this);
    }

    private void sendToAllInteracting(Function<class_1703, NetworkMessage<ClientNetworkContext>> createPacket) {
        MinecraftServer server = this.level.method_8503();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!(player.field_7512 instanceof ComputerMenu) || ((ComputerMenu)player.field_7512).getComputer() != this) continue;
            ServerNetworking.sendToPlayer(createPacket.apply(player.field_7512), player);
        }
    }

    protected void onRemoved() {
    }

    public UUID getInstanceUUID() {
        return this.instanceUUID;
    }

    public int getID() {
        return this.computer.getID();
    }

    @Nullable
    public String getLabel() {
        return this.computer.getLabel();
    }

    public boolean isOn() {
        return this.computer.isOn();
    }

    public ComputerState getState() {
        if (!this.computer.isOn()) {
            return ComputerState.OFF;
        }
        return this.computer.isBlinking() ? ComputerState.BLINKING : ComputerState.ON;
    }

    @Override
    public void turnOn() {
        this.computer.turnOn();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event, @Nullable Object[] arguments) {
        this.computer.queueEvent(event, arguments);
    }

    public int getRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalRedstoneOutput(side);
    }

    public void setRedstoneInput(ComputerSide side, int level) {
        this.computer.getEnvironment().setRedstoneInput(side, level);
    }

    public int getBundledRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalBundledRedstoneOutput(side);
    }

    public void setBundledRedstoneInput(ComputerSide side, int combination) {
        this.computer.getEnvironment().setBundledRedstoneInput(side, combination);
    }

    public void addAPI(ILuaAPI api) {
        this.computer.addApi(api);
    }

    public void setPeripheral(ComputerSide side, @Nullable IPeripheral peripheral) {
        this.computer.getEnvironment().setPeripheral(side, peripheral);
    }

    @Nullable
    public IPeripheral getPeripheral(ComputerSide side) {
        return this.computer.getEnvironment().getPeripheral(side);
    }

    public void setLabel(@Nullable String label) {
        this.computer.setLabel(label);
    }

    @Override
    public double getTimeOfDay() {
        return (double)((this.level.method_8532() + 6000L) % 24000L) / 1000.0;
    }

    @Override
    public int getDay() {
        return (int)((this.level.method_8532() + 6000L) / 24000L) + 1;
    }

    @Override
    public MetricsObserver getMetrics() {
        return this.metrics;
    }

    @Override
    @Nullable
    public WritableMount createRootMount() {
        return ComputerCraftAPI.createSaveDirMount(this.level.method_8503(), "computer/" + this.computer.getID(), Config.computerSpaceLimit);
    }
}

