/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;

public class ServerComputerRegistry {
    private static final Random RANDOM = new Random();
    private final int sessionId = RANDOM.nextInt();
    private final Map<UUID, ServerComputer> computersByInstanceUuid = new HashMap<UUID, ServerComputer>();

    public int getSessionID() {
        return this.sessionId;
    }

    @Nullable
    public ServerComputer get(@Nullable UUID instanceID) {
        return instanceID != null ? this.computersByInstanceUuid.get(instanceID) : null;
    }

    @Nullable
    public ServerComputer get(int sessionId, @Nullable UUID instanceId) {
        return sessionId == this.sessionId ? this.get(instanceId) : null;
    }

    void update() {
        Iterator<ServerComputer> it = this.computersByInstanceUuid.values().iterator();
        while (it.hasNext()) {
            ServerComputer computer = it.next();
            if (computer.hasTimedOut()) {
                computer.unload();
                computer.onRemoved();
                it.remove();
                this.computersByInstanceUuid.remove(computer.getInstanceUUID());
                continue;
            }
            computer.tickServer();
        }
    }

    void add(ServerComputer computer) {
        UUID instanceUUID = computer.getInstanceUUID();
        if (this.computersByInstanceUuid.containsKey(instanceUUID)) {
            throw new IllegalStateException("Duplicate computer " + instanceUUID);
        }
        this.computersByInstanceUuid.put(instanceUUID, computer);
    }

    void remove(ServerComputer computer) {
        computer.unload();
        computer.onRemoved();
        this.computersByInstanceUuid.remove(computer.getInstanceUUID());
    }

    void close() {
        for (ServerComputer computer : this.getComputers()) {
            computer.unload();
        }
        this.computersByInstanceUuid.clear();
    }

    public Collection<ServerComputer> getComputers() {
        return this.computersByInstanceUuid.values();
    }
}

