/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.class_2540;

public class TerminalState {
    private final boolean colour;
    private final int width;
    private final int height;
    @Nullable
    private final ByteBuf buffer;

    public TerminalState(@Nullable NetworkedTerminal terminal) {
        if (terminal == null) {
            this.colour = false;
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        } else {
            this.colour = terminal.isColour();
            this.width = terminal.getWidth();
            this.height = terminal.getHeight();
            ByteBuf buf = this.buffer = Unpooled.buffer();
            terminal.write(new class_2540(buf));
        }
    }

    public TerminalState(class_2540 buf) {
        this.colour = buf.readBoolean();
        if (buf.readBoolean()) {
            this.width = buf.method_10816();
            this.height = buf.method_10816();
            int length = buf.method_10816();
            this.buffer = buf.readBytes(length);
        } else {
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        }
    }

    public void write(class_2540 buf) {
        buf.method_52964(this.colour);
        buf.method_52964(this.buffer != null);
        if (this.buffer != null) {
            buf.method_10804(this.width);
            buf.method_10804(this.height);
            buf.method_10804(this.buffer.readableBytes());
            buf.method_52977(this.buffer, this.buffer.readerIndex(), this.buffer.readableBytes());
        }
    }

    public boolean hasTerminal() {
        return this.buffer != null;
    }

    public int size() {
        return this.buffer == null ? 0 : this.buffer.readableBytes();
    }

    public void apply(NetworkedTerminal terminal) {
        if (this.buffer == null) {
            throw new NullPointerException("buffer");
        }
        terminal.resize(this.width, this.height);
        terminal.read(new class_2540(this.buffer));
    }

    public NetworkedTerminal create() {
        if (this.buffer == null) {
            throw new NullPointerException("Terminal does not exist");
        }
        NetworkedTerminal terminal = new NetworkedTerminal(this.width, this.height, this.colour);
        terminal.read(new class_2540(this.buffer));
        return terminal;
    }
}

