/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_7710;
import net.minecraft.class_8957;

public class UpgradeRecipeGenerator<T> {
    private final Function<class_1869, T> wrap;
    private final Map<class_1792, List<UpgradeInfo>> upgradeItemLookup = new HashMap<class_1792, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    public UpgradeRecipeGenerator(Function<class_1869, T> wrap) {
        this.wrap = wrap;
    }

    private void setupCache() {
        UpgradeInfo info;
        class_1799 stack;
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        for (ITurtleUpgrade iTurtleUpgrade : TurtleUpgrades.instance().getUpgrades()) {
            stack = iTurtleUpgrade.getCraftingItem();
            if (stack.method_7960()) {
                return;
            }
            info = new UpgradeInfo(stack, iTurtleUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.method_7909(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        }
        for (IPocketUpgrade iPocketUpgrade : PocketUpgrades.instance().getUpgrades()) {
            stack = iPocketUpgrade.getCraftingItem();
            if (stack.method_7960()) {
                return;
            }
            info = new UpgradeInfo(stack, iPocketUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.method_7909(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        }
    }

    public boolean isUpgrade(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.method_7909());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            class_1799 craftingStack = upgrade.stack;
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    public List<T> findRecipesWithInput(class_1799 stack) {
        this.setupCache();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof TurtleItem) {
            TurtleItem item = (TurtleItem)class_17922;
            UpgradeData<ITurtleUpgrade> left = item.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = item.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            class_1856 ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (upgrade.turtle == null) {
                    throw new NullPointerException();
                }
                if (left == null) {
                    recipes.add(this.turtle(ingredient, upgrade.ingredient, UpgradeRecipeGenerator.turtleWith(stack, UpgradeData.ofDefault(upgrade.turtle), right)));
                }
                if (right != null) continue;
                recipes.add(this.turtle(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.turtleWith(stack, left, UpgradeData.ofDefault(upgrade.turtle))));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.method_7909() instanceof PocketComputerItem) {
            IPocketUpgrade back = PocketComputerItem.getUpgrade(stack);
            if (back != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            class_1856 ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                if (upgrade.pocket == null) {
                    throw new NullPointerException();
                }
                recipes.add(this.pocket(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.pocketWith(stack, UpgradeData.ofDefault(upgrade.pocket))));
            }
            return Collections.unmodifiableList(recipes);
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.method_7909());
        if (upgrades == null) {
            return List.of();
        }
        List recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            class_1799 craftingStack = upgrade.stack;
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? List.of() : Collections.unmodifiableList(recipes);
    }

    public List<T> findRecipesWithOutput(class_1799 stack) {
        ArrayList<T> recipes;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof TurtleItem) {
            TurtleItem item = (TurtleItem)class_17922;
            recipes = new ArrayList<T>(0);
            UpgradeData<ITurtleUpgrade> left = item.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = item.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(this.turtle(class_1856.method_8101((class_1799[])new class_1799[]{UpgradeRecipeGenerator.turtleWith(stack, null, right)}), class_1856.method_8101((class_1799[])new class_1799[]{left.getUpgradeItem()}), stack));
            }
            if (right != null) {
                recipes.add(this.turtle(class_1856.method_8101((class_1799[])new class_1799[]{right.getUpgradeItem()}), class_1856.method_8101((class_1799[])new class_1799[]{UpgradeRecipeGenerator.turtleWith(stack, left, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.method_7909() instanceof PocketComputerItem) {
            recipes = new ArrayList(0);
            UpgradeData<IPocketUpgrade> back = PocketComputerItem.getUpgradeWithData(stack);
            if (back != null) {
                recipes.add(this.pocket(class_1856.method_8101((class_1799[])new class_1799[]{back.getUpgradeItem()}), class_1856.method_8101((class_1799[])new class_1799[]{UpgradeRecipeGenerator.pocketWith(stack, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        return List.of();
    }

    private static class_1799 turtleWith(class_1799 stack, @Nullable UpgradeData<ITurtleUpgrade> left, @Nullable UpgradeData<ITurtleUpgrade> right) {
        TurtleItem item = (TurtleItem)stack.method_7909();
        return item.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), left, right, item.getFuelLevel(stack), item.getOverlay(stack));
    }

    private static class_1799 pocketWith(class_1799 stack, @Nullable UpgradeData<IPocketUpgrade> back) {
        PocketComputerItem item = (PocketComputerItem)stack.method_7909();
        return item.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), back);
    }

    private T pocket(class_1856 upgrade, class_1856 pocketComputer, class_1799 result) {
        return this.wrap.apply(new class_1869("", class_7710.field_40251, new class_8957(1, 2, class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{upgrade, pocketComputer}), Optional.empty()), result));
    }

    private T turtle(class_1856 left, class_1856 right, class_1799 result) {
        return this.wrap.apply(new class_1869("", class_7710.field_40251, new class_8957(2, 1, class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{left, right}), Optional.empty()), result));
    }

    private class UpgradeInfo {
        final class_1799 stack;
        final class_1856 ingredient;
        @Nullable
        final ITurtleUpgrade turtle;
        @Nullable
        final IPocketUpgrade pocket;
        final UpgradeBase upgrade;
        @Nullable
        private ArrayList<T> recipes;

        UpgradeInfo(class_1799 stack, ITurtleUpgrade turtle) {
            this.stack = stack;
            this.ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            this.turtle = turtle;
            this.upgrade = this.turtle;
            this.pocket = null;
        }

        UpgradeInfo(class_1799 stack, IPocketUpgrade pocket) {
            this.stack = stack;
            this.ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            this.turtle = null;
            this.pocket = pocket;
            this.upgrade = this.pocket;
        }

        List<T> getRecipes() {
            ArrayList<Object> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            if (this.turtle != null) {
                for (Supplier<IColouredItem> supplier : RecipeModHelpers.TURTLES) {
                    TurtleItem turtleItem = (TurtleItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.turtle(this.ingredient, class_1856.method_8101((class_1799[])new class_1799[]{turtleItem.create(-1, null, -1, null, null, 0, null)}), turtleItem.create(-1, null, -1, null, UpgradeData.ofDefault(this.turtle), 0, null)));
                }
            }
            if (this.pocket != null) {
                for (Supplier<IColouredItem> supplier : RecipeModHelpers.POCKET_COMPUTERS) {
                    PocketComputerItem pocketItem = (PocketComputerItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.pocket(this.ingredient, class_1856.method_8101((class_1799[])new class_1799[]{pocketItem.create(-1, null, -1, null)}), pocketItem.create(-1, null, -1, UpgradeData.ofDefault(this.pocket))));
                }
            }
            recipes.trimToSize();
            return recipes;
        }
    }
}

