/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.client.UpgradesLoadedMessage;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public final class NetworkMessages {
    private static final Set<String> seenChannel = new HashSet<String>();
    private static final List<MessageType<? extends NetworkMessage<ServerNetworkContext>>> serverMessages = new ArrayList<MessageType<? extends NetworkMessage<ServerNetworkContext>>>();
    private static final List<MessageType<? extends NetworkMessage<ClientNetworkContext>>> clientMessages = new ArrayList<MessageType<? extends NetworkMessage<ClientNetworkContext>>>();
    public static final MessageType<ComputerActionServerMessage> COMPUTER_ACTION = NetworkMessages.registerServerbound("computer_action", ComputerActionServerMessage::new);
    public static final MessageType<QueueEventServerMessage> QUEUE_EVENT = NetworkMessages.registerServerbound("queue_event", QueueEventServerMessage::new);
    public static final MessageType<KeyEventServerMessage> KEY_EVENT = NetworkMessages.registerServerbound("key_event", KeyEventServerMessage::new);
    public static final MessageType<MouseEventServerMessage> MOUSE_EVENT = NetworkMessages.registerServerbound("mouse_event", MouseEventServerMessage::new);
    public static final MessageType<UploadFileMessage> UPLOAD_FILE = NetworkMessages.registerServerbound("upload_file", UploadFileMessage::new);
    public static final MessageType<ChatTableClientMessage> CHAT_TABLE = NetworkMessages.registerClientbound("chat_table", ChatTableClientMessage::new);
    public static final MessageType<PocketComputerDataMessage> POCKET_COMPUTER_DATA = NetworkMessages.registerClientbound("pocket_computer_data", PocketComputerDataMessage::new);
    public static final MessageType<PocketComputerDeletedClientMessage> POCKET_COMPUTER_DELETED = NetworkMessages.registerClientbound("pocket_computer_deleted", PocketComputerDeletedClientMessage::new);
    public static final MessageType<ComputerTerminalClientMessage> COMPUTER_TERMINAL = NetworkMessages.registerClientbound("computer_terminal", ComputerTerminalClientMessage::new);
    public static final MessageType<PlayRecordClientMessage> PLAY_RECORD = NetworkMessages.registerClientbound("play_record", PlayRecordClientMessage::new);
    public static final MessageType<MonitorClientMessage> MONITOR_CLIENT = NetworkMessages.registerClientbound("monitor_client", MonitorClientMessage::new);
    public static final MessageType<SpeakerAudioClientMessage> SPEAKER_AUDIO = NetworkMessages.registerClientbound("speaker_audio", SpeakerAudioClientMessage::new);
    public static final MessageType<SpeakerMoveClientMessage> SPEAKER_MOVE = NetworkMessages.registerClientbound("speaker_move", SpeakerMoveClientMessage::new);
    public static final MessageType<SpeakerPlayClientMessage> SPEAKER_PLAY = NetworkMessages.registerClientbound("speaker_play", SpeakerPlayClientMessage::new);
    public static final MessageType<SpeakerStopClientMessage> SPEAKER_STOP = NetworkMessages.registerClientbound("speaker_stop", SpeakerStopClientMessage::new);
    public static final MessageType<UploadResultMessage> UPLOAD_RESULT = NetworkMessages.registerClientbound("upload_result", UploadResultMessage::new);
    public static final MessageType<UpgradesLoadedMessage> UPGRADES_LOADED = NetworkMessages.registerClientbound("upgrades_loaded", UpgradesLoadedMessage::new);

    private NetworkMessages() {
    }

    private static <C, T extends NetworkMessage<C>> MessageType<T> register(List<MessageType<? extends NetworkMessage<C>>> messages, String channel, class_2540.class_7461<T> reader) {
        if (!seenChannel.add(channel)) {
            throw new IllegalArgumentException("Duplicate channel " + channel);
        }
        MessageType<T> type = PlatformHelper.get().createMessageType(new class_2960("computercraft", channel), reader);
        messages.add(type);
        return type;
    }

    private static <T extends NetworkMessage<ServerNetworkContext>> MessageType<T> registerServerbound(String id, class_2540.class_7461<T> reader) {
        return NetworkMessages.register(serverMessages, id, reader);
    }

    private static <T extends NetworkMessage<ClientNetworkContext>> MessageType<T> registerClientbound(String id, class_2540.class_7461<T> reader) {
        return NetworkMessages.register(clientMessages, id, reader);
    }

    public static Collection<MessageType<? extends NetworkMessage<ServerNetworkContext>>> getServerbound() {
        return Collections.unmodifiableCollection(serverMessages);
    }

    public static Collection<MessageType<? extends NetworkMessage<ClientNetworkContext>>> getClientbound() {
        return Collections.unmodifiableCollection(clientMessages);
    }
}

