/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import java.util.UUID;
import net.minecraft.class_2540;

public class PocketComputerDataMessage
implements NetworkMessage<ClientNetworkContext> {
    private final UUID clientId;
    private final ComputerState state;
    private final int lightState;
    private final TerminalState terminal;

    public PocketComputerDataMessage(PocketServerComputer computer, boolean sendTerminal) {
        this.clientId = computer.getInstanceUUID();
        this.state = computer.getState();
        this.lightState = computer.getLight();
        this.terminal = sendTerminal ? computer.getTerminalState() : new TerminalState((NetworkedTerminal)null);
    }

    public PocketComputerDataMessage(class_2540 buf) {
        this.clientId = buf.method_10790();
        this.state = (ComputerState)buf.method_10818(ComputerState.class);
        this.lightState = buf.method_10816();
        this.terminal = new TerminalState(buf);
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10797(this.clientId);
        buf.method_10817((Enum)this.state);
        buf.method_10804(this.lightState);
        this.terminal.write(buf);
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handlePocketComputerData(this.clientId, this.state, this.lightState, this.terminal);
    }

    @Override
    public MessageType<PocketComputerDataMessage> type() {
        return NetworkMessages.POCKET_COMPUTER_DATA;
    }
}

