/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.RegistryHelper;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.impl.UpgradeManager;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public final class UpgradesLoadedMessage
implements NetworkMessage<ClientNetworkContext> {
    private final Map<String, UpgradeManager.UpgradeWrapper<ITurtleUpgrade>> turtleUpgrades;
    private final Map<String, UpgradeManager.UpgradeWrapper<IPocketUpgrade>> pocketUpgrades;

    public UpgradesLoadedMessage() {
        this.turtleUpgrades = TurtleUpgrades.instance().getUpgradeWrappers();
        this.pocketUpgrades = PocketUpgrades.instance().getUpgradeWrappers();
    }

    public UpgradesLoadedMessage(class_2540 buf) {
        this.turtleUpgrades = this.fromBytes(buf, ITurtleUpgrade.serialiserRegistryKey());
        this.pocketUpgrades = this.fromBytes(buf, IPocketUpgrade.serialiserRegistryKey());
    }

    private <T extends UpgradeBase> Map<String, UpgradeManager.UpgradeWrapper<T>> fromBytes(class_2540 buf, class_5321<class_2378<UpgradeSerialiser<? extends T>>> registryKey) {
        class_2378<UpgradeSerialiser<? extends T>> registry = RegistryHelper.getRegistry(registryKey);
        int size = buf.method_10816();
        HashMap<String, UpgradeManager.UpgradeWrapper<T>> upgrades = new HashMap<String, UpgradeManager.UpgradeWrapper<T>>(size);
        for (int i = 0; i < size; ++i) {
            String id = buf.method_19772();
            class_2960 serialiserId = buf.method_10810();
            UpgradeSerialiser serialiser = (UpgradeSerialiser)registry.method_10223(serialiserId);
            if (serialiser == null) {
                throw new IllegalStateException("Unknown serialiser " + serialiserId);
            }
            Object upgrade = serialiser.fromNetwork(new class_2960(id), buf);
            String modId = buf.method_19772();
            upgrades.put(id, new UpgradeManager.UpgradeWrapper(id, upgrade, serialiser, modId));
        }
        return upgrades;
    }

    @Override
    public void write(class_2540 buf) {
        this.toBytes(buf, ITurtleUpgrade.serialiserRegistryKey(), this.turtleUpgrades);
        this.toBytes(buf, IPocketUpgrade.serialiserRegistryKey(), this.pocketUpgrades);
    }

    private <T extends UpgradeBase> void toBytes(class_2540 buf, class_5321<class_2378<UpgradeSerialiser<? extends T>>> registryKey, Map<String, UpgradeManager.UpgradeWrapper<T>> upgrades) {
        class_2378<UpgradeSerialiser<? extends T>> registry = RegistryHelper.getRegistry(registryKey);
        buf.method_10804(upgrades.size());
        for (Map.Entry<String, UpgradeManager.UpgradeWrapper<T>> entry : upgrades.entrySet()) {
            UpgradeSerialiser<T> serialiser;
            buf.method_10814(entry.getKey());
            UpgradeSerialiser<T> unwrappedSerialiser = serialiser = entry.getValue().serialiser();
            buf.method_10812(RegistryHelper.getKeyOrThrow(registry, serialiser));
            unwrappedSerialiser.toNetwork(buf, entry.getValue().upgrade());
            buf.method_10814(entry.getValue().modId());
        }
    }

    @Override
    public void handle(ClientNetworkContext context) {
        TurtleUpgrades.instance().loadFromNetwork(this.turtleUpgrades);
        PocketUpgrades.instance().loadFromNetwork(this.pocketUpgrades);
    }

    @Override
    public MessageType<UpgradesLoadedMessage> type() {
        return NetworkMessages.UPGRADES_LOADED;
    }
}

