/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.util.Trie;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricConfigFile
implements ConfigFile {
    private static final Logger LOG = LoggerFactory.getLogger(FabricConfigFile.class);
    private final ConfigSpec spec;
    private final Trie<String, Entry> entries;
    private final ConfigFile.ConfigListener onChange;
    @Nullable
    private CommentedFileConfig config;

    public FabricConfigFile(ConfigSpec spec, Trie<String, Entry> entries, ConfigFile.ConfigListener onChange) {
        this.spec = spec;
        this.entries = entries;
        this.onChange = onChange;
    }

    public synchronized void load(Path ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException("Must pass at least one path");
        }
        this.closeConfig();
        Path path = Arrays.stream(paths).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseGet(() -> paths[paths.length - 1]);
        CommentedFileConfig config = this.config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().onFileNotFound(FileNotFoundAction.READ_NOTHING).writingMode(WritingMode.REPLACE).build();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            FileWatcher.defaultInstance().addWatch(config.getNioPath(), this::loadConfig);
        }
        catch (IOException e) {
            LOG.error("Failed to load config from {}.", (Object)path, (Object)e);
        }
        if (this.loadConfig()) {
            config.save();
        }
    }

    private Stream<ValueImpl<?>> values() {
        return this.entries.stream().filter(ValueImpl.class::isInstance);
    }

    public synchronized void unload() {
        this.closeConfig();
        this.values().forEach(ValueImpl::unload);
    }

    @GuardedBy(value="this")
    private void closeConfig() {
        if (this.config == null) {
            return;
        }
        this.config.close();
        FileWatcher.defaultInstance().removeWatch(this.config.getNioPath());
        this.config = null;
    }

    private synchronized boolean loadConfig() {
        CommentedFileConfig config = this.config;
        if (config == null) {
            return false;
        }
        LOG.info("Loading config from {}", (Object)config.getNioPath());
        config.load();
        boolean isNewFile = config.isEmpty();
        this.entries.stream().forEach(x -> config.setComment(x.path, x.comment));
        int corrected = isNewFile ? this.spec.correct((Config)config) : this.spec.correct((Config)config, (action, entryPath, oldValue, newValue) -> LOG.warn("Incorrect key {} was corrected from {} to {}", new Object[]{String.join((CharSequence)".", entryPath), oldValue, newValue}));
        this.values().forEach(x -> x.load((Config)config));
        this.onChange.onConfigChanged(config.getNioPath());
        return corrected > 0;
    }

    @Override
    public Stream<ConfigFile.Entry> entries() {
        return this.entries.stream().map(x -> (ConfigFile.Entry)((Object)x));
    }

    @Override
    @Nullable
    public ConfigFile.Entry getEntry(String path) {
        return (ConfigFile.Entry)((Object)this.entries.getValue(SPLITTER.split((CharSequence)path)));
    }

    private static final class ValueImpl<T>
    extends Entry
    implements ConfigFile.Value<T> {
        @Nullable
        private T value;
        private final T defaultValue;
        private final TriFunction<Config, String, T, T> get;

        private ValueImpl(String path, String comment, T defaultValue, TriFunction<Config, String, T, T> get) {
            super(path, comment);
            this.defaultValue = defaultValue;
            this.get = get;
        }

        void unload() {
            this.value = null;
        }

        void load(Config config) {
            this.value = this.get.apply((Object)config, (Object)this.path, this.defaultValue);
        }

        @Override
        public T get() {
            T value = this.value;
            if (value == null) {
                throw new IllegalStateException("Config value " + this.path + " is not available");
            }
            return value;
        }
    }

    private static class Entry {
        final String path;
        final String comment;

        Entry(String path, String comment) {
            this.path = path;
            this.comment = comment;
        }

        public final String translationKey() {
            return "gui.computercraft.config." + this.path;
        }

        public final String comment() {
            return this.comment;
        }
    }

    private static final class GroupImpl
    extends Entry
    implements ConfigFile.Group {
        private GroupImpl(String path, String comment) {
            super(path, comment);
        }
    }

    static class Builder
    extends ConfigFile.Builder {
        private final ConfigSpec spec = new ConfigSpec();
        private final Trie<String, Entry> entries = new Trie();
        @Nullable
        private String pendingComment;

        Builder() {
        }

        private String getFullPath(String path) {
            StringBuilder key = new StringBuilder();
            for (String group : this.groupStack) {
                key.append(group).append('.');
            }
            key.append(path);
            return key.toString();
        }

        @Override
        public ConfigFile.Builder comment(String comment) {
            if (this.pendingComment != null) {
                throw new IllegalStateException("Already have a comment");
            }
            this.pendingComment = comment;
            return this;
        }

        private String takeComment() {
            String comment = this.pendingComment;
            if (comment == null) {
                throw new IllegalStateException("No comment specified");
            }
            this.pendingComment = null;
            return comment;
        }

        private String takeComment(String suffix) {
            String comment = this.pendingComment == null ? "" : this.pendingComment + "\n";
            this.pendingComment = null;
            return comment + suffix;
        }

        @Override
        public void push(String name) {
            String path = this.getFullPath(name);
            Iterable splitPath = ConfigFile.SPLITTER.split((CharSequence)path);
            this.entries.setValue(splitPath, new GroupImpl(path, this.takeComment()));
            super.push(name);
        }

        @Override
        public ConfigFile.Builder worldRestart() {
            return this;
        }

        private <T> ConfigFile.Value<T> defineValue(String fullPath, String comment, T defaultValue, TriFunction<Config, String, T, T> getter) {
            ValueImpl<T> value = new ValueImpl<T>(fullPath, comment, defaultValue, getter);
            this.entries.setValue(ConfigFile.SPLITTER.split((CharSequence)fullPath), value);
            return value;
        }

        @Override
        public <T> ConfigFile.Value<T> define(String path, T defaultValue) {
            String fullPath = this.getFullPath(path);
            this.spec.define(fullPath, defaultValue);
            return this.defineValue(fullPath, this.takeComment(), defaultValue, UnmodifiableConfig::getOrElse);
        }

        @Override
        public ConfigFile.Value<Boolean> define(String path, boolean defaultValue) {
            String fullPath = this.getFullPath(path);
            this.spec.define(fullPath, (Object)defaultValue, x -> x instanceof Boolean);
            return this.defineValue(fullPath, this.takeComment(), defaultValue, UnmodifiableConfig::getOrElse);
        }

        @Override
        public ConfigFile.Value<Integer> defineInRange(String path, int defaultValue, int min, int max) {
            String fullPath = this.getFullPath(path);
            this.spec.defineInRange(fullPath, (Comparable)Integer.valueOf(defaultValue), (Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max));
            String suffix = max == Integer.MAX_VALUE ? "Range: > " + min : "Range: " + min + " ~ " + max;
            return this.defineValue(fullPath, this.takeComment(suffix), defaultValue, UnmodifiableConfig::getIntOrElse);
        }

        @Override
        public <T> ConfigFile.Value<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            String fullPath = this.getFullPath(path);
            this.spec.defineList(fullPath, defaultValue, elementValidator);
            return this.defineValue(fullPath, this.takeComment(), defaultValue, UnmodifiableConfig::getOrElse);
        }

        @Override
        public <V extends Enum<V>> ConfigFile.Value<V> defineEnum(String path, V defaultValue) {
            String fullPath = this.getFullPath(path);
            this.spec.define(fullPath, defaultValue, o -> o != null && o != NullObject.NULL_OBJECT && EnumGetMethod.NAME_IGNORECASE.validate(o, defaultValue.getDeclaringClass()));
            String suffix = "Allowed Values: " + Arrays.stream((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
            return this.defineValue(fullPath, this.takeComment(suffix), defaultValue, (c, p, d) -> c.getEnumOrElse(p, d, EnumGetMethod.NAME_IGNORECASE));
        }

        @Override
        public ConfigFile build(ConfigFile.ConfigListener onChange) {
            return new FabricConfigFile(this.spec, this.entries, onChange);
        }
    }
}

