/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public class MoreCodecs {
    private static final Codec<class_1792> ITEM_NOT_AIR = class_5699.method_48112((Codec)class_7923.field_41178.method_39673(), item -> item == class_1802.field_8162 ? DataResult.error(() -> "Crafting result must not be minecraft:air") : DataResult.success((Object)item));
    public static final Codec<class_2487> TAG = Codec.either((Codec)Codec.STRING, (Codec)class_2487.field_25128).flatXmap(either -> (DataResult)either.map(MoreCodecs::parseTag, DataResult::success), nbtCompound -> DataResult.success((Object)Either.left((Object)nbtCompound.method_10714())));
    public static final Codec<class_1799> ITEM_STACK_WITH_NBT = RecordCodecBuilder.create(instance -> instance.group((App)ITEM_NOT_AIR.fieldOf("item").forGetter(class_1799::method_7909), (App)class_5699.method_53049((Codec)class_5699.field_33442, (String)"count", (Object)1).forGetter(class_1799::method_7947), (App)class_5699.method_53048(TAG, (String)"nbt").forGetter(x -> Optional.ofNullable(x.method_7969()))).apply((Applicative)instance, MoreCodecs::createTag));
    public static final Codec<class_2371<class_1856>> SHAPELESS_INGREDIENTS = class_1856.field_46096.listOf().flatXmap(list -> {
        Object[] ingredients = (class_1856[])list.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
        if (ingredients.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        if (ingredients.length > 9) {
            return DataResult.error(() -> "Too many ingredients for shapeless recipe");
        }
        return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
    }, DataResult::success);

    private static DataResult<class_2487> parseTag(String contents) {
        try {
            return DataResult.success((Object)class_2522.method_10718((String)contents));
        }
        catch (CommandSyntaxException e) {
            return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
        }
    }

    private static class_1799 createTag(class_1935 item, int count, Optional<class_2487> tag) {
        class_1799 stack = new class_1799(item, count);
        tag.ifPresent(arg_0 -> ((class_1799)stack).method_7980(arg_0));
        return stack;
    }
}

