/*
 * Decompiled with CFR 0.152.
 */
package powercyphe.coffins.mixin;

import java.util.ArrayList;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import powercyphe.coffins.Mod;
import powercyphe.coffins.block.ModBlocks;
import powercyphe.coffins.block.entity.CoffinBlockEntity;
import powercyphe.coffins.modsupport.ModSupportManager;
import powercyphe.coffins.util.CoffinsUtil;
import powercyphe.coffins.util.IEntityDataSaver;
import powercyphe.coffins.util.RecoveryCompassData;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements IEntityDataSaver {
    @Shadow
    public abstract class_1661 method_31548();

    @Shadow
    protected abstract void method_7293();

    @Inject(method={"isBlockBreakingRestricted"}, at={@At(value="HEAD")}, cancellable=true)
    private void coffinBlockRestriction(class_1937 world, class_2338 pos, class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof CoffinBlockEntity) {
            CoffinBlockEntity blockEntity = (CoffinBlockEntity)class_25862;
            if (!world.method_8450().method_8355(Mod.ALLOW_COFFIN_ROBBING) && !CoffinsUtil.allowOpeningCoffin(world, blockEntity, player)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"block.coffins.coffin.disallowBreak"), true);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"dropInventory"}, at={@At(value="HEAD")})
    private void dropInventory(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (player.method_37908().field_9236) {
            return;
        }
        RecoveryCompassData.setNbt((IEntityDataSaver)player, null);
        RecoveryCompassData.setCount((IEntityDataSaver)player, 0);
        if (player.method_37908().method_8450().method_8355(class_1928.field_19389)) {
            return;
        }
        this.method_7293();
        ArrayList<class_1799> inventory = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_31548().method_5439(); ++i) {
            inventory.add(this.method_31548().method_5438(i));
        }
        inventory.addAll(ModSupportManager.getAllModSupportedDrops(player));
        int itemsAmount = 0;
        class_2371 items = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
        boolean hasRecoveryCompass = false;
        for (int i = 0; i < inventory.size(); ++i) {
            class_1799 stack = (class_1799)inventory.get(i);
            if (stack.method_7960() || stack.method_31574(class_1802.field_8162) || stack == class_1802.field_8162.method_7854() || itemsAmount >= items.size()) continue;
            boolean keepRecoveryCompass = false;
            if (player.method_37908().method_8450().method_8355(Mod.KEEP_RECOVERY_COMPASS) && class_1799.method_7984((class_1799)stack, (class_1799)class_1802.field_38747.method_7854()) && !hasRecoveryCompass) {
                keepRecoveryCompass = true;
            }
            this.method_31548().method_7378(stack);
            if (!keepRecoveryCompass) {
                ++itemsAmount;
                items.set(i, (Object)stack);
                continue;
            }
            RecoveryCompassData.setNbt((IEntityDataSaver)player, stack);
            RecoveryCompassData.setCount((IEntityDataSaver)player, stack.method_7947());
            hasRecoveryCompass = true;
        }
        class_1937 world = player.method_37908();
        @Nullable class_2338 coffinPos = CoffinsUtil.findCoffinLocation(world, player.method_24515(), player.method_6081());
        if (!items.isEmpty() && itemsAmount > 0) {
            if (world.method_8450().method_8355(Mod.DEATH_REQUIRES_COFFIN)) {
                boolean hasCoffin = false;
                int coffinSlot = 0;
                for (int i = 0; i < items.size(); ++i) {
                    if (!((class_1799)items.get(i)).method_31574(ModBlocks.COFFIN.method_8389())) continue;
                    hasCoffin = true;
                    coffinSlot = i;
                    break;
                }
                if (hasCoffin) {
                    class_1799 coffinStack = (class_1799)items.get(coffinSlot);
                    coffinStack.method_7934(1);
                    items.set(coffinSlot, (Object)coffinStack);
                } else {
                    coffinPos = null;
                }
            }
            if (coffinPos != null) {
                class_2680 blockState = ModBlocks.COFFIN.method_9564();
                if (player.method_37908().method_8450().method_8355(Mod.SHOW_DEATH_COORDS)) {
                    player.method_43496((class_2561)class_2561.method_43470((String)("Your Items were dropped at \u00a77[" + coffinPos.method_10263() + " " + coffinPos.method_10264() + " " + coffinPos.method_10260() + "]")));
                }
                world.method_8501(coffinPos, blockState);
                class_2586 blockEntity = world.method_8321(coffinPos);
                if (blockEntity instanceof CoffinBlockEntity) {
                    CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)blockEntity;
                    coffinBlockEntity.setItems((class_2371<class_1799>)items);
                    coffinBlockEntity.setOwner(player.method_5667().toString(), player.method_5477().getString());
                    coffinBlockEntity.setFragile(true);
                    world.method_8413(coffinPos, blockState, blockState, 3);
                }
            } else {
                if (world.method_8450().method_8355(Mod.SHOW_DEATH_COORDS)) {
                    player.method_43496((class_2561)class_2561.method_43470((String)("Your Items were dropped at \u00a77[" + player.method_24515().method_10263() + " " + player.method_24515().method_10264() + " " + player.method_24515().method_10260() + "]")));
                }
                class_1264.method_17349((class_1937)world, (class_2338)player.method_24515(), (class_2371)items);
            }
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14176(null, false, serverWorld.field_13957);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (player.method_24518(class_1802.field_38747) && player.method_43122().isPresent()) {
            class_2338 deathPos = ((class_4208)player.method_43122().get()).method_19446();
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7fYou died at \u00a73[" + deathPos.method_10263() + " " + deathPos.method_10264() + " " + deathPos.method_10260() + "]\u00a7f (" + Math.round(Math.sqrt(player.method_5649((double)deathPos.method_10263(), (double)deathPos.method_10264(), (double)deathPos.method_10260()))) + " Blocks away)")), true);
        }
    }
}

