/*
 * Decompiled with CFR 0.152.
 */
package powercyphe.coffins.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2769;
import net.minecraft.class_5321;
import net.minecraft.class_7134;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import powercyphe.coffins.Mod;
import powercyphe.coffins.block.custom.CoffinBlock;
import powercyphe.coffins.block.entity.CoffinBlockEntity;
import powercyphe.coffins.datagen.ModBlockTagProvider;

public class CoffinsUtil {
    public static boolean allowOpeningCoffin(class_1937 world, CoffinBlockEntity coffinBlockEntity, class_1657 player) {
        if (player.method_31549().field_7477) {
            return true;
        }
        boolean allow = true;
        String playerName = player.method_5477().getString();
        String playerUuid = player.method_5667().toString();
        if (!world.method_8450().method_8355(Mod.ALLOW_COFFIN_ROBBING)) {
            if (coffinBlockEntity.getOwnerName().isEmpty()) {
                if (!coffinBlockEntity.getOwner().equals(playerName) && !coffinBlockEntity.getOwner().isEmpty()) {
                    allow = false;
                }
            } else if (!coffinBlockEntity.getOwner().equals(playerUuid) && !coffinBlockEntity.getOwner().isEmpty()) {
                allow = false;
            }
        }
        if (((Boolean)coffinBlockEntity.method_10997().method_8320(coffinBlockEntity.method_11016()).method_11654((class_2769)CoffinBlock.LOCKED)).booleanValue() && !coffinBlockEntity.getOwner().equals(playerUuid)) {
            allow = false;
        }
        return allow;
    }

    @Nullable
    public static class_2338 findCoffinLocation(class_1937 world, class_2338 playerPos, @Nullable class_1282 recentDamageSource) {
        TreeMap<class_2338, Integer> distanceMap = new TreeMap<class_2338, Integer>();
        class_5321 dimension = world.method_44013();
        boolean shift = true;
        boolean skipCheck = false;
        boolean voidDeath = false;
        if (recentDamageSource != null && recentDamageSource.method_49708(class_8111.field_42347)) {
            voidDeath = true;
        }
        while (shift) {
            class_2338 shiftPos = playerPos.method_10087(1);
            if (dimension.equals(class_7134.field_37668) && playerPos.method_10264() < 40 || voidDeath) {
                if (playerPos.method_10264() < 1) {
                    playerPos = playerPos.method_33096(1);
                }
                distanceMap.put(playerPos, 1);
                class_2338 platformPos = playerPos.method_10069(-2, -1, -1);
                int platform = 0;
                while (platform < 9) {
                    if (world.method_8320(platformPos = platformPos.method_10069(1, 0, 0)) == class_2246.field_10124.method_9564()) {
                        world.method_8501(platformPos, class_2246.field_10540.method_9564());
                    }
                    if (++platform % 3 != 0) continue;
                    platformPos = platformPos.method_10069(-3, 0, 1);
                }
                skipCheck = true;
                shift = false;
            }
            if (world.method_8320(shiftPos).method_26164(ModBlockTagProvider.COFFIN_REPLACEABLE)) {
                playerPos = shiftPos;
                continue;
            }
            shift = false;
        }
        if (!skipCheck) {
            int xPlayer = playerPos.method_10263();
            int yPlayer = playerPos.method_10264();
            int zPlayer = playerPos.method_10260();
            int xMin = playerPos.method_10263() - 16;
            int xMax = playerPos.method_10263() + 16;
            int zMin = playerPos.method_10260() - 16;
            int zMax = playerPos.method_10260() + 16;
            int bottomY = world.method_31607();
            int topY = world.method_31600();
            for (int x = xMin; x < xMax; ++x) {
                for (int z = zMin; z < zMax; ++z) {
                    for (int y = bottomY; y < topY; ++y) {
                        class_2338 blockPos = new class_2338(x, y, z);
                        int distance = 0;
                        if (!world.method_8320(blockPos).method_26164(ModBlockTagProvider.COFFIN_REPLACEABLE) || !world.method_8621().method_35317((double)x, (double)z)) continue;
                        distance = distance + Math.abs(x - xPlayer) + Math.abs(y - yPlayer) + Math.abs(z - zPlayer);
                        distanceMap.put(blockPos, distance);
                    }
                }
            }
        }
        ArrayList entryList = new ArrayList(distanceMap.entrySet());
        entryList.sort(Map.Entry.comparingByValue());
        if (!entryList.isEmpty()) {
            return (class_2338)((Map.Entry)entryList.get(0)).getKey();
        }
        return null;
    }
}

