/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.mojang.logging.LogUtils;
import fuzs.forgeconfigapiport.api.config.v3.ModConfigEvents;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeModConfigEvents;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.neoforged.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConfigTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    public static final ConfigTracker INSTANCE = new ConfigTracker();
    private final ConcurrentHashMap<String, ModConfig> fileMap = new ConcurrentHashMap();
    private final EnumMap<ModConfig.Type, Set<ModConfig>> configSets = new EnumMap(ModConfig.Type.class);
    private final ConcurrentHashMap<String, Map<ModConfig.Type, Collection<ModConfig>>> configsByMod = new ConcurrentHashMap();

    private ConfigTracker() {
        this.configSets.put(ModConfig.Type.CLIENT, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.COMMON, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.SERVER, Collections.synchronizedSet(new LinkedHashSet()));
    }

    void trackConfig(ModConfig config) {
        if (this.fileMap.containsKey(config.getFileName())) {
            LOGGER.error(CONFIG, "Detected config file conflict {} between {} and {}", new Object[]{config.getFileName(), this.fileMap.get(config.getFileName()).getModId(), config.getModId()});
            throw new RuntimeException("Config conflict detected!");
        }
        this.fileMap.put(config.getFileName(), config);
        this.configSets.get((Object)config.getType()).add(config);
        this.configsByMod.computeIfAbsent(config.getModId(), k -> new EnumMap(ModConfig.Type.class)).computeIfAbsent(config.getType(), type -> new ArrayList()).add(config);
        LOGGER.debug(CONFIG, "Config file {} for {} tracking", (Object)config.getFileName(), (Object)config.getModId());
        if (config.getType() != ModConfig.Type.SERVER) {
            this.openConfig(config, FabricLoader.getInstance().getConfigDir());
        }
    }

    public void loadConfigs(ModConfig.Type type, Path configBasePath) {
        LOGGER.debug(CONFIG, "Loading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.openConfig((ModConfig)config, configBasePath));
    }

    public void unloadConfigs(ModConfig.Type type, Path configBasePath) {
        LOGGER.debug(CONFIG, "Unloading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.closeConfig((ModConfig)config, configBasePath));
    }

    private void openConfig(ModConfig config, Path configBasePath) {
        LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
        CommentedFileConfig configData = config.getHandler().reader(configBasePath).apply(config);
        config.setConfigData((CommentedConfig)configData);
        ((NeoForgeModConfigEvents.Loading)NeoForgeModConfigEvents.loading(config.getModId()).invoker()).onModConfigLoading(config);
        ((ModConfigEvents.Loading)ModConfigEvents.loading(config.getModId()).invoker()).onModConfigLoading(config);
        config.save();
    }

    private void closeConfig(ModConfig config, Path configBasePath) {
        if (config.getConfigData() != null) {
            LOGGER.trace(CONFIG, "Closing config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            config.getHandler().unload(configBasePath, config);
            ((NeoForgeModConfigEvents.Unloading)NeoForgeModConfigEvents.unloading(config.getModId()).invoker()).onModConfigUnloading(config);
            ((ModConfigEvents.Unloading)ModConfigEvents.unloading(config.getModId()).invoker()).onModConfigUnloading(config);
            config.save();
            config.setConfigData(null);
        }
    }

    public void loadDefaultServerConfigs() {
        this.configSets.get((Object)ModConfig.Type.SERVER).forEach(config -> {
            CommentedConfig commentedConfig = CommentedConfig.inMemory();
            config.getSpec().correct(commentedConfig);
            config.setConfigData(commentedConfig);
            ((NeoForgeModConfigEvents.Loading)NeoForgeModConfigEvents.loading(config.getModId()).invoker()).onModConfigLoading((ModConfig)config);
            ((ModConfigEvents.Loading)ModConfigEvents.loading(config.getModId()).invoker()).onModConfigLoading((ModConfig)config);
        });
    }

    @Nullable
    public String getConfigFileName(String modId, ModConfig.Type type) {
        List<String> fileNames = this.getConfigFileNames(modId, type);
        return fileNames.isEmpty() ? null : fileNames.get(0);
    }

    public List<String> getConfigFileNames(String modId, ModConfig.Type type) {
        return Optional.ofNullable(this.configsByMod.get(modId)).map(map -> (Collection)map.get((Object)type)).map(configs -> configs.stream().filter(config -> config.getConfigData() instanceof FileConfig).map(ModConfig::getFullPath).map(Object::toString).toList()).orElse(List.of());
    }

    public Map<ModConfig.Type, Set<ModConfig>> configSets() {
        return this.configSets;
    }

    public ConcurrentHashMap<String, ModConfig> fileMap() {
        return this.fileMap;
    }
}

