/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.core.v1.ObjectShareAccess;
import fuzs.puzzleslib.api.core.v1.ServiceProviderHelper;
import fuzs.puzzleslib.impl.core.ModContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public interface ModLoaderEnvironment {
    public static final ModLoaderEnvironment INSTANCE = ServiceProviderHelper.load(ModLoaderEnvironment.class);

    public ModLoader getModLoader();

    public boolean isClient();

    public boolean isServer();

    public Path getGameDirectory();

    public Path getModsDirectory();

    public Path getConfigDirectory();

    public String getCurrentMappingsNamespace();

    public boolean isDevelopmentEnvironment();

    public boolean isDataGeneration();

    public Map<String, ModContainer> getModList();

    default public boolean isModLoaded(String modId) {
        return this.getModList().containsKey(modId);
    }

    default public Optional<ModContainer> getModContainer(String modId) {
        return Optional.ofNullable(this.getModList().get(modId));
    }

    default public boolean isModPresentServerside(String modId) {
        return ModContext.isPresentServerside(modId);
    }

    public ObjectShareAccess getObjectShareAccess();
}

