/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore;

import fuzs.forgeconfigapiport.api.config.v3.ModConfigEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ModConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair clientSpec = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpec.getRight();
        CLIENT = (Client)clientSpec.getLeft();
        Pair commonSpec = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.EnumValue<SortButtonsPosition> sortButtonsPosition;
        public final ModConfigSpec.BooleanValue playButtonSound;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client Settings").push("client");
            this.sortButtonsPosition = builder.comment("Positions where sort buttons can display to help with conflicts with controls from other mods").defineEnum("sortButtonsPosition", (Enum)SortButtonsPosition.TITLE_LINE_RIGHT);
            this.playButtonSound = builder.comment("Whether click sound should play when custom buttons are clicked in gui").define("playButtonSound", true);
            builder.pop();
        }
    }

    public static class Common {
        public final EnabledItems enabledItems;

        public void initListeners() {
            ModConfigEvents.reloading((String)"sophisticatedcore").register(this::onConfigReload);
        }

        public void onConfigReload(ModConfig modConfig) {
            this.enabledItems.enabledMap.clear();
        }

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.enabledItems = new EnabledItems(builder);
        }

        public static class EnabledItems {
            private final ModConfigSpec.ConfigValue<List<String>> itemsEnableList;
            private final Map<class_2960, Boolean> enabledMap = new ConcurrentHashMap<class_2960, Boolean>();

            EnabledItems(ModConfigSpec.Builder builder) {
                this.itemsEnableList = builder.comment("Disable / enable any items here (disables their recipes)").define("enabledItems", new ArrayList());
            }

            public boolean isItemEnabled(class_1792 item) {
                return RegistryHelper.getRegistryName(class_7923.field_41178, item).map(this::isItemEnabled).orElse(false);
            }

            public boolean isItemEnabled(class_2960 itemRegistryName) {
                if (!COMMON_SPEC.isLoaded()) {
                    return true;
                }
                if (this.enabledMap.isEmpty()) {
                    this.loadEnabledMap();
                }
                return this.enabledMap.computeIfAbsent(itemRegistryName, irn -> {
                    this.addEnabledItemToConfig(itemRegistryName);
                    return true;
                });
            }

            private void addEnabledItemToConfig(class_2960 itemRegistryName) {
                List list = (List)this.itemsEnableList.get();
                list.add(String.valueOf(itemRegistryName) + "|true");
                this.itemsEnableList.set((Object)list);
            }

            private void loadEnabledMap() {
                for (String itemEnabled : (List)this.itemsEnableList.get()) {
                    String[] data = itemEnabled.split("\\|");
                    if (data.length == 2) {
                        this.enabledMap.put(new class_2960(data[0]), Boolean.valueOf(data[1]));
                        continue;
                    }
                    SophisticatedCore.LOGGER.error("Wrong data for enabledItems - expected registry name|true/false when {} was provided", (Object)itemEnabled);
                }
            }
        }
    }
}

