/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.compat.CompatInfo;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;

public class CompatRegistry {
    private static final Map<CompatInfo, List<Supplier<ICompat>>> compatFactories = new HashMap<CompatInfo, List<Supplier<ICompat>>>();
    private static final Map<CompatInfo, List<ICompat>> loadedCompats = new HashMap<CompatInfo, List<ICompat>>();

    public static void registerCompat(CompatInfo info, Supplier<ICompat> factory) {
        compatFactories.computeIfAbsent(info, k -> new ArrayList()).add(factory);
    }

    @Nullable
    public static VersionPredicate fromSpec(String spec) {
        try {
            return VersionPredicate.parse((String)spec);
        }
        catch (VersionParsingException e) {
            return null;
        }
    }

    public static void setupCompats() {
        for (List<ICompat> compats : loadedCompats.values()) {
            for (ICompat compat : compats) {
                compat.setup();
            }
        }
    }

    public static void initCompats() {
        compatFactories.forEach((compatInfo, factories) -> {
            if (compatInfo.isLoaded()) {
                factories.forEach(factory -> {
                    try {
                        loadedCompats.computeIfAbsent((CompatInfo)compatInfo, k -> new ArrayList()).add((ICompat)factory.get());
                    }
                    catch (Exception e) {
                        SophisticatedCore.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
                    }
                });
            }
        });
        loadedCompats.values().forEach(compats -> compats.forEach(ICompat::init));
    }
}

