/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.audioplayer;

import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.CustomSound;
import de.maxhenkel.audioplayer.PlayerType;
import de.maxhenkel.audioplayer.Plugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.plugins.impl.PositionImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.p3pp3rf1y.sophisticatedcore.compat.audioplayer.SCPlayerManager;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.SoundHandler;

public class AudioPlayerSoundHandler
implements SoundHandler {
    private static final int SOUND_STOP_CHECK_INTERVAL = 10;
    private static long lastPlaybackChecked = 0L;
    private static final Map<UUID, UUID> storageUUIDToChannelUUID = new HashMap<UUID, UUID>();

    @Nullable
    public static UUID play(class_3218 level, class_243 pos, PlayerType type, CustomSound sound) {
        float range = sound.getRange(type);
        VoicechatServerApi api = Plugin.voicechatServerApi;
        if (api == null) {
            return null;
        }
        UUID channelID = sound.isStaticSound() && (Boolean)AudioPlayer.SERVER_CONFIG.allowStaticAudio.get() != false ? SCPlayerManager.instance().playStatic(api, level, pos, sound.getSoundId(), null, range, type.getCategory(), (Integer)type.getMaxDuration().get()) : SCPlayerManager.instance().playLocational(api, level, pos, sound.getSoundId(), null, range, type.getCategory(), (Integer)type.getMaxDuration().get());
        return channelID;
    }

    @Override
    public boolean play(class_3218 level, class_2338 position, UUID storageUuid, class_1799 discItemStack) {
        class_243 pos;
        UUID channel;
        CustomSound customSound = CustomSound.of((class_1799)discItemStack);
        if (customSound != null && (channel = AudioPlayerSoundHandler.play(level, pos = class_243.method_24953((class_2382)position), PlayerType.MUSIC_DISC, customSound)) != null) {
            storageUUIDToChannelUUID.put(storageUuid, channel);
            return true;
        }
        return false;
    }

    @Override
    public boolean play(class_3218 level, class_243 position, UUID storageUuid, int entityId, class_1799 discItemStack) {
        UUID channel;
        CustomSound customSound = CustomSound.of((class_1799)discItemStack);
        if (customSound != null && (channel = AudioPlayerSoundHandler.play(level, position, PlayerType.MUSIC_DISC, customSound)) != null) {
            storageUUIDToChannelUUID.put(storageUuid, channel);
            return true;
        }
        return false;
    }

    @Override
    public void stop(class_3218 level, class_243 position, UUID storageUuid) {
        if (!storageUUIDToChannelUUID.containsKey(storageUuid)) {
            return;
        }
        UUID channelID = storageUUIDToChannelUUID.remove(storageUuid);
        SCPlayerManager.instance().stop(channelID);
    }

    @Override
    public void update(UUID storageUuid, class_243 position) {
        if (!storageUUIDToChannelUUID.containsKey(storageUuid)) {
            return;
        }
        UUID channelID = storageUUIDToChannelUUID.get(storageUuid);
        LocationalAudioChannel channel = SCPlayerManager.instance().getAudioChannel(channelID);
        if (channel != null) {
            channel.updateLocation((Position)new PositionImpl(position.field_1352, position.field_1351, position.field_1350));
        }
    }

    public static void tick(class_3218 level) {
        if (!storageUUIDToChannelUUID.isEmpty() && lastPlaybackChecked < level.method_8510() - 10L) {
            lastPlaybackChecked = level.method_8510();
            storageUUIDToChannelUUID.entrySet().removeIf(entry -> {
                if (!SCPlayerManager.instance().isPlaying((UUID)entry.getValue())) {
                    ServerStorageSoundHandler.onSoundStopped((class_1937)level, (UUID)entry.getKey());
                    return true;
                }
                return false;
            });
        }
    }
}

