/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;

public class SyncAdditionalSlotInfoPacket
implements FabricPacket {
    public static final PacketType<SyncAdditionalSlotInfoPacket> TYPE = PacketType.create((class_2960)new class_2960("sophisticatedcore", "sync_additional_slot_info"), SyncAdditionalSlotInfoPacket::new);
    private final Set<Integer> inaccessibleSlots;
    private final Map<Integer, Integer> slotLimitOverrides;
    private final Map<Integer, class_1792> slotFilterItems;

    public SyncAdditionalSlotInfoPacket(Set<Integer> inaccessibleSlots, Map<Integer, Integer> slotLimitOverrides, Map<Integer, class_1792> slotFilterItems) {
        this.inaccessibleSlots = inaccessibleSlots;
        this.slotLimitOverrides = slotLimitOverrides;
        this.slotFilterItems = slotFilterItems;
    }

    public SyncAdditionalSlotInfoPacket(class_2540 buffer) {
        this(Arrays.stream(buffer.method_10787()).boxed().collect(Collectors.toSet()), SyncAdditionalSlotInfoPacket.deserializeSlotLimitOverrides(buffer), SyncAdditionalSlotInfoPacket.deserializeSlotFilterItems(buffer));
    }

    private static Map<Integer, class_1792> deserializeSlotFilterItems(class_2540 buffer) {
        HashMap<Integer, class_1792> ret = new HashMap<Integer, class_1792>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.put(buffer.readInt(), class_1792.method_7875((int)buffer.readInt()));
        }
        return ret;
    }

    private void serializeSlotFilterItems(class_2540 buffer, Map<Integer, class_1792> slotFilterItems) {
        buffer.method_53002(slotFilterItems.size());
        slotFilterItems.forEach((slot, item) -> {
            buffer.method_53002(slot.intValue());
            buffer.method_53002(class_1792.method_7880((class_1792)item));
        });
    }

    private static Map<Integer, Integer> deserializeSlotLimitOverrides(class_2540 buffer) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.put(buffer.readInt(), buffer.readInt());
        }
        return ret;
    }

    private void serializeSlotLimitOverrides(class_2540 buffer, Map<Integer, Integer> slotLimitOverrides) {
        buffer.method_53002(slotLimitOverrides.size());
        slotLimitOverrides.forEach((slot, limit) -> {
            buffer.method_53002(slot.intValue());
            buffer.method_53002(limit.intValue());
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void handle(class_1657 player, PacketSender responseSender) {
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof IAdditionalSlotInfoMenu)) {
            return;
        }
        IAdditionalSlotInfoMenu menu = (IAdditionalSlotInfoMenu)class_17032;
        menu.updateAdditionalSlotInfo(this.inaccessibleSlots, this.slotLimitOverrides, this.slotFilterItems);
    }

    public void write(class_2540 buffer) {
        buffer.method_10806(this.inaccessibleSlots.stream().mapToInt(i -> i).toArray());
        this.serializeSlotLimitOverrides(buffer, this.slotLimitOverrides);
        this.serializeSlotFilterItems(buffer, this.slotFilterItems);
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}

