/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeAccessModifier;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class UpgradeHandler
extends ItemStackHandler {
    public static final String UPGRADE_INVENTORY_TAG = "upgradeInventory";
    private final IStorageWrapper storageWrapper;
    private final Runnable contentsSaveHandler;
    private final Runnable onInvalidateUpgradeCaches;
    private final class_2487 contentsNbt;
    @Nullable
    private Runnable refreshCallBack = null;
    private final Map<Integer, IUpgradeWrapper> slotWrappers = new LinkedHashMap<Integer, IUpgradeWrapper>();
    private final Map<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>> typeWrappers = new HashMap<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>>();
    private boolean justSavingNbtChange = false;
    private boolean wrappersInitialized = false;
    private boolean typeWrappersInitialized = false;
    @Nullable
    private IUpgradeWrapperAccessor wrapperAccessor = null;
    private boolean persistent = true;
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();

    public UpgradeHandler(int numberOfUpgradeSlots, IStorageWrapper storageWrapper, class_2487 contentsNbt, Runnable contentsSaveHandler, Runnable onInvalidateUpgradeCaches) {
        super(numberOfUpgradeSlots);
        this.contentsNbt = contentsNbt;
        this.storageWrapper = storageWrapper;
        this.contentsSaveHandler = contentsSaveHandler;
        this.onInvalidateUpgradeCaches = onInvalidateUpgradeCaches;
        this.deserializeNBT(contentsNbt.method_10562(UPGRADE_INVENTORY_TAG));
        if (SophisticatedCore.getCurrentServer() != null && SophisticatedCore.getCurrentServer().method_18854() && storageWrapper.getRenderInfo().getUpgradeItems().size() != this.getSlotCount()) {
            this.setRenderUpgradeItems();
        }
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }

    public boolean isItemValid(int slot, ItemVariant resource, int count) {
        return resource.getItem() instanceof IUpgradeItem;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.persistent) {
            this.saveInventory();
            this.contentsSaveHandler.run();
        }
        if (!this.justSavingNbtChange) {
            this.refreshUpgradeWrappers();
            this.setRenderUpgradeItems();
        }
    }

    public void setRenderUpgradeItems() {
        ArrayList<class_1799> upgradeItems = new ArrayList<class_1799>();
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)this, (upgradeSlot, upgrade) -> upgradeItems.add(upgrade.method_46651(1)));
        this.storageWrapper.getRenderInfo().setUpgradeItems(upgradeItems);
    }

    public void setSize(int size) {
        super.setSize(this.getSlotCount());
    }

    public void saveInventory() {
        this.contentsNbt.method_10566(UPGRADE_INVENTORY_TAG, (class_2520)this.serializeNBT());
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setRefreshCallBack(Runnable refreshCallBack) {
        this.refreshCallBack = refreshCallBack;
    }

    public void removeRefreshCallback() {
        this.refreshCallBack = null;
    }

    private void initializeWrappers() {
        if (this.wrappersInitialized) {
            return;
        }
        this.wrappersInitialized = true;
        this.slotWrappers.clear();
        this.typeWrappers.clear();
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.clearCache();
        }
        InventoryHelper.iterate((SlottedStorage<ItemVariant>)this, (slot, upgrade) -> {
            if (upgrade.method_7960() || !(upgrade.method_7909() instanceof IUpgradeItem)) {
                return;
            }
            UpgradeType type = ((IUpgradeItem)upgrade.method_7909()).getType();
            Object wrapper = type.create(this.storageWrapper, (class_1799)upgrade, upgradeStack -> {
                this.justSavingNbtChange = true;
                this.setStackInSlot((int)slot, (class_1799)upgradeStack);
                this.justSavingNbtChange = false;
            });
            this.setUpgradeDefaults((IUpgradeWrapper)wrapper);
            this.slotWrappers.put((Integer)slot, (IUpgradeWrapper)wrapper);
        });
        this.initRenderInfoCallbacks(false);
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return super.insertSlot(slot, resource, maxAmount, ctx);
    }

    private void onUpgradeAdded(int slot) {
        Map<Integer, IUpgradeWrapper> wrappers = this.getSlotWrappers();
        if (wrappers.containsKey(slot)) {
            wrappers.get(slot).onAdded();
        }
    }

    private void setUpgradeDefaults(IUpgradeWrapper wrapper) {
        this.getUpgradeDefaultsHandler(wrapper).accept(wrapper);
    }

    private <T extends IUpgradeWrapper> Consumer<T> getUpgradeDefaultsHandler(T wrapper) {
        return this.upgradeDefaultsHandlers.getOrDefault(wrapper.getClass(), w -> {});
    }

    public void setStackInSlot(int slot, @Nonnull class_1799 stack) {
        boolean itemsDiffer;
        class_1799 originalStack = this.getStackInSlot(slot);
        Map<Integer, IUpgradeWrapper> wrappers = this.getSlotWrappers();
        boolean bl = itemsDiffer = !class_1799.method_31577((class_1799)originalStack, (class_1799)stack);
        if (SophisticatedCore.getCurrentServer() != null && SophisticatedCore.getCurrentServer().method_18854() && itemsDiffer && wrappers.containsKey(slot)) {
            wrappers.get(slot).onBeforeRemoved();
        }
        super.setStackInSlot(slot, stack);
        if (SophisticatedCore.getCurrentServer() != null && SophisticatedCore.getCurrentServer().method_18854() && itemsDiffer) {
            this.onUpgradeAdded(slot);
        }
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return super.extractSlot(slot, resource, maxAmount, ctx);
    }

    private void initializeTypeWrappers() {
        if (this.typeWrappersInitialized) {
            return;
        }
        this.initializeWrappers();
        this.typeWrappersInitialized = true;
        this.typeWrappers.clear();
        this.slotWrappers.values().forEach(wrapper -> {
            class_1792 patt7444$temp = wrapper.getUpgradeStack().method_7909();
            if (patt7444$temp instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)patt7444$temp;
                UpgradeType type = upgradeItem.getType();
                if (wrapper.isEnabled()) {
                    this.addTypeWrapper(type, wrapper);
                }
            }
        });
        this.initRenderInfoCallbacks(false);
    }

    private <T extends IUpgradeWrapper> void addTypeWrapper(UpgradeType<?> type, T wrapper) {
        this.typeWrappers.computeIfAbsent(type, t -> new ArrayList()).add(wrapper);
    }

    public <T extends IUpgradeWrapper> List<T> getTypeWrappers(UpgradeType<T> type) {
        this.initializeTypeWrappers();
        return this.typeWrappers.getOrDefault(type, Collections.emptyList());
    }

    public <T extends IUpgradeWrapper> boolean hasUpgrade(UpgradeType<T> type) {
        return !this.getTypeWrappers(type).isEmpty();
    }

    public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplement(upgradeClass);
    }

    private IUpgradeWrapperAccessor getWrapperAccessor() {
        if (this.wrapperAccessor == null) {
            IUpgradeWrapperAccessor accessor = new Accessor(this);
            for (IUpgradeAccessModifier upgrade : this.getListOfWrappersThatImplement(IUpgradeAccessModifier.class)) {
                accessor = upgrade.wrapAccessor(accessor);
            }
            this.wrapperAccessor = accessor;
        }
        return this.wrapperAccessor;
    }

    public <T> List<T> getWrappersThatImplementFromMainStorage(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplementFromMainStorage(upgradeClass);
    }

    public <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<IUpgradeWrapper> ret = new ArrayList<IUpgradeWrapper>();
        for (IUpgradeWrapper wrapper : this.slotWrappers.values()) {
            if (!wrapper.isEnabled() || !uc.isInstance(wrapper)) continue;
            ret.add(wrapper);
        }
        return ret;
    }

    public Map<Integer, IUpgradeWrapper> getSlotWrappers() {
        this.initializeWrappers();
        return this.slotWrappers;
    }

    public void copyTo(UpgradeHandler otherHandler) {
        InventoryHelper.copyTo((SlottedStackStorage)this, (SlottedStackStorage)otherHandler);
    }

    public void refreshWrappersThatImplementAndTypeWrappers() {
        this.typeWrappersInitialized = false;
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.clearCache();
        }
        if (this.refreshCallBack != null) {
            this.refreshCallBack.run();
        }
    }

    public void refreshUpgradeWrappers() {
        this.wrappersInitialized = false;
        this.typeWrappersInitialized = false;
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.onBeforeDeconstruct();
            this.wrapperAccessor = null;
        }
        if (this.refreshCallBack != null) {
            this.refreshCallBack.run();
        }
        this.onInvalidateUpgradeCaches.run();
        this.initRenderInfoCallbacks(true);
    }

    private void initRenderInfoCallbacks(boolean forceUpdateRenderInfo) {
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        if (forceUpdateRenderInfo) {
            renderInfo.resetUpgradeInfo(true);
        }
        this.initTankRenderInfoCallbacks(forceUpdateRenderInfo, renderInfo);
        this.initBatteryRenderInfoCallbacks(forceUpdateRenderInfo, renderInfo);
    }

    private void initBatteryRenderInfoCallbacks(boolean forceUpdateRenderInfo, RenderInfo renderInfo) {
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedBatteryUpgrade) {
                IRenderedBatteryUpgrade batteryWrapper = (IRenderedBatteryUpgrade)((Object)wrapper);
                batteryWrapper.setBatteryRenderInfoUpdateCallback(renderInfo::setBatteryRenderInfo);
                if (forceUpdateRenderInfo) {
                    batteryWrapper.forceUpdateBatteryRenderInfo();
                }
            }
        });
    }

    private void initTankRenderInfoCallbacks(boolean forceUpdateRenderInfo, RenderInfo renderInfo) {
        AtomicBoolean singleTankRight = new AtomicBoolean(false);
        ArrayList tankRenderWrappers = new ArrayList();
        int minRightSlot = this.getSlotCount() / 2;
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedTankUpgrade) {
                IRenderedTankUpgrade tankUpgrade = (IRenderedTankUpgrade)((Object)wrapper);
                tankRenderWrappers.add(tankUpgrade);
                if (slot >= minRightSlot) {
                    singleTankRight.set(true);
                }
            }
        });
        TankPosition currentTankPos = tankRenderWrappers.size() == 1 && singleTankRight.get() ? TankPosition.RIGHT : TankPosition.LEFT;
        for (IRenderedTankUpgrade tankRenderWrapper : tankRenderWrappers) {
            TankPosition finalCurrentTankPos = currentTankPos;
            tankRenderWrapper.setTankRenderInfoUpdateCallback(tankRenderInfo -> renderInfo.setTankRenderInfo(finalCurrentTankPos, (IRenderedTankUpgrade.TankRenderInfo)tankRenderInfo));
            if (forceUpdateRenderInfo) {
                tankRenderWrapper.forceUpdateTankRenderInfo();
            }
            currentTankPos = TankPosition.RIGHT;
        }
    }

    public void increaseSize(int diff) {
        ArrayList previousSlots = new ArrayList(this.getSlots());
        super.setSize(previousSlots.size() + diff);
        for (int i = 0; i < previousSlots.size() && i < this.getSlotCount(); ++i) {
            class_2487 tag = ((ItemStackHandlerSlot)previousSlots.get(i)).save();
            if (tag == null) continue;
            this.getSlot(i).load(tag);
        }
        this.saveInventory();
        this.setRenderUpgradeItems();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected ItemStackHandlerSlot makeSlot(int index, class_1799 stack) {
        return new UpgradeHandlerSlot(index, this, stack);
    }

    private static class Accessor
    implements IUpgradeWrapperAccessor {
        private final Map<Class<?>, List<?>> interfaceWrappers = new HashMap();
        private final UpgradeHandler upgradeHandler;

        public Accessor(UpgradeHandler upgradeHandler) {
            this.upgradeHandler = upgradeHandler;
        }

        @Override
        public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }

        @Override
        public <T> List<T> getWrappersThatImplementFromMainStorage(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }

        @Override
        public void clearCache() {
            this.interfaceWrappers.clear();
        }
    }

    private static class UpgradeHandlerSlot
    extends ItemStackHandlerSlot {
        private final UpgradeHandler handler;

        public UpgradeHandlerSlot(int index, UpgradeHandler handler, class_1799 initial) {
            super(index, (ItemStackHandler)handler, initial);
            this.handler = handler;
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert(insertedVariant, maxAmount, transaction);
            TransactionCallback.onSuccess((TransactionContext)transaction, () -> {
                this.onFinalCommit();
                if (SophisticatedCore.getCurrentServer() != null && SophisticatedCore.getCurrentServer().method_18854() && inserted > 0L && maxAmount > 0L) {
                    this.handler.onUpgradeAdded(this.getIndex());
                }
            });
            return inserted;
        }

        public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
            class_1799 slotStack = this.getStack();
            long extracted = super.extract(variant, maxAmount, transaction);
            TransactionCallback.onSuccess((TransactionContext)transaction, () -> {
                Map<Integer, IUpgradeWrapper> wrappers;
                this.onFinalCommit();
                if (SophisticatedCore.getCurrentServer() != null && SophisticatedCore.getCurrentServer().method_18854() && this.handler.persistent && !slotStack.method_7960() && maxAmount == 1L && (wrappers = this.handler.getSlotWrappers()).containsKey(this.getIndex())) {
                    wrappers.get(this.getIndex()).onBeforeRemoved();
                }
            });
            return extracted;
        }
    }
}

