/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class JukeboxUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);

    public JukeboxUpgradeItem(IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return List.of();
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, JukeboxUpgradeItem>
    implements ITickableUpgrade {
        private static final int KEEP_ALIVE_SEND_INTERVAL = 5;
        private final ItemStackHandler discInventory;
        private long lastKeepAliveSendTime = 0L;
        private boolean isPlaying;

        protected Wrapper(IStorageWrapper storageWrapper, final class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
            this.discInventory = new ItemStackHandler(1){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    upgrade.method_7959("discInventory", (class_2520)this.serializeNBT());
                    this.save();
                }

                public boolean isItemValid(int slot, ItemVariant resource, int count) {
                    return resource.getItem() instanceof class_1813;
                }
            };
            NBTHelper.getCompound(upgrade, "discInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.discInventory).deserializeNBT(arg_0));
            this.isPlaying = NBTHelper.getBoolean(upgrade, "isPlaying").orElse(false);
        }

        public void setDisc(class_1799 disc) {
            this.discInventory.setStackInSlot(0, disc);
        }

        public class_1799 getDisc() {
            return this.discInventory.getStackInSlot(0);
        }

        public void play(class_1937 level, class_2338 pos) {
            this.play(level, (class_3218 serverLevel, UUID storageUuid) -> ServerStorageSoundHandler.startPlayingDisc(serverLevel, pos, storageUuid, this.getDisc(), () -> this.setIsPlaying(false)));
        }

        public void play(class_1309 entity) {
            this.play(entity.method_37908(), (class_3218 world, UUID storageUuid) -> ServerStorageSoundHandler.startPlayingDisc(world, entity.method_19538(), storageUuid, entity.method_5628(), this.getDisc(), () -> this.setIsPlaying(false)));
        }

        private void play(class_1937 level, BiConsumer<class_3218, UUID> play) {
            if (!(level instanceof class_3218) || this.getDisc().method_7960()) {
                return;
            }
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> play.accept((class_3218)level, (UUID)storageUuid));
            this.setIsPlaying(true);
        }

        private void setIsPlaying(boolean playing) {
            this.isPlaying = playing;
            NBTHelper.setBoolean(this.upgrade, "isPlaying", playing);
            if (this.isPlaying) {
                this.storageWrapper.getRenderInfo().setUpgradeRenderData(JukeboxUpgradeRenderData.TYPE, new JukeboxUpgradeRenderData(true));
            } else {
                this.removeRenderData();
            }
            this.save();
        }

        private void removeRenderData() {
            this.storageWrapper.getRenderInfo().removeUpgradeRenderData(JukeboxUpgradeRenderData.TYPE);
        }

        public void stop(class_1309 entity) {
            class_1937 class_19372 = entity.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = (class_3218)class_19372;
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.stopPlayingDisc(serverLevel, entity.method_19538(), storageUuid));
            this.setIsPlaying(false);
        }

        public SlottedStackStorage getDiscInventory() {
            return this.discInventory;
        }

        @Override
        public void tick(@Nullable class_1309 entity, class_1937 level, class_2338 pos) {
            if (this.isPlaying && this.lastKeepAliveSendTime < level.method_8510() - 5L) {
                this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.updateKeepAlive(storageUuid, level, entity != null ? entity.method_19538() : class_243.method_24953((class_2382)pos), () -> this.setIsPlaying(false)));
                this.lastKeepAliveSendTime = level.method_8510();
            }
        }

        public boolean isPlaying() {
            return this.isPlaying;
        }

        @Override
        public void onBeforeRemoved() {
            this.removeRenderData();
        }
    }
}

