/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stack;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;

public class StackUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);
    public static final UpgradeGroup UPGRADE_GROUP = new UpgradeGroup("stack_upgrades", TranslationHelper.INSTANCE.translUpgradeGroup("stack_upgrades"));
    private final double stackSizeMultiplier;

    public StackUpgradeItem(double stackSizeMultiplier, IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
        this.stackSizeMultiplier = stackSizeMultiplier;
    }

    public static int getInventorySlotLimit(IStorageWrapper storageWrapper) {
        double multiplier = storageWrapper.getBaseStackSizeMultiplier();
        for (Wrapper stackWrapper : storageWrapper.getUpgradeHandler().getTypeWrappers(TYPE)) {
            if (2.147483647E9 / stackWrapper.getStackSizeMultiplier() < multiplier) {
                return Integer.MAX_VALUE;
            }
            multiplier *= stackWrapper.getStackSizeMultiplier();
        }
        return 3.3554431984375E7 < multiplier ? Integer.MAX_VALUE : (int)(multiplier * 64.0);
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return List.of();
    }

    double getStackSizeMultiplier() {
        return this.stackSizeMultiplier;
    }

    @Override
    public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide) {
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        double currentInventoryMultiplier = (double)StackUpgradeItem.getInventorySlotLimit(storageWrapper) / 64.0;
        double multiplierWhenRemoved = currentInventoryMultiplier / this.stackSizeMultiplier;
        return this.isMultiplierHighEnough(storageWrapper, multiplierWhenRemoved);
    }

    @Override
    public UpgradeSlotChangeResult canSwapUpgradeFor(class_1799 upgradeStackToPut, int upgradeSlot, IStorageWrapper storageWrapper, boolean isClientSide) {
        UpgradeSlotChangeResult result = super.canSwapUpgradeFor(upgradeStackToPut, upgradeSlot, storageWrapper, isClientSide);
        if (!result.isSuccessful()) {
            return result;
        }
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        class_1792 class_17922 = upgradeStackToPut.method_7909();
        if (!(class_17922 instanceof StackUpgradeItem)) {
            return this.canRemoveUpgradeFrom(storageWrapper, isClientSide);
        }
        StackUpgradeItem otherStackUpgradeItem = (StackUpgradeItem)class_17922;
        if (otherStackUpgradeItem.stackSizeMultiplier >= this.stackSizeMultiplier) {
            return new UpgradeSlotChangeResult.Success();
        }
        int currentInventoryMultiplier = StackUpgradeItem.getInventorySlotLimit(storageWrapper) / 64;
        double multiplierWhenRemoved = (double)currentInventoryMultiplier / this.stackSizeMultiplier;
        return this.isMultiplierHighEnough(storageWrapper, multiplierWhenRemoved * otherStackUpgradeItem.stackSizeMultiplier);
    }

    private UpgradeSlotChangeResult isMultiplierHighEnough(IStorageWrapper storageWrapper, double multiplier) {
        HashSet<Integer> slotsOverMultiplier = new HashSet<Integer>();
        for (int slot2 = 0; slot2 < storageWrapper.getInventoryHandler().getSlotCount(); ++slot2) {
            class_1799 stack = storageWrapper.getInventoryHandler().getSlotStack(slot2);
            double stackMultiplierNeeded = (double)stack.method_7947() / (double)stack.method_7914();
            if (!(stackMultiplierNeeded > multiplier)) continue;
            slotsOverMultiplier.add(slot2);
        }
        HashSet<Integer> errorInventoryParts = new HashSet<Integer>();
        storageWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            IStackableContentsUpgrade stackableContentsUpgrade;
            if (wrapper instanceof IStackableContentsUpgrade && (double)(stackableContentsUpgrade = (IStackableContentsUpgrade)((Object)wrapper)).getMinimumMultiplierRequired() > multiplier) {
                errorInventoryParts.add((Integer)slot);
            }
        });
        if (!slotsOverMultiplier.isEmpty() || !errorInventoryParts.isEmpty()) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("remove.stack_low_multiplier", multiplier), Collections.emptySet(), slotsOverMultiplier, errorInventoryParts);
        }
        return new UpgradeSlotChangeResult.Success();
    }

    @Override
    public UpgradeGroup getUpgradeGroup() {
        return UPGRADE_GROUP;
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, StackUpgradeItem> {
        protected Wrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
        }

        public double getStackSizeMultiplier() {
            return ((StackUpgradeItem)this.upgradeItem).getStackSizeMultiplier();
        }

        @Override
        public boolean hideSettingsTab() {
            return true;
        }

        @Override
        public boolean canBeDisabled() {
            return false;
        }
    }
}

