/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeWrapper;

public class TankUpgradeItem
extends UpgradeItemBase<TankUpgradeWrapper> {
    public static final UpgradeType<TankUpgradeWrapper> TYPE = new UpgradeType<TankUpgradeWrapper>(TankUpgradeWrapper::new);
    public static final List<IUpgradeItem.UpgradeConflictDefinition> UPGRADE_CONFLICT_DEFINITIONS = List.of(new IUpgradeItem.UpgradeConflictDefinition(TankUpgradeItem.class::isInstance, 1, TranslationHelper.INSTANCE.translError("add.two_tank_upgrades_present", new Object[0])));
    private final TankUpgradeConfig tankUpgradeConfig;

    public TankUpgradeItem(TankUpgradeConfig tankUpgradeConfig, IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
        this.tankUpgradeConfig = tankUpgradeConfig;
    }

    public long getBaseCapacity(IStorageWrapper storageWrapper) {
        return (long)((Integer)this.tankUpgradeConfig.capacityPerSlotRow.get()).intValue() * (long)storageWrapper.getNumberOfSlotRows() * 81L;
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.tankUpgradeConfig.stackMultiplierRatio.get() * (storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1.0));
    }

    public long getTankCapacity(IStorageWrapper storageWrapper) {
        long baseCapacity;
        long maxCapacity = 173946175407L;
        int stackMultiplier = this.getAdjustedStackMultiplier(storageWrapper);
        return maxCapacity / (long)stackMultiplier < (baseCapacity = this.getBaseCapacity(storageWrapper)) ? maxCapacity : baseCapacity * (long)stackMultiplier;
    }

    public TankUpgradeConfig getTankUpgradeConfig() {
        return this.tankUpgradeConfig;
    }

    @Override
    public UpgradeType<TankUpgradeWrapper> getType() {
        return TYPE;
    }

    @Override
    public UpgradeSlotChangeResult checkExtraInsertConditions(class_1799 upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide) {
        int multiplierRequired = (int)Math.ceil((float)TankUpgradeWrapper.getContents(upgradeStack).getAmount() / (float)this.getTankCapacity(storageWrapper));
        if (multiplierRequired > 1) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.tank_capacity_high", multiplierRequired), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return UPGRADE_CONFLICT_DEFINITIONS;
    }

    @Override
    public int getInventoryColumnsTaken() {
        return 2;
    }
}

