/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class TankUpgradeWrapper
extends UpgradeWrapperBase<TankUpgradeWrapper, TankUpgradeItem>
implements IRenderedTankUpgrade,
ITickableUpgrade,
IStackableContentsUpgrade,
SingleSlotStorage<FluidVariant> {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private static final String CONTENTS_TAG = "contents";
    private Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback;
    private final ItemStackHandler inventory;
    private FluidStack contents;
    private long cooldownTime = 0L;
    private boolean allowEmptyInputResource = false;

    protected TankUpgradeWrapper(IStorageWrapper storageWrapper, final class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inventory = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                upgrade.method_7959("inventory", (class_2520)this.serializeNBT());
                TankUpgradeWrapper.this.save();
            }

            public boolean isItemValid(int slot, ItemVariant resource, int count) {
                return switch (slot) {
                    case 0 -> this.isValidInputItem(resource.toStack(count));
                    case 1 -> this.isValidOutputItem(resource.toStack(count));
                    default -> false;
                };
            }

            private boolean isValidInputItem(class_1799 stack) {
                return TankUpgradeWrapper.this.isValidFluidItem(stack, false);
            }

            private boolean isValidOutputItem(class_1799 stack) {
                return TankUpgradeWrapper.this.isValidFluidItem(stack, true);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        NBTHelper.getCompound(upgrade, "inventory").ifPresent(arg_0 -> ((ItemStackHandler)this.inventory).deserializeNBT(arg_0));
        this.contents = TankUpgradeWrapper.getContents(upgrade);
    }

    public static FluidStack getContents(class_1799 upgrade) {
        return NBTHelper.getCompound(upgrade, CONTENTS_TAG).map(FluidStack::loadFluidStackFromNBT).orElse(FluidStack.EMPTY);
    }

    private boolean isValidFluidItem(class_1799 stack, boolean isOutput) {
        return CapabilityHelper.getFromFluidHandler(stack, fluidHandler -> this.isValidFluidHandler((Storage<FluidVariant>)fluidHandler, isOutput), false);
    }

    private boolean isValidFluidHandler(Storage<FluidVariant> storage, boolean isOutput) {
        boolean tankEmpty = this.contents.isEmpty();
        for (StorageView view : storage) {
            if ((!isOutput || !view.isResourceBlank() && (tankEmpty || !((FluidVariant)view.getResource()).isOf((Object)this.contents.getFluid()))) && (isOutput || view.isResourceBlank() || !tankEmpty && !((FluidVariant)view.getResource()).isOf((Object)this.contents.getFluid())) && (!view.isResourceBlank() || !this.allowEmptyInputResource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTankRenderInfoUpdateCallback(Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback) {
        this.updateTankRenderInfoCallback = updateTankRenderInfoCallback;
    }

    @Override
    public void forceUpdateTankRenderInfo() {
        IRenderedTankUpgrade.TankRenderInfo renderInfo = new IRenderedTankUpgrade.TankRenderInfo();
        renderInfo.setFluid(this.contents);
        renderInfo.setFillRatio((float)Math.round((float)this.contents.getAmount() / (float)this.getTankCapacity() * 10.0f) / 10.0f);
        this.updateTankRenderInfoCallback.accept(renderInfo);
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public long getTankCapacity() {
        return ((TankUpgradeItem)this.upgradeItem).getTankCapacity(this.storageWrapper);
    }

    public SlottedStackStorage getInventory() {
        return this.inventory;
    }

    private long getMaxInOut() {
        return Math.max(81000L, (long)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows() * ((TankUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper)) * 81L);
    }

    public long fill(FluidVariant resource, long maxFill, TransactionContext ctx, boolean ignoreInOutLimit) {
        long capacity = this.getTankCapacity();
        if (this.contents.getAmount() >= capacity || !this.contents.isEmpty() && !resource.isOf((Object)this.contents.getFluid())) {
            return 0L;
        }
        long toFill = Math.min(capacity - this.contents.getAmount(), maxFill);
        if (!ignoreInOutLimit) {
            toFill = Math.min(this.getMaxInOut(), toFill);
        }
        long finalToFill = toFill;
        TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
            if (this.contents.isEmpty()) {
                this.contents = new FluidStack(resource, finalToFill);
            } else {
                this.contents.setAmount(this.contents.getAmount() + finalToFill);
            }
            this.serializeContents();
        });
        return toFill;
    }

    private void serializeContents() {
        this.upgrade.method_7959(CONTENTS_TAG, (class_2520)this.contents.writeToNBT(new class_2487()));
        this.save();
        this.forceUpdateTankRenderInfo();
    }

    public long drain(long maxDrain, TransactionContext ctx, boolean ignoreInOutLimit) {
        if (this.contents.isEmpty()) {
            return 0L;
        }
        long toDrain = Math.min(maxDrain, this.contents.getAmount());
        if (!ignoreInOutLimit) {
            toDrain = Math.min(this.getMaxInOut(), toDrain);
        }
        long finalToDrain = toDrain;
        TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
            if (finalToDrain == this.contents.getAmount()) {
                this.contents = FluidStack.EMPTY;
            } else {
                this.contents.setAmount(this.contents.getAmount() - finalToDrain);
            }
            this.serializeContents();
        });
        return toDrain;
    }

    @Override
    public void tick(@Nullable class_1309 entity, class_1937 level, class_2338 pos) {
        if (level.method_8510() < this.cooldownTime) {
            return;
        }
        AtomicBoolean didSomething = new AtomicBoolean(false);
        CapabilityHelper.runOnFluidHandler(this.inventory.getStackInSlot(0), (cic, fluidHandler) -> didSomething.set(this.drainHandler((ContainerItemContext)cic, (Storage<FluidVariant>)fluidHandler, stack -> this.inventory.setStackInSlot(0, stack))));
        CapabilityHelper.runOnFluidHandler(this.inventory.getStackInSlot(1), (cic, fluidHandler) -> didSomething.set(this.fillHandler((ContainerItemContext)cic, (Storage<FluidVariant>)fluidHandler, stack -> this.inventory.setStackInSlot(1, stack))));
        if (didSomething.get()) {
            this.cooldownTime = level.method_8510() + (long)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().autoFillDrainContainerCooldown.get()).intValue();
        }
    }

    public boolean fillHandler(ContainerItemContext cic, Storage<FluidVariant> fluidHandler, Consumer<class_1799> updateContainerStack) {
        if (!this.contents.isEmpty() && this.isValidFluidHandler(fluidHandler, true)) {
            long filled = StorageUtil.simulateInsert(fluidHandler, (Object)this.contents.getType(), (long)Math.min(81000L, this.contents.getAmount()), null);
            if (filled <= 0L) {
                return false;
            }
            try (Transaction ctx = Transaction.openOuter();){
                long drained = this.drain(filled, (TransactionContext)ctx, false);
                fluidHandler.insert((Object)this.contents.getType(), drained, (TransactionContext)ctx);
                ctx.commit();
            }
            updateContainerStack.accept(cic.getItemVariant().toStack((int)cic.getAmount()));
            return true;
        }
        return false;
    }

    public boolean drainHandler(ContainerItemContext cic, Storage<FluidVariant> fluidHandler, Consumer<class_1799> updateContainerStack) {
        if (this.isValidFluidHandler(fluidHandler, false)) {
            long extracted;
            this.allowEmptyInputResource = true;
            FluidVariant resource = this.contents.isEmpty() ? TransferUtil.getFirstFluid(fluidHandler).getType() : this.contents.getType();
            long l = extracted = this.contents.isEmpty() ? StorageUtil.simulateExtract(fluidHandler, (Object)resource, (long)81000L, null) : StorageUtil.simulateExtract(fluidHandler, (Object)resource, (long)Math.min(81000L, this.getTankCapacity() - this.contents.getAmount()), null);
            if (extracted <= 0L) {
                this.allowEmptyInputResource = false;
                return false;
            }
            try (Transaction ctx = Transaction.openOuter();){
                long filled = this.fill(resource, extracted, (TransactionContext)ctx, false);
                fluidHandler.extract((Object)resource, filled, (TransactionContext)ctx);
                this.allowEmptyInputResource = false;
                ctx.commit();
            }
            updateContainerStack.accept(cic.getItemVariant().toStack((int)cic.getAmount()));
            return true;
        }
        return false;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.contents.getAmount() / (float)((TankUpgradeItem)this.upgradeItem).getBaseCapacity(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.fill(resource, maxAmount, transaction, false);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.contents == null || !resource.isOf((Object)this.contents.getFluid())) {
            return 0L;
        }
        return this.drain(maxAmount, transaction, false);
    }

    public boolean isResourceBlank() {
        return this.contents == null || this.contents.isEmpty();
    }

    public FluidVariant getResource() {
        return this.contents.getType();
    }

    public long getAmount() {
        return this.contents.getAmount();
    }

    public long getCapacity() {
        return this.getMaxInOut();
    }
}

