/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.List;
import net.minecraft.class_1767;

public class ColorHelper {
    private ColorHelper() {
    }

    public static int getColor(float[] colorComponents) {
        int red = (int)(colorComponents[0] * 255.0f);
        int green = (int)(colorComponents[1] * 255.0f);
        int blue = (int)(colorComponents[2] * 255.0f);
        return red << 16 | green << 8 | blue;
    }

    public static int calculateColor(int baseColor, int defaultColor, List<class_1767> dyes) {
        if (dyes.isEmpty()) {
            return baseColor;
        }
        int[] rgb = new int[3];
        int sumMaxComponent = 0;
        int numberOfColors = 0;
        if (baseColor != defaultColor) {
            float baseRed = baseColor >> 16 & 0xFF;
            float baseGreen = baseColor >> 8 & 0xFF;
            float baseBlue = baseColor & 0xFF;
            sumMaxComponent = (int)((float)sumMaxComponent + Math.max(baseRed, Math.max(baseGreen, baseBlue)));
            rgb[0] = (int)((float)rgb[0] + baseRed);
            rgb[1] = (int)((float)rgb[1] + baseGreen);
            rgb[2] = (int)((float)rgb[2] + baseBlue);
            ++numberOfColors;
        }
        for (class_1767 dye : dyes) {
            float[] dyeRgb = dye.method_7787();
            int dyeRed = (int)(dyeRgb[0] * 255.0f);
            int dyeGreen = (int)(dyeRgb[1] * 255.0f);
            int dyeBlue = (int)(dyeRgb[2] * 255.0f);
            sumMaxComponent += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue));
            rgb[0] = rgb[0] + dyeRed;
            rgb[1] = rgb[1] + dyeGreen;
            rgb[2] = rgb[2] + dyeBlue;
            ++numberOfColors;
        }
        int avgRed = rgb[0] / numberOfColors;
        int avgGreen = rgb[1] / numberOfColors;
        int avgBlue = rgb[2] / numberOfColors;
        float avgMaxComponent = (float)sumMaxComponent / (float)numberOfColors;
        float maxAvgComponent = Math.max(avgRed, Math.max(avgGreen, avgBlue));
        avgRed = (int)((float)avgRed * avgMaxComponent / maxAvgComponent);
        avgGreen = (int)((float)avgGreen * avgMaxComponent / maxAvgComponent);
        avgBlue = (int)((float)avgBlue * avgMaxComponent / maxAvgComponent);
        int finalColor = (avgRed << 8) + avgGreen;
        finalColor = (finalColor << 8) + avgBlue;
        return finalColor;
    }
}

