/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigObjectEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.CustomButton;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionItem;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionsListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.range.DecimalOptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.range.OptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.range.WholeOptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.types.BooleanOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.DropdownWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.MultilineStringOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.NumberOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ObjectOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.RangeOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ResetableWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_339;

public final class Options {
    public static void populateOptions(OptionsListWidget widget, Map<String, ResourcefulConfigEntry> entries, List<ResourcefulConfigButton> buttons) {
        ListMultimap buttonsBefore = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        ListMultimap buttonsAfter = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        buttons.forEach(arg_0 -> Options.lambda$populateOptions$0((Multimap)buttonsBefore, (Multimap)buttonsAfter, arg_0));
        buttonsBefore.get((Object)"").forEach(button -> Options.addButton(widget, button));
        for (Map.Entry<String, ResourcefulConfigEntry> value : entries.entrySet()) {
            EntryData options = value.getValue().options();
            if (options.isHidden()) continue;
            if (options.separator() != null) {
                widget.add(new OptionItem((class_2561)class_2561.method_43470((String)options.separator()), class_2561.method_30163((String)options.separatorDescription()), List.of()));
            }
            buttonsBefore.get((Object)value.getKey()).forEach(button -> Options.addButton(widget, button));
            ResourcefulConfigEntry resourcefulConfigEntry = value.getValue();
            if (resourcefulConfigEntry instanceof ResourcefulConfigValueEntry) {
                ResourcefulConfigValueEntry entry = (ResourcefulConfigValueEntry)resourcefulConfigEntry;
                Options.populateValueEntry(widget, entry);
            } else {
                resourcefulConfigEntry = value.getValue();
                if (resourcefulConfigEntry instanceof ResourcefulConfigObjectEntry) {
                    ResourcefulConfigObjectEntry entry = (ResourcefulConfigObjectEntry)resourcefulConfigEntry;
                    widget.add(new OptionItem(entry, List.of(new ObjectOptionWidget(entry))));
                }
            }
            buttonsAfter.get((Object)value.getKey()).forEach(button -> Options.addButton(widget, button));
        }
        buttonsAfter.get((Object)"").forEach(button -> Options.addButton(widget, button));
    }

    private static void addButton(OptionsListWidget list, ResourcefulConfigButton button) {
        list.add(new OptionItem((class_2561)class_2561.method_43471((String)button.title()), (class_2561)class_2561.method_43471((String)button.description()), List.of(new CustomButton(96, 12, (class_2561)class_2561.method_43471((String)button.text()), button::invoke))));
    }

    private static void populateValueEntry(OptionsListWidget list, ResourcefulConfigValueEntry entry) {
        EntryData options = entry.options();
        Object widget = switch (entry.type()) {
            default -> throw new IncompatibleClassChangeError();
            case EntryType.BOOLEAN -> new BooleanOptionWidget(entry::getBoolean, entry::setBoolean);
            case EntryType.STRING -> {
                if (options.isMultiline()) {
                    yield new MultilineStringOptionWidget(entry::getString, entry::setString);
                }
                yield new StringOptionWidget(entry::getString, entry::setString);
            }
            case EntryType.ENUM -> new DropdownWidget((Enum[])entry.objectType().getEnumConstants(), entry::getEnum, entry::setEnum);
            case EntryType.BYTE, EntryType.SHORT, EntryType.INTEGER, EntryType.LONG -> {
                Record range = WholeOptionRange.of(entry);
                if (range.hasRange() && options.hasSlider()) {
                    yield new RangeOptionWidget((OptionRange)((Object)range));
                }
                switch (entry.type()) {
                    case BYTE: {
                        yield new NumberOptionWidget<Byte>(entry::getByte, entry::setByte, Options.parseNumber(options, Byte::parseByte), NumberOptionWidget.INTEGER_FILTER);
                    }
                    case SHORT: {
                        yield new NumberOptionWidget<Short>(entry::getShort, entry::setShort, Options.parseNumber(options, Short::parseShort), NumberOptionWidget.INTEGER_FILTER);
                    }
                    case INTEGER: {
                        yield new NumberOptionWidget<Integer>(entry::getInt, entry::setInt, Options.parseNumber(options, Integer::parseInt), NumberOptionWidget.INTEGER_FILTER);
                    }
                    case LONG: {
                        yield new NumberOptionWidget<Long>(entry::getLong, entry::setLong, Options.parseNumber(options, Long::parseLong), NumberOptionWidget.INTEGER_FILTER);
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
            }
            case EntryType.FLOAT, EntryType.DOUBLE -> {
                Record range = DecimalOptionRange.of(entry);
                if (range.hasRange() && options.hasSlider()) {
                    yield new RangeOptionWidget((OptionRange)((Object)range));
                }
                switch (entry.type()) {
                    case FLOAT: {
                        yield new NumberOptionWidget<Float>(entry::getFloat, entry::setFloat, Float::parseFloat, NumberOptionWidget.DECIMAL_FILTER);
                    }
                    case DOUBLE: {
                        yield new NumberOptionWidget<Double>(entry::getDouble, entry::setDouble, Double::parseDouble, NumberOptionWidget.DECIMAL_FILTER);
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
            }
            case EntryType.OBJECT -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
        };
        SpriteButton reset = SpriteButton.builder(12, 12).padding(2).sprite(ModSprites.RESET).tooltip(UIConstants.RESET).onPress(Options.resetValue(entry, widget)).build();
        list.add(new OptionItem(entry, List.of(widget, reset)));
    }

    private static Runnable resetValue(ResourcefulConfigEntry entry, class_339 widget) {
        return () -> {
            entry.reset();
            if (widget instanceof ResetableWidget) {
                ResetableWidget resetable = (ResetableWidget)widget;
                resetable.reset();
            }
        };
    }

    private static <T extends Number> Function<String, T> parseNumber(EntryData options, Function<String, T> parser) {
        return s -> {
            Number value = (Number)parser.apply((String)s);
            if (options.hasRange()) {
                if (value.doubleValue() < options.min()) {
                    throw new NumberFormatException();
                }
                if (value.doubleValue() > options.max()) {
                    throw new NumberFormatException();
                }
            }
            return value;
        };
    }

    private static /* synthetic */ void lambda$populateOptions$0(Multimap buttonsBefore, Multimap buttonsAfter, ResourcefulConfigButton button) {
        switch (button.position()) {
            case BEFORE: {
                buttonsBefore.put((Object)button.target(), (Object)button);
                break;
            }
            case AFTER: {
                buttonsAfter.put((Object)button.target(), (Object)button);
            }
        }
    }
}

