/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsMain;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.data.SlotLoader;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7923;

public class EntitySlotLoader
extends class_4080<Map<String, Map<String, Set<String>>>>
implements IdentifiableResourceReloadListener {
    public static final EntitySlotLoader CLIENT = new EntitySlotLoader();
    public static final EntitySlotLoader SERVER = new EntitySlotLoader();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final class_2960 ID = new class_2960("trinkets", "entities");
    private final Map<class_1299<?>, Map<String, SlotGroup>> slots = new HashMap();

    protected Map<String, Map<String, Set<String>>> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>();
        String dataType = "entities";
        for (Map.Entry entry : resourceManager.method_41265(dataType, id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            if (!identifier.method_12836().equals("trinkets")) continue;
            try {
                for (class_3298 resource : (List)entry.getValue()) {
                    InputStreamReader reader = new InputStreamReader(resource.method_14482());
                    JsonObject jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    try {
                        boolean replace = class_3518.method_15258((JsonObject)jsonObject, (String)"replace", (boolean)false);
                        JsonArray assignedSlots = class_3518.method_15292((JsonObject)jsonObject, (String)"slots", (JsonArray)new JsonArray());
                        HashMap<String, Set> groups = new HashMap<String, Set>();
                        if (assignedSlots != null) {
                            for (JsonElement assignedSlot : assignedSlots) {
                                String slot = assignedSlot.getAsString();
                                String[] parsedSlot = slot.split("/");
                                if (parsedSlot.length != 2) {
                                    TrinketsMain.LOGGER.error("Detected malformed slot assignment " + slot + "! Slots should be in the format 'group/slot'.");
                                    continue;
                                }
                                String group = parsedSlot[0];
                                String name = parsedSlot[1];
                                groups.computeIfAbsent(group, k -> new HashSet()).add(name);
                            }
                        }
                        JsonArray entities = class_3518.method_15292((JsonObject)jsonObject, (String)"entities", (JsonArray)new JsonArray());
                        if (groups.isEmpty() || entities == null) continue;
                        for (JsonElement entity : entities) {
                            String name = entity.getAsString();
                            Object id2 = name.startsWith("#") ? "#" + String.valueOf(new class_2960(name.substring(1))) : new class_2960(name).toString();
                            Map slots = map.computeIfAbsent((String)id2, k -> new HashMap());
                            if (replace) {
                                slots.clear();
                            }
                            groups.forEach((groupName, slotNames) -> slots.computeIfAbsent(groupName, k -> new HashSet()).addAll(slotNames));
                        }
                    }
                    catch (JsonSyntaxException e) {
                        TrinketsMain.LOGGER.error("[trinkets] Syntax error while reading data for " + identifier.method_12832());
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                TrinketsMain.LOGGER.error("[trinkets] Unknown IO error while reading slot data!");
                e.printStackTrace();
            }
        }
        return map;
    }

    protected void apply(Map<String, Map<String, Set<String>>> loader, class_3300 manager, class_3695 profiler) {
        Map<String, SlotLoader.GroupData> slots = SlotLoader.INSTANCE.getSlots();
        HashMap<class_1299, Map> groupBuilders = new HashMap<class_1299, Map>();
        loader.forEach((entityName, groups) -> {
            HashSet<class_1299> types = new HashSet<class_1299>();
            try {
                if (entityName.startsWith("#")) {
                    TrinketsMain.LOGGER.error("[trinkets] Attempted to assign entity entry to tag");
                } else {
                    types.add((class_1299)class_7923.field_41177.method_17966(new class_2960(entityName)).orElseThrow(() -> new IllegalArgumentException("Unknown entity '" + entityName + "'")));
                }
            }
            catch (IllegalArgumentException e) {
                TrinketsMain.LOGGER.error("[trinkets] Attempted to assign unknown entity entry " + entityName);
            }
            for (class_1299 type : types) {
                Map builders = groupBuilders.computeIfAbsent(type, k -> new HashMap());
                groups.forEach((groupName, slotNames) -> {
                    SlotLoader.GroupData group = (SlotLoader.GroupData)slots.get(groupName);
                    if (group != null) {
                        SlotGroup.Builder builder = builders.computeIfAbsent(groupName, k -> new SlotGroup.Builder((String)groupName, group.getSlotId(), group.getOrder()));
                        slotNames.forEach(slotName -> {
                            SlotLoader.SlotData slotData = group.getSlot((String)slotName);
                            if (slotData != null) {
                                builder.addSlot((String)slotName, slotData.create((String)groupName, (String)slotName));
                            } else {
                                TrinketsMain.LOGGER.error("[trinkets] Attempted to assign unknown slot " + slotName);
                            }
                        });
                    } else {
                        TrinketsMain.LOGGER.error("[trinkets] Attempted to assign slot from unknown group " + groupName);
                    }
                });
            }
        });
        this.slots.clear();
        groupBuilders.forEach((entity, groups) -> {
            Map entitySlots = this.slots.computeIfAbsent((class_1299<?>)entity, k -> new HashMap());
            groups.forEach((groupName, groupBuilder) -> entitySlots.putIfAbsent(groupName, groupBuilder.build()));
        });
    }

    public Map<String, SlotGroup> getEntitySlots(class_1299<?> entityType) {
        if (this.slots.containsKey(entityType)) {
            return ImmutableMap.copyOf(this.slots.get(entityType));
        }
        return ImmutableMap.of();
    }

    public void setSlots(Map<class_1299<?>, Map<String, SlotGroup>> slots) {
        this.slots.clear();
        this.slots.putAll(slots);
    }

    public void sync(class_3222 playerEntity) {
        class_2540 buf = this.getSlotsPacket();
        ServerPlayNetworking.send((class_3222)playerEntity, (class_2960)TrinketsNetwork.SYNC_SLOTS, (class_2540)buf);
    }

    public void sync(List<? extends class_3222> players) {
        class_2540 buf = this.getSlotsPacket();
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)TrinketsNetwork.SYNC_SLOTS, (class_2540)buf));
        players.forEach(player -> ((TrinketPlayerScreenHandler)player.field_7498).trinkets$updateTrinketSlots(true));
    }

    private class_2540 getSlotsPacket() {
        class_2487 tag = new class_2487();
        this.slots.forEach((entity, slotMap) -> {
            class_2487 slotsTag = new class_2487();
            slotMap.forEach((id, slotGroup) -> {
                class_2487 groupTag = new class_2487();
                slotGroup.write(groupTag);
                slotsTag.method_10566(id, (class_2520)groupTag);
            });
            tag.method_10566(class_7923.field_41177.method_10221(entity).toString(), (class_2520)slotsTag);
        });
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10794((class_2520)tag);
        return buf;
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return Lists.newArrayList((Object[])new class_2960[]{SlotLoader.ID, ResourceReloadListenerKeys.TAGS});
    }
}

