/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.config.BooleanSettingEntry;
import dev.lambdaurora.lambdynlights.config.SettingEntry;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.core.file.FileConfig;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class DynamicLightsConfig {
    private static final DynamicLightsMode DEFAULT_DYNAMIC_LIGHTS_MODE = DynamicLightsMode.FANCY;
    private static final boolean DEFAULT_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_SELF_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_BLOCK_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_WATER_SENSITIVE_CHECK = true;
    private static final ExplosiveLightingMode DEFAULT_CREEPER_LIGHTING_MODE = ExplosiveLightingMode.SIMPLE;
    private static final ExplosiveLightingMode DEFAULT_TNT_LIGHTING_MODE = ExplosiveLightingMode.OFF;
    public static final Path CONFIG_FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("lambdynlights.toml");
    protected final FileConfig config;
    private final LambDynLights mod;
    private DynamicLightsMode dynamicLightsMode;
    private final BooleanSettingEntry entitiesLightSource;
    private final BooleanSettingEntry selfLightSource;
    private final BooleanSettingEntry blockEntitiesLightSource;
    private final BooleanSettingEntry waterSensitiveCheck;
    private ExplosiveLightingMode creeperLightingMode;
    private ExplosiveLightingMode tntLightingMode;
    public final SpruceOption dynamicLightsModeOption = new SpruceCyclingOption("lambdynlights.option.mode", amount -> this.setDynamicLightsMode(this.dynamicLightsMode.next()), option -> option.getDisplayText(this.dynamicLightsMode.getTranslatedText()), (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.mode.1").method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.mode.2", (Object[])new Object[]{DynamicLightsMode.FASTEST.getTranslatedText(), DynamicLightsMode.FAST.getTranslatedText()})).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.mode.3", (Object[])new Object[]{DynamicLightsMode.FANCY.getTranslatedText()})));

    public DynamicLightsConfig(@NotNull LambDynLights mod) {
        this.mod = mod;
        this.config = FileConfig.builder(CONFIG_FILE_PATH).concurrent().defaultResource("/lambdynlights.toml").autosave().build();
        this.entitiesLightSource = new BooleanSettingEntry("light_sources.entities", true, (Config)this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.entities")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeEntitiesLightSource();
            }
        });
        this.selfLightSource = new BooleanSettingEntry("light_sources.self", true, (Config)this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.self_light_source")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeLightSources(source -> source instanceof class_746 && source == class_310.method_1551().field_1724);
            }
        });
        this.blockEntitiesLightSource = new BooleanSettingEntry("light_sources.block_entities", true, (Config)this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.block_entities")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeBlockEntitiesLightSource();
            }
        });
        this.waterSensitiveCheck = new BooleanSettingEntry("light_sources.water_sensitive_check", true, (Config)this.config, (class_2561)class_2561.method_43471((String)"lambdynlights.tooltip.water_sensitive"));
    }

    public void load() {
        this.config.load();
        String dynamicLightsModeValue = this.config.getOrElse("mode", DEFAULT_DYNAMIC_LIGHTS_MODE.getName());
        this.dynamicLightsMode = DynamicLightsMode.byId(dynamicLightsModeValue).orElse(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.entitiesLightSource.load(this.config);
        this.selfLightSource.load(this.config);
        this.blockEntitiesLightSource.load(this.config);
        this.waterSensitiveCheck.load(this.config);
        this.creeperLightingMode = ExplosiveLightingMode.byId(this.config.getOrElse("light_sources.creeper", DEFAULT_CREEPER_LIGHTING_MODE.getName())).orElse(DEFAULT_CREEPER_LIGHTING_MODE);
        this.tntLightingMode = ExplosiveLightingMode.byId(this.config.getOrElse("light_sources.tnt", DEFAULT_TNT_LIGHTING_MODE.getName())).orElse(DEFAULT_TNT_LIGHTING_MODE);
        this.mod.log("Configuration loaded.");
    }

    public void load(SettingEntry<?> settingEntry) {
        settingEntry.load(this.config);
    }

    public void save() {
        this.config.save();
    }

    public void reset() {
        this.setDynamicLightsMode(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.getEntitiesLightSource().set(true);
        this.getSelfLightSource().set(true);
        this.getBlockEntitiesLightSource().set(true);
        this.getWaterSensitiveCheck().set(true);
        this.setCreeperLightingMode(DEFAULT_CREEPER_LIGHTING_MODE);
        this.setTntLightingMode(DEFAULT_TNT_LIGHTING_MODE);
    }

    public DynamicLightsMode getDynamicLightsMode() {
        return this.dynamicLightsMode;
    }

    public void setDynamicLightsMode(@NotNull DynamicLightsMode mode) {
        if (!mode.isEnabled()) {
            this.mod.clearLightSources();
        }
        this.dynamicLightsMode = mode;
        this.config.set("mode", (Object)mode.getName());
    }

    public BooleanSettingEntry getEntitiesLightSource() {
        return this.entitiesLightSource;
    }

    public BooleanSettingEntry getSelfLightSource() {
        return this.selfLightSource;
    }

    public BooleanSettingEntry getBlockEntitiesLightSource() {
        return this.blockEntitiesLightSource;
    }

    public BooleanSettingEntry getWaterSensitiveCheck() {
        return this.waterSensitiveCheck;
    }

    public ExplosiveLightingMode getCreeperLightingMode() {
        return this.creeperLightingMode;
    }

    public void setCreeperLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.creeperLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeCreeperLightSources();
        }
        this.config.set("light_sources.creeper", (Object)lightingMode.getName());
    }

    public ExplosiveLightingMode getTntLightingMode() {
        return this.tntLightingMode;
    }

    public void setTntLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.tntLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeTntLightSources();
        }
        this.config.set("light_sources.tnt", (Object)lightingMode.getName());
    }
}

