/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.ThreadPooler;
import me.chrr.camerapture.config.Config;
import me.chrr.camerapture.config.ConfigManager;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureCloningRecipe;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.net.Networking;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.RequestDownloadPacket;
import me.chrr.camerapture.net.serverbound.SyncConfigPacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ServerPictureStore;
import me.chrr.camerapture.picture.StoredPicture;
import me.chrr.camerapture.screen.AlbumLecternScreenHandler;
import me.chrr.camerapture.screen.AlbumScreenHandler;
import me.chrr.camerapture.screen.PictureFrameScreenHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Camerapture
implements ModInitializer {
    public static final int SECTION_SIZE = 30000;
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static final class_1792 CAMERA = new CameraItem(new class_1792.class_1793().method_7889(1));
    public static final class_3414 CAMERA_SHUTTER = class_3414.method_47908((class_2960)Camerapture.id("camera_shutter"));
    public static final class_2960 PICTURES_TAKEN = Camerapture.id("pictures_taken");
    public static final class_1792 PICTURE = new PictureItem(new class_1792.class_1793());
    public static final class_1866<PictureCloningRecipe> PICTURE_CLONING = new class_1866(PictureCloningRecipe::new);
    public static final class_1792 ALBUM = new AlbumItem(new class_1792.class_1793().method_7889(1));
    public static final class_3917<AlbumScreenHandler> ALBUM_SCREEN_HANDLER = new ExtendedScreenHandlerType(AlbumScreenHandler::new);
    public static final class_3917<AlbumLecternScreenHandler> ALBUM_LECTERN_SCREEN_HANDLER = new class_3917((syncId, pi) -> new AlbumLecternScreenHandler(syncId), class_7699.method_45397());
    public static final class_1299<PictureFrameEntity> PICTURE_FRAME = class_1299.class_1300.method_5903(PictureFrameEntity::new, (class_1311)class_1311.field_17715).method_27299(10).method_5905("picture_frame");
    public static final class_3917<PictureFrameScreenHandler> PICTURE_FRAME_SCREEN_HANDLER = new class_3917((syncId, pi) -> new PictureFrameScreenHandler(syncId), class_7699.method_45397());
    private final Queue<QueuedPicture> downloadQueue = new LinkedList<QueuedPicture>();

    public void onInitialize() {
        try {
            CONFIG_MANAGER.load();
        }
        catch (IOException e) {
            LOGGER.error("failed to load config", (Throwable)e);
        }
        this.registerContent();
        this.registerPackets();
        this.registerEvents();
    }

    private void registerContent() {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Camerapture.id("camera"), (Object)CAMERA);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> content.method_45421((class_1935)CAMERA));
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)CAMERA_SHUTTER.method_14833(), (Object)CAMERA_SHUTTER);
        class_2378.method_10226((class_2378)class_7923.field_41183, (String)"pictures_taken", (Object)PICTURES_TAKEN);
        class_3468.field_15419.method_14955((Object)PICTURES_TAKEN, class_3446.field_16975);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Camerapture.id("picture"), (Object)PICTURE);
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)Camerapture.id("picture_cloning"), PICTURE_CLONING);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Camerapture.id("album"), (Object)ALBUM);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Camerapture.id("album"), ALBUM_SCREEN_HANDLER);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Camerapture.id("album_lectern"), ALBUM_LECTERN_SCREEN_HANDLER);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> content.method_45421((class_1935)ALBUM));
        class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)Camerapture.id("picture_frame"), PICTURE_FRAME);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Camerapture.id("picture_frame"), PICTURE_FRAME_SCREEN_HANDLER);
    }

    private void registerPackets() {
        Networking.registerServerBound(NewPicturePacket.class, NewPicturePacket.NET_CODEC);
        Networking.registerServerBound(RequestDownloadPacket.class, RequestDownloadPacket.NET_CODEC);
        Networking.registerServerBound(UploadPartialPicturePacket.class, UploadPartialPicturePacket.NET_CODEC);
        Networking.registerClientBound(PictureErrorPacket.class, PictureErrorPacket.NET_CODEC);
        Networking.registerClientBound(RequestUploadPacket.class, RequestUploadPacket.NET_CODEC);
        Networking.registerClientBound(SyncConfigPacket.class, SyncConfigPacket.NET_CODEC);
        Networking.registerClientBound(DownloadPartialPicturePacket.class, DownloadPartialPicturePacket.NET_CODEC);
        Networking.onServerPacketReceive(NewPicturePacket.class, (packet, player) -> {
            class_3545<class_1268, class_1799> camera = Camerapture.findCamera((class_1657)player, false);
            if (camera == null) {
                return;
            }
            if (!player.method_7337() && class_1262.method_29234((class_1263)player.method_31548(), stack -> stack.method_31574(class_1802.field_8407), (int)1, (boolean)false) != 1) {
                return;
            }
            if (CameraItem.isActive((class_1799)camera.method_15441())) {
                player.method_51469().method_43129(null, (class_1297)player, CAMERA_SHUTTER, class_3419.field_15248, 1.0f, 1.0f);
            }
            CameraItem.setActive((class_1799)camera.method_15441(), false);
            player.method_7357().method_7906(((class_1799)camera.method_15441()).method_7909(), 60);
            player.method_23667((class_1268)camera.method_15442(), true);
            player.method_7281(PICTURES_TAKEN);
            UUID uuid = ServerPictureStore.getInstance().reserveId();
            Networking.sendTo(player, new RequestUploadPacket(uuid));
        });
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        Networking.onServerPacketReceive(UploadPartialPicturePacket.class, (packet, player) -> {
            ByteCollector collector;
            if (!ServerPictureStore.getInstance().isReserved(packet.uuid())) {
                LOGGER.error("{} tried to send a byte section for an unreserved UUID", (Object)player.method_5477().toString());
                return;
            }
            if (packet.bytesLeft() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.method_5477().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
            if (!(collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                collectors.remove(uuid);
                ThreadPooler.run(() -> {
                    try {
                        MinecraftServer server = player.method_5682();
                        if (server == null) {
                            return;
                        }
                        ServerPictureStore.getInstance().put(server, (UUID)uuid, new StoredPicture((byte[])bytes));
                        class_1799 picture = PictureItem.create(player.method_5477().getString(), uuid);
                        server.execute(() -> player.method_31548().method_7398(picture));
                    }
                    catch (Exception e) {
                        LOGGER.error("failed to save picture from {}", (Object)player.method_5477().getString(), (Object)e);
                        player.method_43496((class_2561)class_2561.method_43471((String)"text.camerapture.picture_failed").method_27692(class_124.field_1061));
                    }
                });
            }))).push(packet.bytes(), packet.bytesLeft())) {
                LOGGER.error("{} sent a malformed byte section", (Object)player.method_5477().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
            if (collector.getCurrentLength() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.method_5477().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
        });
        Networking.onServerPacketReceive(RequestDownloadPacket.class, (packet, player) -> {
            try {
                StoredPicture picture = ServerPictureStore.getInstance().get(player.method_5682(), packet.uuid());
                if (picture == null) {
                    LOGGER.warn("{} requested a picture with an unknown UUID", (Object)player.method_5477().getString());
                    Networking.sendTo(player, new PictureErrorPacket(packet.uuid()));
                    return;
                }
                this.downloadQueue.add(new QueuedPicture((class_3222)player, packet.uuid(), picture));
            }
            catch (Exception e) {
                LOGGER.error("failed to load picture for {}", (Object)player.method_5477().getString(), (Object)e);
                Networking.sendTo(player, new PictureErrorPacket(packet.uuid()));
            }
        });
    }

    private void registerEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            Config config = CONFIG_MANAGER.getConfig();
            Networking.sendTo(handler.field_14140, new SyncConfigPacket(config.server.maxImageBytes, config.server.maxImageResolution));
        });
        MutableObject timer = new MutableObject();
        ServerLifecycleEvents.SERVER_STARTED.register(arg_0 -> this.lambda$registerEvents$13((Mutable)timer, arg_0));
        ServerLifecycleEvents.SERVER_STOPPED.register(arg_0 -> Camerapture.lambda$registerEvents$14((Mutable)timer, arg_0));
    }

    @Nullable
    public static class_3545<class_1268, class_1799> findCamera(class_1657 player, boolean active) {
        if (player == null) {
            return null;
        }
        for (class_1268 hand : class_1268.values()) {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_31574(CAMERA) || active && !CameraItem.isActive(stack)) continue;
            return new class_3545((Object)hand, (Object)stack);
        }
        return null;
    }

    public static boolean hasActiveCamera(class_1657 player) {
        return Camerapture.findCamera(player, true) != null;
    }

    public static class_2960 id(String path) {
        return new class_2960("camerapture", path);
    }

    private static /* synthetic */ void lambda$registerEvents$14(Mutable timer, MinecraftServer server) {
        ((Timer)timer.getValue()).cancel();
    }

    private /* synthetic */ void lambda$registerEvents$13(Mutable timer, MinecraftServer server) {
        Timer timerObject = new Timer("Picture sender");
        timer.setValue((Object)timerObject);
        timerObject.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                QueuedPicture item = Camerapture.this.downloadQueue.poll();
                if (item == null || item.recipient.method_14239()) {
                    return;
                }
                ByteCollector.split(item.picture.bytes(), 30000, (section, bytesLeft) -> Networking.sendTo(item.recipient, new DownloadPartialPicturePacket(item.uuid, section, bytesLeft)));
            }
        }, 0L, (long)Camerapture.CONFIG_MANAGER.getConfig().server.msPerPicture);
    }

    private record QueuedPicture(class_3222 recipient, UUID uuid, StoredPicture picture) {
    }
}

