/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import com.luciad.imageio.webp.WebP;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.ThreadPooler;
import me.chrr.camerapture.compat.FirstPersonModelCompat;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.net.ClientNetworking;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.serverbound.SyncConfigPacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.PictureTaker;
import me.chrr.camerapture.render.PictureFrameEntityRenderer;
import me.chrr.camerapture.render.PictureItemRenderer;
import me.chrr.camerapture.screen.AlbumLecternScreen;
import me.chrr.camerapture.screen.AlbumLecternScreenHandler;
import me.chrr.camerapture.screen.AlbumScreen;
import me.chrr.camerapture.screen.PictureFrameScreen;
import me.chrr.camerapture.screen.PictureScreen;
import me.chrr.camerapture.screen.UploadScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.event.client.player.ClientPreAttackCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5272;

@Environment(value=EnvType.CLIENT)
public class CameraptureClient
implements ClientModInitializer {
    public static boolean replayModInstalled = false;

    public void onInitializeClient() {
        ImageIO.scanForPlugins();
        if (!WebP.loadNativeLibrary()) {
            Camerapture.LOGGER.error("failed to load ImageIO-WebP, pictures might not work!");
        }
        if (FabricLoader.getInstance().isModLoaded("firstperson")) {
            FirstPersonModelCompat.register();
        }
        ClientPictureStore.getInstance().clear();
        PictureTaker.getInstance().resetConfig();
        class_3929.method_17542(Camerapture.ALBUM_SCREEN_HANDLER, AlbumScreen::new);
        class_3929.method_17542(Camerapture.PICTURE_FRAME_SCREEN_HANDLER, PictureFrameScreen::new);
        class_3929.method_17542(Camerapture.ALBUM_LECTERN_SCREEN_HANDLER, (handler, pi, title) -> new AlbumLecternScreen((AlbumLecternScreenHandler)handler));
        EntityRendererRegistry.register(Camerapture.PICTURE_FRAME, PictureFrameEntityRenderer::new);
        PictureItemRenderer pictureItemRenderer = new PictureItemRenderer();
        class_5272.method_27879((class_1792)Camerapture.PICTURE, (class_2960)Camerapture.id("has_picture"), (stack, world, entity, seed) -> pictureItemRenderer.canRender(stack) ? 1.0f : 0.0f);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)Camerapture.PICTURE, (BuiltinItemRendererRegistry.DynamicItemRenderer)pictureItemRenderer);
        if (FabricLoader.getInstance().isModLoaded("replaymod")) {
            Camerapture.LOGGER.info("Replay Mod is detected, Camerapture will cache pictures, regardless of config");
            replayModInstalled = true;
        }
        this.registerPackets();
        this.registerEvents();
    }

    private void registerPackets() {
        ClientNetworking.init();
        ClientNetworking.onClientPacketReceive(RequestUploadPacket.class, packet -> ThreadPooler.run(() -> PictureTaker.getInstance().sendStoredPicture(packet.uuid())));
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        ClientNetworking.onClientPacketReceive(DownloadPartialPicturePacket.class, packet -> {
            ByteCollector collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                collectors.remove(uuid);
                ThreadPooler.run(() -> ClientPictureStore.getInstance().processReceivedBytes((UUID)uuid, (byte[])bytes));
            }));
            if (!collector.push(packet.bytes(), packet.bytesLeft())) {
                Camerapture.LOGGER.error("received malformed byte section from server");
                ClientPictureStore.getInstance().processReceivedError(packet.uuid());
            }
        });
        ClientNetworking.onClientPacketReceive(PictureErrorPacket.class, packet -> {
            ClientPictureStore.getInstance().processReceivedError(packet.uuid());
            collectors.remove(packet.uuid());
        });
        ClientNetworking.onClientPacketReceive(SyncConfigPacket.class, packet -> PictureTaker.getInstance().setConfig(packet.maxImageBytes(), packet.maxImageResolution()));
    }

    private void registerEvents() {
        ClientPreAttackCallback.EVENT.register((client, player, clickCount) -> {
            if (Camerapture.hasActiveCamera((class_1657)player) && CameraptureClient.canTakePicture()) {
                PictureTaker.getInstance().uploadScreenPicture();
                return true;
            }
            return false;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            class_310 client = class_310.method_1551();
            if (client.field_1724 != player) {
                return class_1271.method_22430((Object)stack);
            }
            if (stack.method_31574(Camerapture.PICTURE)) {
                if (PictureItem.getPictureData(stack) != null) {
                    client.method_40000(() -> client.method_1507((class_437)new PictureScreen(List.of(stack))));
                    return class_1271.method_22427((Object)stack);
                }
            } else if (stack.method_31574(Camerapture.ALBUM) && !player.method_5715()) {
                List<class_1799> pictures = AlbumItem.getPictures(stack);
                if (!pictures.isEmpty()) {
                    client.method_40000(() -> client.method_1507((class_437)new PictureScreen(pictures)));
                    return class_1271.method_22427((Object)stack);
                }
            } else if (player.method_5715() && stack.method_31574(Camerapture.CAMERA) && !CameraItem.isActive(stack) && !player.method_7357().method_7904(Camerapture.CAMERA)) {
                client.method_40000(() -> client.method_1507((class_437)new UploadScreen()));
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ClientPictureStore.getInstance().clear();
            PictureTaker.getInstance().resetConfig();
        });
    }

    public static int paperInInventory() {
        class_310 client = class_310.method_1551();
        return client.field_1724 == null ? 0 : client.field_1724.method_31548().method_18861(class_1802.field_8407);
    }

    public static boolean canTakePicture() {
        class_310 client = class_310.method_1551();
        return CameraptureClient.paperInInventory() > 0 || client.field_1724 != null && client.field_1724.method_7337();
    }
}

