/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.net;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.net.ClientAdapter;
import me.chrr.camerapture.net.Networking;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class ClientNetworking
implements ClientAdapter {
    private ClientNetworking() {
    }

    public static void init() {
        Networking.setClientAdapter(new ClientNetworking());
    }

    public static <P> void sendToServer(P packet) {
        Networking.ClientPacketType<?> type = Networking.getClientPacketType(packet.getClass());
        class_2540 buf = PacketByteBufs.create();
        MapCodec dataCodec = type.netCodec().codec().fieldOf("data");
        DataResult result = dataCodec.encoder().encodeStart((DynamicOps)class_2509.field_11560, packet);
        buf.method_10794((class_2520)result.get().left().orElseThrow());
        ClientPlayNetworking.send((class_2960)type.netCodec().id(), (class_2540)buf);
    }

    public static <P> void onClientPacketReceive(Class<P> clazz, Consumer<P> handler) {
        Networking.getServerPacketType(clazz).handlers().add(handler);
    }

    @Override
    public <P> void registerHandler(Networking.ServerPacketType<P> type) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)type.netCodec().id(), (client, networkHandler, buf, sender) -> {
            MapCodec dataCodec = type.netCodec().codec().fieldOf("data");
            DataResult result = dataCodec.decoder().decode((DynamicOps)class_2509.field_11560, (Object)buf.method_10798());
            if (result.error().isPresent()) {
                Camerapture.LOGGER.error("failed to decode packet: {}", (Object)((DataResult.PartialResult)result.error().get()).message());
                return;
            }
            Object packet = ((Pair)result.result().orElseThrow()).getFirst();
            type.handlers().forEach(handler -> handler.accept(packet));
        });
    }
}

