/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.net;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.net.ClientAdapter;
import me.chrr.camerapture.net.NetCodec;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class Networking {
    private static final Map<Class<?>, ServerPacketType<?>> serverPackets = new HashMap();
    private static final Map<Class<?>, ClientPacketType<?>> clientPackets = new HashMap();
    private static ClientAdapter clientAdapter = null;

    private Networking() {
    }

    public static <P> void registerServerBound(Class<P> clazz, NetCodec<P> netCodec) {
        ClientPacketType type = new ClientPacketType(netCodec, new ArrayList());
        clientPackets.put(clazz, type);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)netCodec.id(), (server, player, networkHandler, buf, sender) -> {
            MapCodec dataCodec = type.netCodec().codec().fieldOf("data");
            DataResult result = dataCodec.decoder().decode((DynamicOps)class_2509.field_11560, (Object)buf.method_10798());
            if (result.error().isPresent()) {
                Camerapture.LOGGER.error("failed to decode packet: {}", (Object)((DataResult.PartialResult)result.error().get()).message());
                return;
            }
            Object packet = ((Pair)result.result().orElseThrow()).getFirst();
            type.handlers().forEach(handler -> handler.accept(packet, player));
        });
    }

    public static <P> void registerClientBound(Class<P> clazz, NetCodec<P> netCodec) {
        ServerPacketType<P> type = new ServerPacketType<P>(netCodec, new ArrayList());
        serverPackets.put(clazz, type);
        if (clientAdapter != null) {
            clientAdapter.registerHandler(type);
        }
    }

    public static <P> void sendTo(class_3222 player, P packet) {
        ServerPacketType<?> type = Networking.getServerPacketType(packet.getClass());
        class_2540 buf = PacketByteBufs.create();
        MapCodec dataCodec = type.netCodec().codec().fieldOf("data");
        DataResult result = dataCodec.encoder().encodeStart((DynamicOps)class_2509.field_11560, packet);
        buf.method_10794((class_2520)result.get().left().orElseThrow());
        ServerPlayNetworking.send((class_3222)player, (class_2960)type.netCodec().id(), (class_2540)buf);
    }

    public static <P> void onServerPacketReceive(Class<P> clazz, BiConsumer<P, class_3222> handler) {
        Networking.getClientPacketType(clazz).handlers().add(handler);
    }

    public static <P> ServerPacketType<P> getServerPacketType(Class<P> clazz) {
        ServerPacketType<?> type = serverPackets.get(clazz);
        return type;
    }

    public static <P> ClientPacketType<P> getClientPacketType(Class<P> clazz) {
        ClientPacketType<?> type = clientPackets.get(clazz);
        return type;
    }

    public static void setClientAdapter(ClientAdapter adapter) {
        clientAdapter = adapter;
        serverPackets.values().forEach(adapter::registerHandler);
    }

    public record ClientPacketType<P>(NetCodec<P> netCodec, List<BiConsumer<P, class_3222>> handlers) {
    }

    public record ServerPacketType<P>(NetCodec<P> netCodec, List<Consumer<P>> handlers) {
    }
}

