/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.picture;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.CameraptureClient;
import me.chrr.camerapture.ThreadPooler;
import me.chrr.camerapture.net.ClientNetworking;
import me.chrr.camerapture.net.serverbound.RequestDownloadPacket;
import me.chrr.camerapture.picture.RemotePicture;
import me.chrr.camerapture.util.ImageUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClientPictureStore {
    private static final ClientPictureStore INSTANCE = new ClientPictureStore();
    private final Map<UUID, RemotePicture> pictures = new HashMap<UUID, RemotePicture>();

    private ClientPictureStore() {
    }

    public void clear() {
        class_310.method_1551().method_40000(() -> {
            for (RemotePicture picture : this.pictures.values()) {
                if (picture.getTextureIdentifier() == null) continue;
                class_310.method_1551().method_1531().method_4615(picture.getTextureIdentifier());
            }
            this.pictures.clear();
        });
    }

    public void processReceivedError(UUID id) {
        RemotePicture picture = this.pictures.get(id);
        if (picture == null) {
            return;
        }
        picture.setStatus(RemotePicture.Status.ERROR);
        Camerapture.LOGGER.error("remote error for image {}", (Object)id);
    }

    private void fetchPicture(UUID id) {
        ThreadPooler.run(() -> {
            File file = this.getCacheFilePath(id).toFile();
            if (file.exists()) {
                try {
                    BufferedImage image = ImageIO.read(file);
                    this.processReceivedImage(id, image);
                    return;
                }
                catch (IOException e) {
                    Camerapture.LOGGER.error("could not read cached picture {}", (Object)id, (Object)e);
                }
            }
            ClientNetworking.sendToServer(new RequestDownloadPacket(id));
        });
    }

    public void cacheBytesToDisk(UUID id, byte[] bytes) {
        if (!ClientPictureStore.shouldCacheToDisk()) {
            return;
        }
        try {
            Path path = this.getCacheFilePath(id);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            Camerapture.LOGGER.error("could not cache picture {}", (Object)id, (Object)e);
        }
    }

    public void processReceivedImage(UUID id, BufferedImage image) {
        RemotePicture picture = this.pictures.computeIfAbsent(id, RemotePicture::new);
        picture.setSize(image.getWidth(), image.getHeight());
        class_1011 nativeImage = ImageUtil.toNativeImage(image);
        class_1043 texture = new class_1043(nativeImage);
        class_310.method_1551().method_40000(() -> {
            class_310.method_1551().method_1531().method_4616(picture.getTextureIdentifier(), (class_1044)texture);
            picture.setStatus(RemotePicture.Status.SUCCESS);
        });
    }

    public void processReceivedBytes(UUID id, byte[] bytes) {
        try {
            this.processReceivedImage(id, ImageIO.read(new ByteArrayInputStream(bytes)));
            this.cacheBytesToDisk(id, bytes);
        }
        catch (Exception e) {
            Camerapture.LOGGER.error("failed to decode received image bytes for image {}", (Object)id, (Object)e);
            RemotePicture picture = this.pictures.computeIfAbsent(id, RemotePicture::new);
            picture.setStatus(RemotePicture.Status.ERROR);
        }
    }

    public RemotePicture ensureRemotePicture(@NotNull UUID id) {
        RemotePicture picture = this.pictures.get(id);
        if (picture == null || picture.getStatus() == RemotePicture.Status.ERROR) {
            picture = new RemotePicture(id);
            this.pictures.put(id, picture);
            this.fetchPicture(id);
        }
        return picture;
    }

    public RemotePicture getServerPicture(@NotNull UUID id) {
        return Optional.ofNullable(this.pictures.get(id)).orElseGet(() -> this.ensureRemotePicture(id));
    }

    private static boolean shouldCacheToDisk() {
        return CameraptureClient.replayModInstalled || Camerapture.CONFIG_MANAGER.getConfig().client.cachePictures && !class_310.method_1551().method_47392();
    }

    private Path getCacheFilePath(UUID uuid) {
        Path cacheFolder = FabricLoader.getInstance().getGameDir().resolve("camerapture").resolve("picture-cache");
        return cacheFolder.resolve(String.valueOf(uuid) + ".webp");
    }

    public static ClientPictureStore getInstance() {
        return INSTANCE;
    }
}

