/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.picture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import javax.imageio.ImageIO;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.config.Config;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.net.ClientNetworking;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.util.ImageUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3545;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PictureTaker {
    private static final PictureTaker INSTANCE = new PictureTaker();
    private boolean hudHidden = false;
    private boolean takePicture = false;
    private BufferedImage picture;
    private int maxImageBytes;
    private int maxImageResolution;

    private PictureTaker() {
    }

    public void uploadScreenPicture() {
        if (this.takePicture) {
            return;
        }
        this.takePicture = true;
        this.hudHidden = class_310.method_1551().field_1690.field_1842;
        class_310.method_1551().field_1690.field_1842 = true;
    }

    public boolean tryUploadFile(Path filePath) {
        try {
            this.picture = ImageIO.read(filePath.toFile());
            ClientNetworking.sendToServer(new NewPicturePacket());
            return true;
        }
        catch (IOException e) {
            Camerapture.LOGGER.error("failed to read picture from file", (Throwable)e);
            return false;
        }
    }

    public void renderTickEnd() {
        if (!this.takePicture) {
            return;
        }
        class_310 client = class_310.method_1551();
        this.takePicture = false;
        client.field_1690.field_1842 = this.hudHidden;
        try (class_1011 nativeImage = class_318.method_1663((class_276)client.method_1522());){
            this.picture = ImageUtil.fromNativeImage(nativeImage, false);
        }
        class_3545<class_1268, class_1799> activeCamera = Camerapture.findCamera((class_1657)client.field_1724, true);
        if (activeCamera != null) {
            CameraItem.setActive((class_1799)activeCamera.method_15441(), false);
        }
        ClientNetworking.sendToServer(new NewPicturePacket());
    }

    public void sendStoredPicture(UUID uuid) {
        block5: {
            if (this.picture == null) {
                return;
            }
            try {
                BufferedImage picture = ImageUtil.clampSize(this.picture, this.maxImageResolution);
                float factor = 1.0f;
                byte[] bytes = ImageUtil.compressIntoWebP(picture, factor);
                while (bytes.length > this.maxImageBytes) {
                    if (factor < 0.1f) {
                        throw new IOException("image too big, even at 10% compression (" + bytes.length + " bytes)");
                    }
                    bytes = ImageUtil.compressIntoWebP(picture, factor -= 0.05f);
                }
                Camerapture.LOGGER.debug("sending picture ({} bytes, {}%)", (Object)bytes.length, (Object)((int)(factor * 100.0f)));
                ByteCollector.split(bytes, 30000, (section, bytesLeft) -> ClientNetworking.sendToServer(new UploadPartialPicturePacket(uuid, section, bytesLeft)));
                ClientPictureStore.getInstance().processReceivedImage(uuid, picture);
                ClientPictureStore.getInstance().cacheBytesToDisk(uuid, bytes);
                this.picture = null;
            }
            catch (IOException e) {
                Camerapture.LOGGER.error("failed to send picture to server", (Throwable)e);
                this.picture = null;
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) break block5;
                player.method_43496((class_2561)class_2561.method_43471((String)"text.camerapture.upload_failed").method_27692(class_124.field_1061));
            }
        }
    }

    public void resetConfig() {
        Config config = Camerapture.CONFIG_MANAGER.getConfig();
        this.maxImageBytes = config.server.maxImageBytes;
        this.maxImageResolution = config.server.maxImageResolution;
    }

    public void setConfig(int maxImageBytes, int maxImageResolution) {
        Camerapture.LOGGER.info("setting max image size to {} bytes, max resolution to {}", (Object)maxImageBytes, (Object)maxImageResolution);
        this.maxImageBytes = maxImageBytes;
        this.maxImageResolution = maxImageResolution;
    }

    public static PictureTaker getInstance() {
        return INSTANCE;
    }
}

