/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_7413;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class PictureFrameEntityRenderer
extends class_897<PictureFrameEntity> {
    public static final double DISTANCE_FROM_WALL = 0.01;

    public PictureFrameEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(PictureFrameEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_3966 hitResult;
        class_239 class_2392;
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        matrices.method_22904(0.5 - (double)entity.getFrameWidth() / 2.0, -0.5 + (double)entity.getFrameHeight() / 2.0, 0.0);
        class_310 client = class_310.method_1551();
        if (!this.field_4676.field_4692.field_1842 && !Camerapture.hasActiveCamera((class_1657)client.field_1724) && (class_2392 = client.field_1765) instanceof class_3966 && (hitResult = (class_3966)class_2392).method_17782() == entity) {
            this.renderOutline(matrices, vertexConsumers, entity.getFrameWidth(), entity.getFrameHeight());
        }
        matrices.method_22904(0.0, 0.0, 0.02625);
        matrices.method_22905(0.0625f, 0.0625f, 0.0625f);
        class_1799 itemStack = entity.getItemStack();
        if (itemStack == null) {
            this.renderErrorText(matrices, vertexConsumers);
        } else {
            PictureItem.PictureData pictureData = PictureItem.getPictureData(itemStack);
            if (pictureData == null) {
                this.renderErrorText(matrices, vertexConsumers);
            } else {
                RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(pictureData.id());
                if (picture == null || picture.getStatus() == RemotePicture.Status.ERROR) {
                    this.renderErrorText(matrices, vertexConsumers);
                } else if (picture.getStatus() == RemotePicture.Status.FETCHING) {
                    this.renderFetching(matrices, vertexConsumers);
                } else {
                    matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f * (float)entity.getRotation()));
                    this.renderPicture(matrices, vertexConsumers, picture, entity.getRotation(), (float)entity.getFrameWidth() * 16.0f, (float)entity.getFrameHeight() * 16.0f, entity.isPictureGlowing(), light);
                }
            }
        }
        matrices.method_22909();
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public void renderPicture(class_4587 matrices, class_4597 vertexConsumers, RemotePicture picture, int rotation, float frameWidth, float frameHeight, boolean glowing, int light) {
        float pictureWidth = picture.getWidth();
        float pictureHeight = picture.getHeight();
        if (rotation % 2 == 1) {
            pictureWidth = picture.getHeight();
            pictureHeight = picture.getWidth();
        }
        float scaledWidth = frameWidth / pictureWidth;
        float scaleHeight = frameHeight / pictureHeight;
        float scale = Math.min(scaledWidth, scaleHeight);
        float width = (float)picture.getWidth() * scale;
        float height = (float)picture.getHeight() * scale;
        float x1 = -width / 2.0f;
        float x2 = width / 2.0f;
        float y1 = -height / 2.0f;
        float y2 = height / 2.0f;
        if (glowing) {
            class_289 tessellator = class_289.method_1348();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(class_757::method_34548);
            RenderSystem.setShaderTexture((int)0, (class_2960)picture.getTextureIdentifier());
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
            class_4587.class_4665 matrix = matrices.method_23760();
            this.pushGlowingVertex((class_4588)buffer, matrix, x1, y1, 1.0f, 1.0f);
            this.pushGlowingVertex((class_4588)buffer, matrix, x1, y2, 1.0f, 0.0f);
            this.pushGlowingVertex((class_4588)buffer, matrix, x2, y2, 0.0f, 0.0f);
            this.pushGlowingVertex((class_4588)buffer, matrix, x2, y1, 0.0f, 1.0f);
            tessellator.method_1350();
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        } else {
            class_1921 renderLayer = class_1921.method_23576((class_2960)picture.getTextureIdentifier());
            class_4588 buffer = vertexConsumers.getBuffer(renderLayer);
            class_4587.class_4665 matrix = matrices.method_23760();
            this.pushCutoutVertex(buffer, matrix, x1, y1, 1.0f, 1.0f, light);
            this.pushCutoutVertex(buffer, matrix, x1, y2, 1.0f, 0.0f, light);
            this.pushCutoutVertex(buffer, matrix, x2, y2, 0.0f, 0.0f, light);
            this.pushCutoutVertex(buffer, matrix, x2, y1, 0.0f, 1.0f, light);
        }
    }

    private void pushGlowingVertex(class_4588 buffer, class_4587.class_4665 matrix, float x, float y, float u, float v) {
        Matrix4f matrix4f = matrix.method_23761();
        Matrix3f matrix3f = matrix.method_23762();
        buffer.method_22918(matrix4f, x, y, 0.0f).method_39415(-1).method_22913(u, v).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, 0.0f, 1.0f).method_1344();
    }

    private void pushCutoutVertex(class_4588 buffer, class_4587.class_4665 matrix, float x, float y, float u, float v, int light) {
        Matrix4f matrix4f = matrix.method_23761();
        Matrix3f matrix3f = matrix.method_23762();
        buffer.method_22918(matrix4f, x, y, 0.0f).method_39415(-1).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix3f, 0.0f, 0.0f, 1.0f).method_1344();
    }

    public void renderOutline(class_4587 matrices, class_4597 vertexConsumers, float frameWidth, float frameHeight) {
        class_265 shape = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)frameWidth, (double)frameHeight, (double)0.0625);
        class_761.method_22983((class_4587)matrices, (class_4588)vertexConsumers.getBuffer(class_1921.method_23594()), (class_265)shape, (double)(-frameWidth / 2.0f), (double)(-frameHeight / 2.0f), (double)-0.03125, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (boolean)true);
    }

    public void renderFetching(class_4587 matrices, class_4597 vertexConsumers) {
        matrices.method_22905(-0.25f, -0.25f, 0.25f);
        String loading = class_7413.method_43449((long)System.currentTimeMillis());
        class_5250 fetching = class_2561.method_43471((String)"text.camerapture.fetching_picture");
        class_327 class_3272 = this.method_3932();
        Objects.requireNonNull(this.method_3932());
        this.drawCenteredText(class_3272, (class_2561)fetching, 0.0f, (float)(-9) - 0.5f, 0xFFFFFF, matrices, vertexConsumers);
        this.drawCenteredText(this.method_3932(), (class_2561)class_2561.method_43470((String)loading), 0.0f, 0.5f, 0x808080, matrices, vertexConsumers);
    }

    public void renderErrorText(class_4587 matrices, class_4597 vertexConsumers) {
        matrices.method_22905(-0.25f, -0.25f, 0.25f);
        class_5250 text = class_2561.method_43471((String)"text.camerapture.fetching_failed").method_27692(class_124.field_1061);
        class_327 class_3272 = this.method_3932();
        Objects.requireNonNull(this.method_3932());
        this.drawCenteredText(class_3272, (class_2561)text, 0.0f, (float)(-9) / 2.0f, 0xFFFFFF, matrices, vertexConsumers);
    }

    private void drawCenteredText(class_327 textRenderer, class_2561 text, float x, float y, int color, class_4587 matrices, class_4597 vertexConsumers) {
        float width = textRenderer.method_27525((class_5348)text);
        textRenderer.method_30882(text, x - width / 2.0f, y, color, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0x7F000000, 0xF000F0);
    }

    public class_2960 getTexture(PictureFrameEntity entity) {
        return null;
    }

    protected int getBlockLight(PictureFrameEntity entity, class_2338 pos) {
        return entity.isPictureGlowing() ? 15 : super.method_24087((class_1297)entity, pos);
    }

    protected boolean hasLabel(PictureFrameEntity entity) {
        class_3966 hitResult;
        class_239 class_2392;
        if (class_310.method_1498() && entity.method_16914() && (class_2392 = class_310.method_1551().field_1765) instanceof class_3966 && (hitResult = (class_3966)class_2392).method_17782() == entity) {
            double d = this.field_4676.method_23168((class_1297)entity);
            return d < 4096.0;
        }
        return false;
    }

    protected void renderLabelIfPresent(PictureFrameEntity entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entity.method_36454()));
        matrices.method_46416(-((float)entity.getFrameWidth() - 1.0f) / 2.0f, (float)entity.getFrameHeight() - 2.0f, 0.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-180.0f + entity.method_36454()));
        super.method_3926((class_1297)entity, entity.method_5797(), matrices, vertexConsumers, light);
        matrices.method_22909();
    }
}

