/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1451;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4719;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.p3pp3rf1y.sophisticatedcore.api.IDisplaySideStorage;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.MenuProviderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChestBlock
extends WoodStorageBlockBase
implements class_3737,
IDisplaySideStorage {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<class_2745> TYPE = class_2741.field_12506;
    protected static final class_265 AABB = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final class_265 NORTH_AABB = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final class_265 SOUTH_AABB = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final class_265 WEST_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final class_265 EAST_AABB = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);

    public ChestBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        this(numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier, 2.5f);
    }

    public ChestBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance) {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(2.5f, explosionResistance).method_9626(class_2498.field_11547), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TICKING, (Comparable)Boolean.valueOf(false))).method_11657(TYPE, (Comparable)class_2745.field_12569));
    }

    public static boolean isChestBlockedAt(class_1936 level, class_2338 pos) {
        return ChestBlock.isBlockedChestByBlock((class_1922)level, pos) || ChestBlock.isCatSittingOnChest(level, pos);
    }

    private static boolean isBlockedChestByBlock(class_1922 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10084();
        return level.method_8320(blockpos).method_26212(level, blockpos);
    }

    public static class_2350 getConnectedDirection(class_2680 blockState) {
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)FACING);
        return blockState.method_11654(TYPE) == class_2745.field_12574 ? direction.method_10170() : direction.method_10160();
    }

    private static boolean isCatSittingOnChest(class_1936 level, class_2338 pos) {
        List list = level.method_18467(class_1451.class, new class_238((double)pos.method_10263(), (double)pos.method_10264() + 1.0, (double)pos.method_10260(), (double)pos.method_10263() + 1.0, (double)pos.method_10264() + 2.0, (double)pos.method_10260() + 1.0));
        if (!list.isEmpty()) {
            for (class_1451 cat : list) {
                if (!cat.method_6172()) continue;
                return true;
            }
        }
        return false;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (level.method_35230(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).map(StorageBlockEntity::isBeingUpgraded).orElse(false).booleanValue()) {
            return state;
        }
        if (Boolean.TRUE.equals(state.method_11654((class_2769)WATERLOGGED))) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (this.isSameChest(facingState, level, currentPos, facingPos) && facing.method_10166().method_10179()) {
            class_2745 chesttype = (class_2745)facingState.method_11654(TYPE);
            if (state.method_11654(TYPE) == class_2745.field_12569 && chesttype != class_2745.field_12569 && state.method_11654((class_2769)FACING) == facingState.method_11654((class_2769)FACING) && ChestBlock.getConnectedDirection(facingState) == facing.method_10153()) {
                level.method_35230(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(be -> {
                    class_2248 patt6185$temp = state.method_26204();
                    if (patt6185$temp instanceof ChestBlock) {
                        ChestBlock chestBlock = (ChestBlock)patt6185$temp;
                        if (be.getStorageWrapper().getInventoryHandler().getSlotCount() <= chestBlock.getNumberOfInventorySlots()) {
                            ChestBlock.joinWithChest(level, facingPos, chesttype.method_11824(), be);
                        }
                    }
                    if (be.isMainChest()) {
                        be.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
                    }
                });
                return (class_2680)state.method_11657(TYPE, (Comparable)chesttype.method_11824());
            }
        } else if (ChestBlock.getConnectedDirection(state) == facing) {
            level.method_35230(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(be -> {
                if (!level.method_8608() && !be.isBeingUpgraded()) {
                    class_2248 patt6831$temp;
                    if (be.isMainChest() && (patt6831$temp = state.method_26204()) instanceof ChestBlock) {
                        ChestBlock chestBlock = (ChestBlock)patt6831$temp;
                        be.dropSecondPartContents(chestBlock, facingPos);
                    } else if (!be.isMainChest()) {
                        be.removeDoubleMainPos();
                    }
                }
            });
            return (class_2680)state.method_11657(TYPE, (Comparable)class_2745.field_12569);
        }
        return super.method_9559(state, facing, facingState, level, currentPos, facingPos);
    }

    private boolean isSameChest(class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (!facingState.method_27852((class_2248)this)) {
            return false;
        }
        return level.method_35230(facingPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).flatMap(facingBE -> level.method_35230(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).map(currentBE -> currentBE.isPacked() == facingBE.isPacked() && currentBE.getStorageWrapper().getMainColor() == facingBE.getStorageWrapper().getMainColor() && currentBE.getStorageWrapper().getAccentColor() == facingBE.getStorageWrapper().getAccentColor() && currentBE.getWoodType().orElse(class_4719.field_21679) == facingBE.getWoodType().orElse(class_4719.field_21679))).orElse(false);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (state.method_11654(TYPE) == class_2745.field_12569) {
            return AABB;
        }
        return switch (ChestBlock.getConnectedDirection(state)) {
            case class_2350.field_11035 -> SOUTH_AABB;
            case class_2350.field_11039 -> WEST_AABB;
            case class_2350.field_11034 -> EAST_AABB;
            default -> NORTH_AABB;
        };
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        class_1799 chestBeingPlaced = context.method_8041();
        if (ChestBlockItem.isDoubleChest(chestBeingPlaced)) {
            class_2338 otherPartPos = context.method_8037().method_10093(context.method_8042().method_10170());
            class_1937 level = context.method_8045();
            if (!level.method_8320(otherPartPos).method_26166(context) || !level.method_8621().method_11952(otherPartPos)) {
                return null;
            }
        }
        class_2350 direction = context.method_8042().method_10153();
        return this.getStateForPlacement(context, direction, fluidstate, StorageBlockItem.getMainColorFromStack(chestBeingPlaced).orElse(-1), StorageBlockItem.getAccentColorFromStack(chestBeingPlaced).orElse(-1), WoodStorageBlockItem.getWoodType(chestBeingPlaced).orElse(class_4719.field_21679), InventoryHelper.isEmpty((SlottedStackStorage)StackStorageWrapper.fromData(chestBeingPlaced).getUpgradeHandler()));
    }

    private class_2680 getStateForPlacement(class_1750 context, class_2350 direction, class_3610 fluidstate, int mainColor, int accentColor, class_4719 woodType, boolean itemHasNoUpgrades) {
        class_2350 partnerFacing;
        class_2745 chestType = class_2745.field_12569;
        class_2350 clickedFace = context.method_8038();
        boolean isHoldingSneak = context.method_8046();
        if (clickedFace.method_10166().method_10179() && isHoldingSneak && (partnerFacing = this.candidatePartnerFacing(context, clickedFace.method_10153(), mainColor, accentColor, woodType, itemHasNoUpgrades)) != null && partnerFacing.method_10166() != clickedFace.method_10166()) {
            direction = partnerFacing;
            class_2745 class_27452 = chestType = partnerFacing.method_10160() == clickedFace.method_10153() ? class_2745.field_12571 : class_2745.field_12574;
        }
        if (chestType == class_2745.field_12569 && !isHoldingSneak) {
            if (direction == this.candidatePartnerFacing(context, direction.method_10170(), mainColor, accentColor, woodType, itemHasNoUpgrades)) {
                chestType = class_2745.field_12574;
            } else if (direction == this.candidatePartnerFacing(context, direction.method_10160(), mainColor, accentColor, woodType, itemHasNoUpgrades)) {
                chestType = class_2745.field_12571;
            }
        }
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657(TYPE, (Comparable)chestType)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15772() == class_3612.field_15910));
    }

    @Nullable
    private class_2350 candidatePartnerFacing(class_1750 context, class_2350 direction, int mainColor, int accentColor, class_4719 woodType, boolean itemHasNoUpgrades) {
        class_2338 neighborChestPos = context.method_8037().method_10093(direction);
        class_2680 blockstate = context.method_8045().method_8320(neighborChestPos);
        if (!blockstate.method_27852((class_2248)this) || blockstate.method_11654(TYPE) != class_2745.field_12569) {
            return null;
        }
        if (context.method_8045().method_35230(neighborChestPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).map(be -> mainColor == be.getStorageWrapper().getMainColor() && accentColor == be.getStorageWrapper().getAccentColor() && woodType == be.getWoodType().orElse(class_4719.field_21679) && (itemHasNoUpgrades || InventoryHelper.isEmpty((SlottedStackStorage)be.getStorageWrapper().getUpgradeHandler()))).orElse(false).booleanValue()) {
            return (class_2350)blockstate.method_11654((class_2769)FACING);
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.field_9236 ? ChestBlock.createTickerHelper(blockEntityType, ModBlocks.CHEST_BLOCK_ENTITY_TYPE, (l, p, s, be) -> ChestBlockEntity.lidAnimateTick(be)) : super.method_31645(level, state, blockEntityType);
    }

    public class_3610 method_9545(class_2680 state) {
        return Boolean.TRUE.equals(state.method_11654((class_2769)WATERLOGGED)) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (ChestBlock.isChestBlockedAt((class_1936)level, pos) || state.method_11654(TYPE) != class_2745.field_12569 && ChestBlock.isChestBlockedAt((class_1936)level, pos.method_10093(ChestBlock.getConnectedDirection(state)))) {
            return class_1269.field_5811;
        }
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, ChestBlockEntity.class).map(b -> {
            class_2338 mainChestPos;
            class_1799 stackInHand = player.method_5998(hand);
            if (!b.isMainChest()) {
                mainChestPos = pos.method_10093(ChestBlock.getConnectedDirection(state));
                b = WorldHelper.getBlockEntity((class_1922)level, (class_2338)mainChestPos, ChestBlockEntity.class).orElse(b);
            } else {
                mainChestPos = pos;
            }
            if (b.isPacked()) {
                return class_1269.field_5811;
            }
            if (level.field_9236 || hand == class_1268.field_5810) {
                return class_1269.field_5812;
            }
            if (this.tryItemInteraction(player, hand, (WoodStorageBlockEntity)b, stackInHand, (class_2350)state.method_11654((class_2769)FACING), hitResult)) {
                return class_1269.field_5812;
            }
            player.method_7259(class_3468.field_15419.method_14956((Object)class_3468.field_15395));
            player.method_17355((class_3908)MenuProviderHelper.createMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, mainChestPos), (class_2561)b.method_5476(), (class_2338)mainChestPos));
            class_4838.method_24733((class_1657)player, (boolean)true);
            return class_1269.field_21466;
        }).orElse(class_1269.field_5811);
    }

    @Override
    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2745 chestType;
        super.method_9567(level, pos, state, placer, stack);
        if (ChestBlockItem.isDoubleChest(stack) && !level.method_8608()) {
            class_2338 otherPartPos = pos.method_10093(((class_2350)state.method_11654((class_2769)FACING)).method_10160());
            level.method_8652(otherPartPos, (class_2680)state.method_11657(TYPE, (Comparable)class_2745.field_12574), 3);
            level.method_35230(otherPartPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(be -> {
                this.setRenderBlockRenderProperties(stack, (WoodStorageBlockEntity)be);
                be.setMainPos(pos);
                be.tryToAddToController();
            });
        }
        if ((chestType = (class_2745)state.method_11654(TYPE)) == class_2745.field_12569 || level.method_8608()) {
            return;
        }
        class_2338 otherPos = pos.method_10093(ChestBlock.getConnectedDirection(state));
        ChestBlock.joinChests((class_1936)level, pos, otherPos, chestType);
        state.method_30101((class_1936)level, pos, 3);
    }

    private static void joinChests(class_1936 level, class_2338 pos, class_2338 otherPos, class_2745 currentChestType) {
        level.method_35230(pos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(currentBE -> ChestBlock.joinWithChest(level, otherPos, currentChestType, currentBE));
    }

    private static void joinWithChest(class_1936 level, class_2338 otherPos, class_2745 currentChestType, ChestBlockEntity currentBE) {
        level.method_35230(otherPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(otherBE -> {
            if (InventoryHelper.isEmpty((SlottedStackStorage)currentBE.getStorageWrapper().getUpgradeHandler()) && (currentChestType == class_2745.field_12574 || !InventoryHelper.isEmpty((SlottedStackStorage)otherBE.getStorageWrapper().getUpgradeHandler()))) {
                currentBE.joinWithChest((ChestBlockEntity)otherBE);
                currentBE.syncTogglesFrom((ChestBlockEntity)otherBE);
            } else {
                otherBE.joinWithChest(currentBE);
                otherBE.syncTogglesFrom(currentBE);
            }
        });
    }

    @Override
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (state.method_11654(TYPE) != class_2745.field_12569) {
            level.method_35230(pos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(be -> {
                be.setDestroyedByPlayer();
                if (be.isPacked() && !be.isMainChest()) {
                    class_2338 otherPartPos = pos.method_10093(ChestBlock.getConnectedDirection(state));
                    level.method_35230(otherPartPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(mainBe -> be.getStorageWrapper().load(mainBe.getStorageWrapper().save(new class_2487())));
                }
            });
        }
        return super.method_9576(level, pos, state, player);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (state.method_11654(TYPE) != class_2745.field_12569) {
            level.method_35230(pos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(be -> {
                if (be.isPacked()) {
                    level.method_8650(pos.method_10093(ChestBlock.getConnectedDirection(state)), false);
                }
            });
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @Override
    public void addDropData(class_1799 stack, StorageBlockEntity be) {
        ChestBlockEntity chestBlockEntity;
        if (be instanceof ChestBlockEntity && (chestBlockEntity = (ChestBlockEntity)be).isPacked() && be.method_11010().method_11654(TYPE) != class_2745.field_12569) {
            super.addDropData(stack, be);
            ChestBlockItem.setDoubleChest(stack, true);
        } else {
            super.addDropData(stack, be);
        }
    }

    @Override
    protected void packStorage(class_1657 player, class_1268 hand, WoodStorageBlockEntity b, class_1799 stackInHand) {
        super.packStorage(player, hand, b, stackInHand);
        if (b.method_11010().method_11654(TYPE) == class_2745.field_12569) {
            return;
        }
        player.method_37908().method_35230(b.method_11016().method_10093(ChestBlock.getConnectedDirection(b.method_11010())), ModBlocks.CHEST_BLOCK_ENTITY_TYPE).ifPresent(be -> super.packStorage(player, hand, (WoodStorageBlockEntity)be, stackInHand));
    }

    @Override
    @Nullable
    public ChestBlockEntity newBlockEntity(class_2338 pos, class_2680 state) {
        return new ChestBlockEntity(pos, state);
    }

    public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, TICKING, TYPE});
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).ifPresent(StorageBlockEntity::recheckOpen);
    }

    @Override
    protected class_2591<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.CHEST_BLOCK_ENTITY_TYPE;
    }

    @Override
    public class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)FACING);
    }

    public boolean canChangeDisplaySide(class_2680 state) {
        return state.method_11654(TYPE) != class_2745.field_12569;
    }

    @Override
    public class_2338 getNeighborPos(class_2680 state, class_2338 origin, class_2350 facing) {
        if (state.method_11654(TYPE) == class_2745.field_12569) {
            return origin.method_10093(facing);
        }
        if (ChestBlock.getConnectedDirection(state) == facing) {
            return origin.method_10093(facing).method_10093(facing);
        }
        return origin.method_10093(facing);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        if (state.method_11654(TYPE) != class_2745.field_12569 && pos.method_10093(ChestBlock.getConnectedDirection(state)).equals((Object)neighborPos)) {
            return;
        }
        super.method_9612(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Override
    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        super.method_9548(state, level, pos, entity);
        if (!level.field_9236 && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, ChestBlockEntity.class).ifPresent(be -> this.tryToPickup(level, itemEntity, be.getMainStorageWrapper()));
        }
    }

    @Override
    protected Vector3f getMiddleFacePoint(class_2680 state, class_2338 pos, class_2350 facing, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        float xOffset = 0.0f;
        class_2745 type = (class_2745)state.method_11654(TYPE);
        if (type == class_2745.field_12574) {
            xOffset = -0.5f;
        } else if (type == class_2745.field_12571) {
            xOffset = 0.5f;
        }
        point.add(xOffset, 0.0f, 0.6f);
        point.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
        point.rotate((Quaternionfc)facing.method_23224());
        point.add((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
        return point;
    }
}

