/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5561;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;

public abstract class StorageBlockEntity
extends class_2586
implements IControllableStorage,
ILinkable,
ILockable,
class_1275,
ITierDisplay,
IUpgradeDisplay,
RenderAttachmentBlockEntity {
    public static final String STORAGE_WRAPPER_TAG = "storageWrapper";
    private final StorageWrapper storageWrapper = new StorageWrapper(() -> () -> ((StorageBlockEntity)this).method_5431(), () -> WorldHelper.notifyBlockUpdate((class_2586)this), () -> {
        this.method_5431();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }, this instanceof BarrelBlockEntity ? 4 : 1){

        public Optional<UUID> getContentsUuid() {
            if (this.contentsUuid == null) {
                this.contentsUuid = UUID.randomUUID();
                this.save();
            }
            return Optional.of(this.contentsUuid);
        }

        public class_1799 getWrappedStorageStack() {
            class_2338 pos = StorageBlockEntity.this.method_11016();
            class_2680 state = StorageBlockEntity.this.method_11010();
            class_1799 clonedStack = state.method_26204() instanceof BlockPickInteractionAware ? ((BlockPickInteractionAware)state.method_26204()).getPickedStack(state, (class_1922)StorageBlockEntity.this.method_10997(), pos, null, (class_239)new class_3965(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), class_2350.field_11033, pos, true)) : state.method_26204().method_9574((class_4538)StorageBlockEntity.this.method_10997(), pos, state);
            return StorageBlockEntity.this.addWrappedStorageStackData(clonedStack, state);
        }

        @Override
        protected void onUpgradeRefresh() {
            class_2248 class_22482;
            if (!StorageBlockEntity.this.isDroppingContents && StorageBlockEntity.this.field_11863 != null && !((StorageBlockEntity)StorageBlockEntity.this).field_11863.field_9236 && (class_22482 = StorageBlockEntity.this.method_11010().method_26204()) instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)class_22482;
                storageBlock.setTicking(StorageBlockEntity.this.field_11863, StorageBlockEntity.this.method_11016(), StorageBlockEntity.this.method_11010(), !StorageBlockEntity.this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).isEmpty());
            }
        }

        @Override
        public int getDefaultNumberOfInventorySlots() {
            class_2248 class_22482 = StorageBlockEntity.this.method_11010().method_26204();
            if (class_22482 instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)class_22482;
                return storageBlock.getNumberOfInventorySlots();
            }
            return 0;
        }

        @Override
        protected boolean isAllowedInStorage(class_1799 stack) {
            return StorageBlockEntity.this.isAllowedInStorage(stack);
        }

        @Override
        public int getDefaultNumberOfUpgradeSlots() {
            class_2248 class_22482 = StorageBlockEntity.this.method_11010().method_26204();
            if (class_22482 instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)class_22482;
                return storageBlock.getNumberOfUpgradeSlots();
            }
            return 0;
        }

        public int getBaseStackSizeMultiplier() {
            int n;
            class_2248 class_22482 = StorageBlockEntity.this.method_11010().method_26204();
            if (class_22482 instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)class_22482;
                n = storageBlock.getBaseStackSizeMultiplier();
            } else {
                n = super.getBaseStackSizeMultiplier();
            }
            return n;
        }

        public String getStorageType() {
            return StorageBlockEntity.this.getStorageType();
        }

        public class_2561 getDisplayName() {
            return StorageBlockEntity.this.method_5476();
        }

        @Override
        protected boolean emptyInventorySlotsAcceptItems() {
            return !StorageBlockEntity.this.locked || StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked();
        }

        @Override
        public ITrackedContentsItemHandler getInventoryForInputOutput() {
            if (StorageBlockEntity.this.locked && StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
                if (StorageBlockEntity.this.contentsFilteredItemHandler == null) {
                    StorageBlockEntity.this.contentsFilteredItemHandler = new ContentsFilteredItemHandler(() -> super.getInventoryForInputOutput(), () -> StorageBlockEntity.this.getStorageWrapper().getInventoryHandler().getSlotTracker(), () -> (MemorySettingsCategory)StorageBlockEntity.this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
                }
                return StorageBlockEntity.this.contentsFilteredItemHandler;
            }
            return super.getInventoryForInputOutput();
        }
    };
    @Nullable
    protected class_2561 displayName = null;
    private boolean updateBlockRender = false;
    @Nullable
    private class_2338 controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean isBeingUpgraded = false;
    private boolean isDroppingContents = false;
    private boolean chunkBeingUnloaded = false;
    @Nullable
    private SlottedStackStorage cachedFailedInsertItemHandler;
    private boolean locked = false;
    private boolean showLock = true;
    private boolean showTier = true;
    private boolean showUpgrades = false;
    @Nullable
    private ContentsFilteredItemHandler contentsFilteredItemHandler = null;

    protected abstract class_5561 getOpenersCounter();

    protected StorageBlockEntity(class_2338 pos, class_2680 state, class_2591<? extends StorageBlockEntity> blockEntityType) {
        super(blockEntityType, pos, state);
        this.storageWrapper.setUpgradeCachesInvalidatedHandler(this::onUpgradeCachesInvalidated);
        ServerChunkEvents.CHUNK_UNLOAD.register((level, chunk) -> this.onChunkUnloaded());
    }

    protected class_1799 addWrappedStorageStackData(class_1799 cloneItemStack, class_2680 state) {
        return cloneItemStack;
    }

    protected abstract String getStorageType();

    protected void onUpgradeCachesInvalidated() {
        this.invalidateCapabilities();
    }

    public boolean isOpen() {
        return this.getOpenersCounter().method_31678() > 0;
    }

    public class_2561 method_5797() {
        return this.displayName;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.saveStorageWrapper(tag);
        this.saveSynchronizedData(tag);
        this.saveControllerPos(tag);
        if (this.isLinkedToController) {
            tag.method_10556("isLinkedToController", this.isLinkedToController);
        }
    }

    private void saveStorageWrapper(class_2487 tag) {
        tag.method_10566(STORAGE_WRAPPER_TAG, (class_2520)this.storageWrapper.save(new class_2487()));
    }

    private void saveStorageWrapperClientData(class_2487 tag) {
        tag.method_10566(STORAGE_WRAPPER_TAG, (class_2520)this.storageWrapper.saveData(new class_2487()));
    }

    protected void saveSynchronizedData(class_2487 tag) {
        if (this.displayName != null) {
            tag.method_10582("displayName", class_2561.class_2562.method_10867((class_2561)this.displayName));
        }
        if (this.updateBlockRender) {
            tag.method_10556("updateBlockRender", true);
        }
        if (this.locked) {
            tag.method_10556("locked", this.locked);
        }
        if (!this.showLock) {
            tag.method_10556("showLock", this.showLock);
        }
        if (!this.showTier) {
            tag.method_10556("showTier", this.showTier);
        }
        if (this.showUpgrades) {
            tag.method_10556("showUpgrades", this.showUpgrades);
        }
    }

    public void startOpen(class_1657 player) {
        if (!this.field_11865 && !player.method_7325() && this.field_11863 != null) {
            this.getOpenersCounter().method_31684(player, this.field_11863, this.method_11016(), this.method_11010());
        }
    }

    public void stopOpen(class_1657 player) {
        if (!this.field_11865 && !player.method_7325() && this.field_11863 != null) {
            this.getOpenersCounter().method_31685(player, this.field_11863, this.method_11016(), this.method_11010());
        }
    }

    public void recheckOpen() {
        if (!this.field_11865 && this.field_11863 != null) {
            this.getOpenersCounter().method_31686(this.field_11863, this.method_11016(), this.method_11010());
        }
    }

    void playSound(class_2680 state, class_3414 sound) {
        class_2248 class_22482;
        if (this.field_11863 == null || !((class_22482 = state.method_26204()) instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
        class_2382 vec3i = storageBlock.getFacing(state).method_10163();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, sound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.loadStorageWrapper(tag);
        this.loadSynchronizedData(tag);
        if (!tag.method_10545("updateTag")) {
            this.loadControllerPos(tag);
            this.isLinkedToController = NBTHelper.getBoolean((class_2487)tag, (String)"isLinkedToController").orElse(false);
        }
    }

    private void loadStorageWrapper(class_2487 tag) {
        NBTHelper.getCompound((class_2487)tag, (String)STORAGE_WRAPPER_TAG).ifPresent(this.storageWrapper::load);
    }

    public void onLoad() {
        super.onLoad();
        this.storageWrapper.onInit();
        this.registerWithControllerOnLoad();
    }

    public void loadSynchronizedData(class_2487 tag) {
        this.displayName = NBTHelper.getComponent((class_2487)tag, (String)"displayName").orElse(null);
        this.locked = NBTHelper.getBoolean((class_2487)tag, (String)"locked").orElse(false);
        this.showLock = NBTHelper.getBoolean((class_2487)tag, (String)"showLock").orElse(true);
        this.showTier = NBTHelper.getBoolean((class_2487)tag, (String)"showTier").orElse(true);
        this.showUpgrades = NBTHelper.getBoolean((class_2487)tag, (String)"showUpgrades").orElse(false);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            if (tag.method_10577("updateBlockRender")) {
                WorldHelper.notifyBlockUpdate((class_2586)this);
            }
        } else {
            this.updateBlockRender = true;
        }
    }

    public void onChunkUnloaded() {
        this.chunkBeingUnloaded = true;
    }

    public void method_11012() {
        if (!this.isBeingUpgraded && !this.chunkBeingUnloaded && this.field_11863 != null) {
            this.removeFromController();
        }
        super.method_11012();
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void setUpdateBlockRender() {
        this.updateBlockRender = true;
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10556("updateTag", true);
        this.saveStorageWrapperClientData(tag);
        this.saveSynchronizedData(tag);
        return tag;
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, StorageBlockEntity storageBlockEntity) {
        storageBlockEntity.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }

    public StorageWrapper getStorageWrapper() {
        return this.storageWrapper;
    }

    public class_2561 method_5477() {
        return this.method_5476();
    }

    public class_2561 method_5476() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.method_11010().method_26204().method_9518();
    }

    protected boolean isAllowedInStorage(class_1799 stack) {
        return true;
    }

    public void changeStorageSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        int currentInventorySlots = this.getStorageWrapper().getInventoryHandler().getSlotCount();
        this.getStorageWrapper().changeSize(additionalInventorySlots, additionalUpgradeSlots);
        this.changeSlots(currentInventorySlots + additionalInventorySlots);
    }

    public void dropContents() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        this.isDroppingContents = true;
        InventoryHelper.dropItems((SlottedStackStorage)this.storageWrapper.getInventoryHandler(), (class_1937)this.field_11863, (class_2338)this.field_11867);
        InventoryHelper.dropItems((SlottedStackStorage)this.storageWrapper.getUpgradeHandler(), (class_1937)this.field_11863, (class_2338)this.field_11867);
        this.isDroppingContents = false;
    }

    public void setCustomName(class_2561 customName) {
        this.displayName = customName;
        this.method_5431();
    }

    @Nullable
    public SlottedStackStorage getExternalItemHandler(@Nullable class_2350 side) {
        if (side == null) {
            return this.getStorageWrapper().getInventoryForInputOutput();
        }
        if (this.cachedFailedInsertItemHandler == null) {
            this.cachedFailedInsertItemHandler = new CachedFailedInsertInventoryHandler(() -> this.getStorageWrapper().getInventoryForInputOutput(), () -> this.field_11863 != null ? this.field_11863.method_8510() : 0L);
        }
        return this.cachedFailedInsertItemHandler;
    }

    public boolean shouldDropContents() {
        return true;
    }

    public void setControllerPos(class_2338 controllerPos) {
        this.controllerPos = controllerPos;
        this.method_5431();
    }

    public Optional<class_2338> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.method_5431();
    }

    public class_2338 getStorageBlockPos() {
        return this.method_11016();
    }

    public class_1937 getStorageBlockLevel() {
        return Objects.requireNonNull(this.method_10997());
    }

    public void linkToController(class_2338 controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.method_5431();
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.method_5431();
    }

    public boolean canConnectStorages() {
        return !this.isLinkedToController;
    }

    public Set<class_2338> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public boolean canBeConnected() {
        return this.isLinked() || super.canBeConnected();
    }

    public void setBeingUpgraded(boolean isBeingUpgraded) {
        this.isBeingUpgraded = isBeingUpgraded;
    }

    public boolean isBeingUpgraded() {
        return this.isBeingUpgraded;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void toggleLock() {
        if (this.locked) {
            this.unlock();
        } else {
            this.lock();
        }
    }

    public boolean memorizesItemsWhenLocked() {
        return false;
    }

    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return true;
    }

    private void lock() {
        this.locked = true;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).selectSlots(0, this.getStorageWrapper().getInventoryHandler().getSlotCount());
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateCapabilities();
        }
        this.method_5431();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    private void unlock() {
        this.locked = false;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).unselectAllSlots();
            ItemDisplaySettingsCategory itemDisplaySettings = (ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class);
            InventoryHelper.iterate((SlottedStorage)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                if (stack.method_7960()) {
                    itemDisplaySettings.itemChanged(slot.intValue());
                }
            });
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateCapabilities();
        }
        this.method_5431();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    @Override
    public boolean shouldShowLock() {
        return this.showLock;
    }

    @Override
    public void toggleLockVisibility() {
        this.showLock = !this.showLock;
        this.method_5431();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    @Override
    public boolean shouldShowTier() {
        return this.showTier;
    }

    @Override
    public void toggleTierVisiblity() {
        this.showTier = !this.showTier;
        this.method_5431();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    @Override
    public boolean shouldShowUpgrades() {
        return this.showUpgrades;
    }

    @Override
    public void toggleUpgradesVisiblity() {
        this.showUpgrades = !this.showUpgrades;
        this.method_5431();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    public void onNeighborChange(class_2338 neighborPos) {
        class_2350 direction = this.getNeighborDirection(neighborPos);
        if (direction == null) {
            return;
        }
        this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(INeighborChangeListenerUpgrade.class).forEach(upgrade -> upgrade.onNeighborChange(this.field_11863, this.field_11867, direction));
    }

    @Nullable
    protected class_2350 getNeighborDirection(class_2338 neighborPos) {
        class_2350 direction = null;
        int normalX = Integer.signum(neighborPos.method_10263() - this.field_11867.method_10263());
        int normalY = Integer.signum(neighborPos.method_10264() - this.field_11867.method_10264());
        int normalZ = Integer.signum(neighborPos.method_10260() - this.field_11867.method_10260());
        for (class_2350 value : class_2350.values()) {
            class_2382 normal = value.method_10163();
            if (normal.method_10263() != normalX || normal.method_10264() != normalY || normal.method_10260() != normalZ) continue;
            direction = value;
            break;
        }
        return direction;
    }

    public float getSlotFillPercentage(int slot) {
        return 0.0f;
    }

    private static class ContentsFilteredItemHandler
    implements ITrackedContentsItemHandler {
        private final Supplier<ITrackedContentsItemHandler> itemHandlerGetter;
        private final Supplier<ISlotTracker> slotTrackerGetter;
        private final Supplier<MemorySettingsCategory> memorySettingsGetter;

        private ContentsFilteredItemHandler(Supplier<ITrackedContentsItemHandler> itemHandlerGetter, Supplier<ISlotTracker> slotTrackerGetter, Supplier<MemorySettingsCategory> memorySettingsGetter) {
            this.itemHandlerGetter = itemHandlerGetter;
            this.slotTrackerGetter = slotTrackerGetter;
            this.memorySettingsGetter = memorySettingsGetter;
        }

        public int getSlotCount() {
            return this.itemHandlerGetter.get().getSlotCount();
        }

        @Nonnull
        public class_1799 getStackInSlot(int slot) {
            return this.itemHandlerGetter.get().getStackInSlot(slot);
        }

        public SingleSlotStorage<ItemVariant> getSlot(int slot) {
            return this.itemHandlerGetter.get().getSlot(slot);
        }

        public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
            if (this.matchesContents(resource.toStack((int)maxAmount))) {
                return this.itemHandlerGetter.get().insertSlot(slot, resource, maxAmount, ctx);
            }
            return 0L;
        }

        public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
            return this.itemHandlerGetter.get().extractSlot(slot, resource, maxAmount, ctx);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandlerGetter.get().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemVariant resource, int count) {
            return this.matchesContents(resource.toStack(count)) && this.itemHandlerGetter.get().isItemValid(slot, resource, count);
        }

        private boolean matchesContents(class_1799 stack) {
            return this.slotTrackerGetter.get().getItems().contains(stack.method_7909()) || this.memorySettingsGetter.get().matchesFilter(stack);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext ctx) {
            if (this.matchesContents(resource.toStack((int)maxAmount))) {
                return this.itemHandlerGetter.get().insert((Object)resource, maxAmount, ctx);
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext ctx) {
            return this.itemHandlerGetter.get().extract((Object)resource, maxAmount, ctx);
        }

        public Set<ItemStackKey> getTrackedStacks() {
            return this.itemHandlerGetter.get().getTrackedStacks();
        }

        public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
            this.itemHandlerGetter.get().registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
        }

        public void unregisterStackKeyListeners() {
            this.itemHandlerGetter.get().unregisterStackKeyListeners();
        }

        public boolean hasEmptySlots() {
            return this.itemHandlerGetter.get().hasEmptySlots();
        }

        public int getInternalSlotLimit(int slot) {
            return this.itemHandlerGetter.get().getInternalSlotLimit(slot);
        }

        public void setStackInSlot(int slot, @Nonnull class_1799 stack) {
            this.itemHandlerGetter.get().setStackInSlot(slot, stack);
        }
    }
}

